/*
 * Decompiled with CFR 0.152.
 */
package java.nio.charset;

import java.lang.ref.WeakReference;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import java.util.HashMap;

public class CoderResult {
    private static final int TYPE_MALFORMED = 0;
    private static final int TYPE_OVERFLOW = 1;
    private static final int TYPE_UNDERFLOW = 2;
    private static final int TYPE_UNMAPPABLE = 3;
    public static final CoderResult OVERFLOW = new CoderResult(1, 0);
    public static final CoderResult UNDERFLOW = new CoderResult(2, 0);
    private static final String[] names = new String[]{"MALFORMED", "OVERFLOW", "UNDERFLOW", "UNMAPPABLE"};
    private static final Cache malformedCache = new Cache(null){
        private /* synthetic */ CoderResult this$0;
        {
            this.this$0 = this$0;
        }

        protected CoderResult make(int length) {
            return new CoderResult(0, length);
        }
    };
    private static final Cache unmappableCache = new Cache(null){
        private /* synthetic */ CoderResult this$0;
        {
            this.this$0 = this$0;
        }

        protected CoderResult make(int length) {
            return new CoderResult(3, length);
        }
    };
    private final int type;
    private final int length;

    private CoderResult(int type, int length) {
        this.type = type;
        this.length = length;
    }

    public boolean isError() {
        return this.length > 0;
    }

    public boolean isMalformed() {
        return this.type == 0;
    }

    public boolean isOverflow() {
        return this.type == 1;
    }

    public boolean isUnderflow() {
        return this.type == 2;
    }

    public boolean isUnmappable() {
        return this.type == 3;
    }

    public int length() {
        if (this.length <= 0) {
            throw new UnsupportedOperationException();
        }
        return this.length;
    }

    public static CoderResult malformedForLength(int length) {
        return malformedCache.get(length);
    }

    public void throwException() throws CharacterCodingException {
        switch (this.type) {
            case 0: {
                throw new MalformedInputException(this.length);
            }
            case 1: {
                throw new BufferOverflowException();
            }
            case 2: {
                throw new BufferUnderflowException();
            }
            case 3: {
                throw new UnmappableCharacterException(this.length);
            }
        }
    }

    public String toString() {
        String name = names[this.type];
        if (this.length > 0) {
            return name + '[' + this.length + ']';
        }
        return name;
    }

    public static CoderResult unmappableForLength(int length) {
        return unmappableCache.get(length);
    }

    private static abstract class Cache {
        private final HashMap cache;

        private Cache() {
            Cache cache = this;
            synchronized (cache) {
                try {
                    this.cache = new HashMap();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }

        private synchronized CoderResult get(int length) {
            if (length <= 0) {
                throw new IllegalArgumentException("Non-positive length");
            }
            Integer len = new Integer(length);
            CoderResult cr = null;
            Object o = this.cache.get(len);
            if (o != null) {
                cr = (CoderResult)((WeakReference)o).get();
            }
            if (cr == null) {
                cr = this.make(length);
                this.cache.put(len, new WeakReference(cr));
            }
            return cr;
        }

        protected abstract CoderResult make(int var1);
    }
}

