/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class RenderingHints
implements Map,
Cloneable {
    private HashMap hintMap;
    public static final Key KEY_ANTIALIASING;
    public static final Object VALUE_ANTIALIAS_ON;
    public static final Object VALUE_ANTIALIAS_OFF;
    public static final Object VALUE_ANTIALIAS_DEFAULT;
    public static final Key KEY_RENDERING;
    public static final Object VALUE_RENDER_SPEED;
    public static final Object VALUE_RENDER_QUALITY;
    public static final Object VALUE_RENDER_DEFAULT;
    public static final Key KEY_DITHERING;
    public static final Object VALUE_DITHER_DISABLE;
    public static final Object VALUE_DITHER_ENABLE;
    public static final Object VALUE_DITHER_DEFAULT;
    public static final Key KEY_TEXT_ANTIALIASING;
    public static final Object VALUE_TEXT_ANTIALIAS_ON;
    public static final Object VALUE_TEXT_ANTIALIAS_OFF;
    public static final Object VALUE_TEXT_ANTIALIAS_DEFAULT;
    public static final Key KEY_FRACTIONALMETRICS;
    public static final Object VALUE_FRACTIONALMETRICS_OFF;
    public static final Object VALUE_FRACTIONALMETRICS_ON;
    public static final Object VALUE_FRACTIONALMETRICS_DEFAULT;
    public static final Key KEY_INTERPOLATION;
    public static final Object VALUE_INTERPOLATION_NEAREST_NEIGHBOR;
    public static final Object VALUE_INTERPOLATION_BILINEAR;
    public static final Object VALUE_INTERPOLATION_BICUBIC;
    public static final Key KEY_ALPHA_INTERPOLATION;
    public static final Object VALUE_ALPHA_INTERPOLATION_SPEED;
    public static final Object VALUE_ALPHA_INTERPOLATION_QUALITY;
    public static final Object VALUE_ALPHA_INTERPOLATION_DEFAULT;
    public static final Key KEY_COLOR_RENDERING;
    public static final Object VALUE_COLOR_RENDER_SPEED;
    public static final Object VALUE_COLOR_RENDER_QUALITY;
    public static final Object VALUE_COLOR_RENDER_DEFAULT;
    public static final Key KEY_STROKE_CONTROL;
    public static final Object VALUE_STROKE_DEFAULT;
    public static final Object VALUE_STROKE_NORMALIZE;
    public static final Object VALUE_STROKE_PURE;

    private /* synthetic */ void finit$() {
        this.hintMap = new HashMap();
    }

    public RenderingHints(Map init) {
        this.finit$();
        this.putAll(init);
    }

    public RenderingHints(Key key, Object value) {
        this.finit$();
        this.put(key, value);
    }

    public int size() {
        return this.hintMap.size();
    }

    public boolean isEmpty() {
        return this.hintMap.isEmpty();
    }

    public boolean containsKey(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.hintMap.containsKey((Key)key);
    }

    public boolean containsValue(Object value) {
        return this.hintMap.containsValue(value);
    }

    public Object get(Object key) {
        return this.hintMap.get((Key)key);
    }

    public Object put(Object key, Object value) {
        if (key == null || value == null) {
            throw new NullPointerException();
        }
        if (!((Key)key).isCompatibleValue(value)) {
            throw new IllegalArgumentException();
        }
        return this.hintMap.put(key, value);
    }

    public void add(RenderingHints hints) {
        this.hintMap.putAll(hints);
    }

    public void clear() {
        this.hintMap.clear();
    }

    public Object remove(Object key) {
        return this.remove((Key)key);
    }

    public void putAll(Map m) {
        this.hintMap.putAll(m);
    }

    public Set keySet() {
        return this.hintMap.keySet();
    }

    public Collection values() {
        return this.hintMap.values();
    }

    public Set entrySet() {
        return Collections.unmodifiableSet(this.hintMap.entrySet());
    }

    public boolean equals(Object o) {
        return this.hintMap.equals(o);
    }

    public int hashCode() {
        return this.hintMap.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() {
        try {
            void e;
            RenderingHints copy = (RenderingHints)super.clone();
            copy.hintMap = (HashMap)this.hintMap.clone();
            return e;
        }
        catch (CloneNotSupportedException e) {
            throw (Error)new InternalError().initCause(e);
        }
    }

    public String toString() {
        return this.hintMap.toString();
    }

    static {
        VALUE_ANTIALIAS_ON = "Antialiased rendering mode";
        VALUE_ANTIALIAS_OFF = "Nonantialiased rendering mode";
        VALUE_ANTIALIAS_DEFAULT = "Default antialiasing rendering mode";
        VALUE_RENDER_SPEED = "Fastest rendering methods";
        VALUE_RENDER_QUALITY = "Highest quality rendering methods";
        VALUE_RENDER_DEFAULT = "Default rendering methods";
        VALUE_DITHER_DISABLE = "Nondithered rendering mode";
        VALUE_DITHER_ENABLE = "Dithered rendering mode";
        VALUE_DITHER_DEFAULT = "Default dithering mode";
        VALUE_TEXT_ANTIALIAS_ON = "Antialiased text mode";
        VALUE_TEXT_ANTIALIAS_OFF = "Nonantialiased text mode";
        VALUE_TEXT_ANTIALIAS_DEFAULT = "Default antialiasing text mode";
        VALUE_FRACTIONALMETRICS_OFF = "Integer text metrics mode";
        VALUE_FRACTIONALMETRICS_ON = "Fractional text metrics mode";
        VALUE_FRACTIONALMETRICS_DEFAULT = "Default fractional text metrics mode";
        VALUE_INTERPOLATION_NEAREST_NEIGHBOR = "Nearest Neighbor image interpolation mode";
        VALUE_INTERPOLATION_BILINEAR = "Bilinear image interpolation mode";
        VALUE_INTERPOLATION_BICUBIC = "Bicubic image interpolation mode";
        VALUE_ALPHA_INTERPOLATION_SPEED = "Fastest alpha blending methods";
        VALUE_ALPHA_INTERPOLATION_QUALITY = "Highest quality alpha blending methods";
        VALUE_ALPHA_INTERPOLATION_DEFAULT = "Default alpha blending methods";
        VALUE_COLOR_RENDER_SPEED = "Fastest color rendering mode";
        VALUE_COLOR_RENDER_QUALITY = "Highest quality color rendering mode";
        VALUE_COLOR_RENDER_DEFAULT = "Default color rendering mode";
        VALUE_STROKE_DEFAULT = "Default stroke normalization";
        VALUE_STROKE_NORMALIZE = "Normalize strokes for consistent rendering";
        VALUE_STROKE_PURE = "Pure stroke conversion for accurate paths";
        KEY_ANTIALIASING = new KeyImpl(1, "Global antialiasing enable key", "Antialiased rendering mode", "Nonantialiased rendering mode", "Default antialiasing rendering mode");
        KEY_RENDERING = new KeyImpl(2, "Global rendering quality key", "Fastest rendering methods", "Highest quality rendering methods", "Default rendering methods");
        KEY_DITHERING = new KeyImpl(3, "Dithering quality key", "Nondithered rendering mode", "Dithered rendering mode", "Default dithering mode");
        KEY_TEXT_ANTIALIASING = new KeyImpl(4, "Text-specific antialiasing enable key", "Antialiased text mode", "Nonantialiased text mode", "Default antialiasing text mode");
        KEY_FRACTIONALMETRICS = new KeyImpl(5, "Fractional metrics enable key", "Integer text metrics mode", "Fractional text metrics mode", "Default fractional text metrics mode");
        KEY_INTERPOLATION = new KeyImpl(6, "Image interpolation method key", "Nearest Neighbor image interpolation mode", "Bilinear image interpolation mode", "Bicubic image interpolation mode");
        KEY_ALPHA_INTERPOLATION = new KeyImpl(7, "Alpha blending interpolation method key", "Fastest alpha blending methods", "Highest quality alpha blending methods", "Default alpha blending methods");
        KEY_COLOR_RENDERING = new KeyImpl(8, "Color rendering quality key", "Fastest color rendering mode", "Highest quality color rendering mode", "Default color rendering mode");
        KEY_STROKE_CONTROL = new KeyImpl(9, "Stroke normalization control key", "Default stroke normalization", "Normalize strokes for consistent rendering", "Pure stroke conversion for accurate paths");
    }

    private static final class KeyImpl
    extends Key {
        final String description;
        final Object v1;
        final Object v2;
        final Object v3;

        KeyImpl(int privateKey, String description, Object v1, Object v2, Object v3) {
            super(privateKey);
            this.description = description;
            this.v1 = v1;
            this.v2 = v2;
            this.v3 = v3;
        }

        public boolean isCompatibleValue(Object value) {
            return value == this.v1 || value == this.v2 || value == this.v3;
        }

        public String toString() {
            return this.description;
        }
    }

    public static abstract class Key {
        private final int key;

        protected Key(int privateKey) {
            this.key = privateKey;
        }

        public abstract boolean isCompatibleValue(Object var1);

        protected final int intKey() {
            return this.key;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public final boolean equals(Object other) {
            return this == other;
        }
    }
}

