/*
 * Copyright (C) 2002 Edscott Wilson Garcia
 * EMail: edscott@imp.mx
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <sys/types.h>
#include <sys/stat.h>
#include <unistd.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>


#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>


#include "constants.h"
#include "types.h"
#include "entry.h"

/***********  treestore ***************/



GtkTreeStore *create_treestore(void)
{
    column_info_t column_info[] = {
	{EMPTY_COLUMN, G_TYPE_STRING},
	{ENTRY_COLUMN, G_TYPE_POINTER},
	{STYLE_COLUMN, PANGO_TYPE_STYLE},
	{FONT_COLUMN, PANGO_TYPE_FONT_DESCRIPTION},

	{PIXBUF_COLUMN, GDK_TYPE_PIXBUF},
	{NAME_COLUMN, G_TYPE_STRING},
	{SIZE_COLUMN, G_TYPE_STRING},
	{DATE_COLUMN, G_TYPE_STRING},
	{OWNER_COLUMN, G_TYPE_STRING},
	{GROUP_COLUMN, G_TYPE_STRING},
	{MODE_COLUMN, G_TYPE_STRING}
    };
    return (gtk_tree_store_new(TREE_COLUMNS, 
		column_info[EMPTY_COLUMN].type, 
		column_info[ENTRY_COLUMN].type, 
		column_info[STYLE_COLUMN].type, 
		column_info[FONT_COLUMN].type, 

		column_info[PIXBUF_COLUMN].type, 
		column_info[NAME_COLUMN].type, 
		column_info[SIZE_COLUMN].type, 
		column_info[DATE_COLUMN].type, 
		column_info[OWNER_COLUMN].type, 
		column_info[GROUP_COLUMN].type, 
		column_info[MODE_COLUMN].type));
}

void destroy_tree(GtkTreeModel * treemodel)
{
    gtk_tree_model_foreach(treemodel, destroy_node_entry, NULL);
    /* tree_details cleanup */
    gtk_tree_store_clear((GtkTreeStore *) treemodel);
}
