/*
 * Copyright (C) 2001-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: utils.c,v 1.14 2003/03/20 19:03:07 guenter Exp $
 *
 * needful things
 */

#include <config.h>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <sys/stat.h>
#include <sys/types.h>
#include <fcntl.h>
#include <string.h>

#include <glib.h>
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gtk/gtk.h>

#include "utils.h"
#include "http.h"

void ensure_path_exists (char *path) {

  char *sep, *start;

  start = path;
  while ( (sep = strchr (start, '/')) ) {

    *sep = 0;

    printf ("mkdir %s...\n", path);

    mkdir (path, 0755);
    
    *sep = '/';

    start = sep+1;
  }

  printf ("mkdir %s...\n", path);

  mkdir (path, 0755);
}

char *read_entire_file (const char *mrl, int *file_size) {

  char        *buf;
  struct stat  statb;
  int          fd;

  if (!strncasecmp (mrl, "http://", 7)) 
    return http_download (mrl, file_size);

  if (stat (mrl, &statb) < 0) {
    printf ("utils: cannot stat '%s'\n", mrl);
    return NULL;
  }

  *file_size = statb.st_size;

  fd = open (mrl, O_RDONLY);
  if (fd<0)
    return NULL;

  /* workaround to handle content without eol in playlist_add */
  buf = g_malloc ((*file_size)+2);
  buf[*file_size]='\n';
  buf[(*file_size)+1]=0;
  if (!buf)
    return NULL;

  *file_size = read (fd, buf, *file_size);

  close (fd);

  return buf;
}

char *read_entire_file_unicode (const char *mrl) {

  char *unicode, *ascii;
  int   len, i, j;

  unicode = read_entire_file (mrl, &len);

  if (!unicode)
    return NULL;

  ascii = malloc (len/2+1);

  for (i=2, j=0; i<len; i+=2, j++)
    ascii[j] = unicode[i];

  ascii[j] = 0;

  free (unicode);

  return ascii;
}

char *read_entire_file_ascii (const char *mrl) {

  char *raw, *ascii;
  int   len;

  raw = read_entire_file (mrl, &len);

  if (!raw)
    return NULL;

  ascii = malloc (len+1);

  memcpy (ascii, raw, len);

  ascii[len] = 0;

  free (raw);

  return ascii;
}

GdkPixbuf *load_icon (const char *filename) {

  GdkPixbuf *pix;
  gchar     *pathname;

  pathname = g_strconcat (GXINE_PIXMAPDIR, "/", filename, NULL);

  pix = gdk_pixbuf_new_from_file (pathname, NULL);

  g_free (pathname);

  return pix;
}

static void response_cb (GtkWidget *dialog, gint response, gpointer data) {
  char *msg;
  
  msg = g_object_get_data (G_OBJECT (dialog), "msg");
  g_free (msg);
  gtk_widget_destroy (dialog);
}


void display_error (gchar *title, gchar *fmt, ...) {

  GtkWidget *dialog;
  va_list    ap;
  gchar     *msg;
  
  va_start (ap, fmt);
  msg = g_strdup_vprintf (fmt, ap);
  va_end (ap);

  dialog = gtk_message_dialog_new (NULL,
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_ERROR,
				   GTK_BUTTONS_CLOSE,
				   msg);

  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  g_signal_connect (G_OBJECT (dialog), "response", G_CALLBACK (response_cb), NULL);
  g_object_set_data (G_OBJECT (dialog), "msg", msg);
  /* wm_manage (dialog, WM_MENU); */
  gtk_widget_show (dialog);
}

void display_info (gchar *title, gchar *fmt, ...) {

  GtkWidget *dialog;
  va_list    ap;
  gchar     *msg;
  
  va_start (ap, fmt);
  msg = g_strdup_vprintf (fmt, ap);
  va_end (ap);

  dialog = gtk_message_dialog_new (NULL,
				   GTK_DIALOG_DESTROY_WITH_PARENT,
				   GTK_MESSAGE_INFO,
				   GTK_BUTTONS_CLOSE,
				   msg);

  gtk_window_set_title (GTK_WINDOW (dialog), title);
  gtk_window_set_position (GTK_WINDOW (dialog), GTK_WIN_POS_CENTER);

  g_signal_connect (G_OBJECT (dialog), "response", G_CALLBACK (response_cb), NULL);
  g_object_set_data (G_OBJECT (dialog), "msg", msg);
  /* wm_manage (dialog, WM_MENU); */
  gtk_widget_show (dialog);
}

void int_to_timestring (gint int_time, char* string_time, gint length) {
  gint hours, minutes, seconds;

  seconds = int_time % 60;
  int_time /= 60;

  minutes = int_time % 60;
  int_time /= 60;

  hours = int_time;

  snprintf(string_time, length, "%d:%02d:%02d", hours, minutes, seconds);
}

int parse_timestring (const char *string_time) {

  gint hours, minutes, seconds;
  
  sscanf (string_time, "%d:%d:%d", &hours, &minutes, &seconds);

  return hours * 3600 + minutes * 60 + seconds;
}

static int        answer;

static gboolean ok_cb (GtkFileSelection *file_selector, gpointer user_data) {
  answer = 1;
  gtk_main_quit();
  
  return TRUE;
}

static gboolean cancel_cb (GtkFileSelection *file_selector, gpointer user_data) {
  answer = 0;
  gtk_main_quit();

  return TRUE;
}

static GtkWidget *file_dlg;


gchar *modal_file_dialog (const char *title, const gchar *pattern) {

  int        was_modal;
  
  gtk_window_set_title (GTK_WINDOW (file_dlg), title);

  if (pattern)
    gtk_file_selection_complete (GTK_FILE_SELECTION (file_dlg), pattern);
 
  gtk_file_selection_set_select_multiple (GTK_FILE_SELECTION (file_dlg), FALSE);

  answer = 0;

  /* Display that dialog */
  
  gtk_widget_show_all (file_dlg);
  gtk_widget_map (file_dlg);

  /* run as a modal dialog */

  was_modal = GTK_WINDOW(file_dlg)->modal;
  if (!was_modal) 
    gtk_window_set_modal(GTK_WINDOW(file_dlg),TRUE);

  gtk_main();

  gtk_widget_hide (file_dlg);

  if (answer)
    return g_strdup (gtk_file_selection_get_filename (GTK_FILE_SELECTION (file_dlg)));
  else
    return NULL;
}

gchar **modal_multi_file_dialog (const char *title, const gchar *pattern) {

  int        was_modal;
  
  gtk_window_set_title (GTK_WINDOW (file_dlg), title);

  if (pattern)
    gtk_file_selection_complete (GTK_FILE_SELECTION (file_dlg), pattern);
 
  gtk_file_selection_set_select_multiple (GTK_FILE_SELECTION (file_dlg), TRUE);

  answer = 0;

  /* Display that dialog */
  
  gtk_widget_show_all (file_dlg);
  gtk_widget_map (file_dlg);

  /* run as a modal dialog */

  was_modal = GTK_WINDOW(file_dlg)->modal;
  if (!was_modal) 
    gtk_window_set_modal(GTK_WINDOW(file_dlg),TRUE);

  gtk_main();

  gtk_widget_hide (file_dlg);

  if (answer)
    return gtk_file_selection_get_selections (GTK_FILE_SELECTION (file_dlg));
  else
    return NULL;
}

void normalize_to_ascii (char *str) {

  int i;
  unsigned char c;

  i = 0;
  while ( (c = str[i])) {

    if ( (c<32) || (c>0x7e) )
      str[i] = 32;
    
    i++;
  }
}

void utils_init (void) {

  /* Create the selector */
   
  file_dlg = gtk_file_selection_new ("Quaak");
   
  g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_dlg)->ok_button),
		    "clicked",
		    G_CALLBACK (ok_cb),
		    file_dlg);
  
  g_signal_connect (GTK_OBJECT (GTK_FILE_SELECTION (file_dlg)->cancel_button),
		    "clicked",
		    G_CALLBACK (cancel_cb),
		    NULL);

  g_signal_connect( GTK_OBJECT (file_dlg), "delete_event",
		    G_CALLBACK (cancel_cb), NULL );
}

