/*
 * Copyright (C) 2002-2003 the xine-project
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * $Id: settings.c,v 1.9 2003/03/08 20:26:52 guenter Exp $
 *
 * settings implementation
 */

#include <config.h>
#include <X11/Xlib.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <glib.h>
#include <stdio.h>

#include "globals.h"
#include "gtkxine.h"
#include "settings.h"

static int        is_visible;
static GtkWidget  *win;

static gboolean close_cb (GtkWidget* widget, gpointer data) {
  is_visible = FALSE;
  gtk_widget_unmap (win);

  return TRUE;
}

void settings_show (void) {
  if (is_visible) {
    is_visible = FALSE;
    gtk_widget_hide (win);
  } else {
    is_visible = TRUE;
    gtk_widget_show_all (win);
    gtk_widget_map (win);
  }
}

static void volume_cb (GtkWidget* widget, gpointer data) {

  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_VOLUME, value);
}

static void compressor_cb (GtkWidget* widget, gpointer data) {
  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_COMPR_LEVEL, value);
}

static void amp_cb (GtkWidget* widget, gpointer data) {

  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_AMP_LEVEL, value);
}

static void avsync_cb (GtkWidget* widget, gpointer data) {
  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_AV_OFFSET, value);
}

static void sat_cb (GtkWidget* widget, gpointer data) {
  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_VO_SATURATION, value);
}

static void contr_cb (GtkWidget* widget, gpointer data) {
  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_VO_CONTRAST, value);
}

static void bright_cb (GtkWidget* widget, gpointer data) {
  int value = (gint) GTK_ADJUSTMENT (data)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_VO_BRIGHTNESS, value);
}

void settings_init (void) {

  GtkWidget *vbox, *hbox, *button, *label, *table, *scale;
  GtkObject *adj;

  is_visible = 0;

  /*
   * window
   */

  win = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_window_set_title (GTK_WINDOW (win), "settings");
  gtk_window_set_default_size (GTK_WINDOW (win), 500, 150);
  gtk_signal_connect( GTK_OBJECT (win), "delete_event",
		      GTK_SIGNAL_FUNC (close_cb), NULL );

  vbox = gtk_vbox_new (0,0);

  /*
   * sliders
   */

  table = gtk_table_new (3, 2, FALSE);

  /* volume */

  label = gtk_label_new ("Volume");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 0, 1,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (gtk_xine_get_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_VOLUME),
			    0.0, 100.0, 1.0, 10.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));

  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (volume_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 0, 1,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);

  /* compressor */

  label = gtk_label_new ("Compressor");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 1, 2,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (100.0, 100.0, 1000.0, 10.0, 100.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (compressor_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 1, 2,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);

  /* amplifier */

  label = gtk_label_new ("Amplifier");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 2, 3,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (gtk_xine_get_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_AMP_LEVEL),
			    0.0, 200.0, 1.0, 10.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));

  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (amp_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 2, 3,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);


  /* a/v sync */

  label = gtk_label_new ("A/V Sync");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 3, 4,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (0.0, -180000.0, 180000.0, 1000.0, 10000.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (avsync_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 3, 4,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);

  /* saturation */

  label = gtk_label_new ("Saturation");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 4, 5,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (gtk_xine_get_param (GTK_XINE(gtx), XINE_PARAM_VO_SATURATION),
			    0.0, 65535, 100.0, 1000.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (sat_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 4, 5,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);


  /* contrast */

  label = gtk_label_new ("Contrast");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 5, 6,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (gtk_xine_get_param (GTK_XINE(gtx), XINE_PARAM_VO_CONTRAST),
			    0.0, 65535, 100.0, 1000.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (contr_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 5, 6,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);


  /* brightness */

  label = gtk_label_new ("Brightness");
  gtk_table_attach (GTK_TABLE(table), label, 0, 1, 6, 7,
		    GTK_FILL, GTK_FILL, 0, 0);

  adj = gtk_adjustment_new (gtk_xine_get_param (GTK_XINE(gtx), XINE_PARAM_VO_BRIGHTNESS),
			    0.0, 65535, 100.0, 1000.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(adj));
  gtk_signal_connect( GTK_OBJECT (adj), "value-changed",
		      GTK_SIGNAL_FUNC (bright_cb), adj );

  gtk_table_attach (GTK_TABLE(table), scale, 1, 2, 6, 7,
		    GTK_EXPAND | GTK_FILL, GTK_FILL, 0, 0);


  gtk_box_pack_start (GTK_BOX(vbox), table, TRUE, TRUE, 2);



  /*
   * button bar
   */

  hbox = gtk_hbox_new (0,2);

  button = gtk_button_new_from_stock (GTK_STOCK_CLOSE);
  gtk_signal_connect (GTK_OBJECT(button), "clicked",
		      GTK_SIGNAL_FUNC(close_cb),
		      NULL);
  gtk_box_pack_end (GTK_BOX(hbox), button, TRUE, TRUE, 2);

  gtk_box_pack_start (GTK_BOX(vbox), hbox, FALSE, FALSE, 2);

  gtk_container_add (GTK_CONTAINER (win), vbox);

}
