/* 
 * Copyright (C) 2003 the xine project
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: noskin_window.c,v 1.9 2003/03/08 20:51:26 guenter Exp $
 *
 * standard, non-skinned main window
 */

#include "noskin_window.h"

#include <stdio.h>
#include <gtk/gtk.h>

#include "globals.h"
#include "utils.h"
#include "gtkxine.h"
#include "actions.h"
#include "key_events.h"
#include "playlist.h"
#include "mediamarks.h"
#include "menu.h"
#include "drag_drop.h"

#include "playlist.xpm"
#include "play.xpm"
#include "pause.xpm"
#include "stop.xpm"
#include "speaker.xpm"
#include "sliders.xpm"
#include "fast_forward.xpm"


static GtkObject      *seeker, *vol_adj, *audio_adj;
static GtkWidget      *time_display;
static GtkTooltips    *tips;
static int             no_rekursion; /* seeker */

/*
 * drag and drop
 */

#define TARGET_STRING 0
#define TARGET_URL    1

static GtkTargetEntry target_table[] = {
  { "STRING",     0, TARGET_STRING },
  { "text/plain", 0, TARGET_STRING },
  { "text/uri-list", 0, TARGET_URL }
};


/*
 * callbacks
 */

static void control_cb (GtkWidget* widget, gpointer data) {

  char *cmd = (char *) data;

  action_exec (cmd, NULL, NULL);

  /* take focus away from this button
     (pressing 'space' for pause tends to behave strangely otherwise */
  gtk_window_set_focus(GTK_WINDOW (app), NULL);

}

void add_pix_button(GtkWidget *box, gchar **pixmap_array, char * cmd, char *tip) {
  GtkWidget *button, *icon;
  GdkPixmap *image;
  GdkBitmap *transparent;

  button = gtk_button_new();
  gtk_button_set_relief (GTK_BUTTON(button), GTK_RELIEF_NONE);
  image = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(),
						&transparent, NULL, pixmap_array);
  icon = gtk_pixmap_new(image, transparent);
  gtk_container_add(GTK_CONTAINER(button), icon);
  /* gtk_container_add(GTK_CONTAINER(box), button); */

  gtk_box_pack_start (GTK_BOX(box), button, FALSE, FALSE, 2);

  g_signal_connect (GTK_OBJECT(button), "clicked", 
		    G_CALLBACK(control_cb),
		    cmd);

  gtk_tooltips_set_tip(GTK_TOOLTIPS (tips), button,
		       tip, NULL);

  gtk_widget_show(icon);
  gtk_widget_show(button);
}

/*
 * slider
 */

static gint update_slider_cb (gpointer data) {

  gint pos_stream, pos_time, length_time;
  gfloat pos;

  if (gtk_xine_get_status (GTK_XINE(gtx)) != XINE_STATUS_PLAY)
    return TRUE;

  if (!gtk_xine_get_pos_length (GTK_XINE(gtx),
				&pos_stream, &pos_time, &length_time))
    return TRUE;

  pos = (gfloat) pos_stream;

  no_rekursion = 1;
  gtk_adjustment_set_value (GTK_ADJUSTMENT (seeker), pos); 
  no_rekursion = 0;

  {
    gint cur_time, length;
    gchar time_str[256];

    gchar curtime_str[256];
    gchar length_str[256];

    cur_time = pos_time / 1000;
    length   = length_time / 1000;

    int_to_timestring (cur_time, curtime_str, 256);
    int_to_timestring (length,   length_str, 256);

    snprintf(time_str, 256, "%s / %s", curtime_str, length_str);
    gtk_label_set_text (GTK_LABEL(time_display), time_str);
  }

  return TRUE;
}

static void seek_cb(GtkWidget* widget, gpointer data){

  if (!no_rekursion && gtk_xine_get_stream_info (GTK_XINE (gtx),
						 XINE_STREAM_INFO_SEEKABLE)) {
    gtk_xine_play (GTK_XINE (gtx), (gint) GTK_ADJUSTMENT(seeker)->value, 0); 
  }

}

static void vol_cb (GtkWidget* widget, gpointer data){

  gint vol = (gint) GTK_ADJUSTMENT (vol_adj)->value;

  gtk_xine_set_param (GTK_XINE(gtx), XINE_PARAM_AUDIO_VOLUME, vol);
}

static void audio_channel_cb (GtkWidget* widget, gpointer data){

  gint channel = (gint) GTK_ADJUSTMENT(audio_adj)->value;

  gtk_xine_set_param (GTK_XINE (gtx), XINE_PARAM_AUDIO_CHANNEL_LOGICAL,
		      channel);

}

gint close_application( GtkWidget *widget,
                        GdkEvent  *event,
                        gpointer   data ) {
  action_exec ("exit();", NULL, NULL);
  return(FALSE);
}

void noskin_main_init (gchar *audio_driver_id, gchar *video_driver_id) {

  GtkWidget     *vbox;

  GtkWidget     *infobar;

  GtkWidget     *sliderbox;
  GtkWidget     *scale, *vol_scale;

  GtkWidget     *ctrl, *menus;

  /* GtkWidget     *menu, *item; */
  GtkWidget     *audio_spinner, *icon;
  GdkPixmap     *image;
  GdkBitmap     *transparent;

  no_rekursion = 0;

  app = gtk_window_new(GTK_WINDOW_TOPLEVEL);

  g_signal_connect( GTK_OBJECT (app), "delete_event",
		    G_CALLBACK (close_application), NULL );

  gtk_widget_add_events (app, GDK_KEY_RELEASE_MASK);
  g_signal_connect (GTK_OBJECT(app), "key_press_event",
		    G_CALLBACK(key_cb), NULL);

  drag_drop_setup (app);

  /*
   * setup widgets
   */

  tips = gtk_tooltips_new ();

  vbox = gtk_vbox_new (0, 0);

  /*
   * menu, xine widget
   */

  gtx = gtk_xine_new (video_driver_id, audio_driver_id);
  drag_drop_setup (gtx);

  menus = create_menus (app);
  gtk_box_pack_start (GTK_BOX (vbox), menus, FALSE, FALSE, 0);

  gtk_box_pack_start (GTK_BOX(vbox), gtx, TRUE, TRUE, 0);

  gtk_drag_dest_set (gtx, GTK_DEST_DEFAULT_DROP,
		     target_table, 3,
		     GDK_ACTION_LINK | GDK_ACTION_COPY | GDK_ACTION_MOVE);

  /* infobar */

  bar = create_infobar (&infobar);

  gtk_box_pack_start (GTK_BOX(vbox), infobar, FALSE, FALSE, 2);

  drag_drop_setup (infobar);

  /* slider/seeker */

  sliderbox = gtk_hbox_new (0, 2);

  seeker = gtk_adjustment_new (0.0, 0.0, 65536.0, 1.0, 10.0, 1.0);
  scale = gtk_hscale_new (GTK_ADJUSTMENT(seeker));
  gtk_scale_set_draw_value (GTK_SCALE(scale), FALSE);
  g_signal_connect( GTK_OBJECT (seeker), "value-changed",
		      G_CALLBACK (seek_cb), NULL );

  time_display = gtk_label_new ("");

  gtk_box_pack_start (GTK_BOX(sliderbox), scale, TRUE, TRUE, 5);
  gtk_box_pack_end   (GTK_BOX(sliderbox), time_display, FALSE, FALSE, 5);

  gtk_box_pack_start (GTK_BOX(vbox), sliderbox, FALSE, FALSE, 2);

  /*
   * control bar
   */

  ctrl = gtk_hbox_new (0, 2);

  /* buttons */

  add_pix_button (ctrl, play_xpm, "play ();", "play");
  add_pix_button (ctrl, fast_forward_xpm, "set_speed (16);", "fast-forward");
  add_pix_button (ctrl, pause_xpm, "pause ();", "pause");
  add_pix_button (ctrl, stop_xpm, "stop ();", "stop");
  add_pix_button (ctrl, playlist_xpm, "playlist_show ()", "playlist");
  add_pix_button (ctrl, sliders_xpm, "settings_show ()", "settings");

  /* audio channel selection */

  audio_adj = gtk_adjustment_new (-1.0, -1.0, 32.0, 1.0, 1.0, 1.0);
  audio_spinner = gtk_spin_button_new (GTK_ADJUSTMENT (audio_adj),
				       1.0,0);
  gtk_spin_button_set_numeric (GTK_SPIN_BUTTON(audio_spinner), TRUE);
  gtk_tooltips_set_tip (GTK_TOOLTIPS (tips), audio_spinner,
			"audio channel", NULL);
  g_signal_connect (GTK_OBJECT (audio_adj), "value-changed",
		      G_CALLBACK (audio_channel_cb), NULL);
  gtk_box_pack_end (GTK_BOX(ctrl), audio_spinner, FALSE, FALSE, 5);

  /* volume slider */

  vol_adj = gtk_adjustment_new (80.0, /*FIXME */
				0.0, 100.0, 1.0, 1.0, 1.0);
  vol_scale = gtk_hscale_new (GTK_ADJUSTMENT (vol_adj));
  gtk_scale_set_draw_value (GTK_SCALE (vol_scale), FALSE);
  g_signal_connect (GTK_OBJECT (vol_adj), "value-changed",
		    G_CALLBACK (vol_cb), NULL );
  gtk_widget_set_size_request (vol_scale, 75, -1);  
  gtk_box_pack_end (GTK_BOX (ctrl), vol_scale, FALSE, FALSE, 5);

  /* mute button */

  image = gdk_pixmap_colormap_create_from_xpm_d(NULL, gdk_colormap_get_system(),
						&transparent, NULL, speaker_xpm);
  icon = gtk_pixmap_new(image, transparent);
  gtk_box_pack_end (GTK_BOX(ctrl), icon, FALSE, FALSE, 0);

  gtk_box_pack_end (GTK_BOX(vbox), ctrl, FALSE, FALSE, 2);

  gtk_container_add (GTK_CONTAINER (app), vbox);

  gtk_widget_show_all(app); 

  gtk_widget_hide (menus);
  gtk_widget_show (menus);
  gtk_widget_hide (gtx);
  gtk_widget_show (gtx);

#if 0
  gtk_window_set_policy (GTK_WINDOW(app), TRUE, TRUE, FALSE);
#endif
  gtk_window_set_icon  (GTK_WINDOW(app), load_icon ("gxine-logo.png"));

  postinit_infobar (app, bar);

  gtk_timeout_add (1000, update_slider_cb, NULL); 

#if 0 /* FIXME */
  /*
   * context menu
   */

  menu = gtk_menu_new ();

  item = gtk_menu_item_new_with_label ("File");
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), gtk_item_factory_get_widget (item_factory, "/File"));
  gtk_widget_show (item);
  item = gtk_menu_item_new_with_label ("View");
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), gtk_item_factory_get_widget (item_factory, "/View"));
  gtk_widget_show (item);
  item = gtk_menu_item_new_with_label ("Media");
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), gtk_item_factory_get_widget (item_factory, "/Media"));
  gtk_widget_show (item);
  item = gtk_menu_item_new_with_label ("Help");
  gtk_menu_append (GTK_MENU (menu), item);
  gtk_menu_item_set_submenu (GTK_MENU_ITEM (item), gtk_item_factory_get_widget (item_factory, "/Help"));
  gtk_widget_show (item);

  gtk_widget_add_events (app, GDK_BUTTON_PRESS_MASK);
  g_signal_connect (app, "event",
		    G_CALLBACK (context_menu_cb), 
		    GTK_OBJECT (menu));

  g_signal_connect_object (GTK_OBJECT (app), "event",
			   G_CALLBACK (context_menu_cb), 
			   GTK_OBJECT (gtk_item_factory_get_widget (item_factory, "/File")));
#endif


}

void noskin_main_close ();

