/*  ksim - a system monitor for kde
 *
 *  Copyright (C) 2001  Robbie Ward <linuxphreak@gmx.co.uk>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#ifndef CMDHANDLER_H
#define CMDHANDLER_H

#include <qstring.h>

namespace KSim
{
  class CmdHandler
  {
    public:
      CmdHandler();
      ~CmdHandler();

      void setThemeAlternatives(int alternative);
      void setConfigFileName(const QCString &name);
      void themeOption(const QCString &fileName);
      void parseThemeOption(const QCString &fileName);

    private:
      QString m_themeFile;
      int m_themeAlt;
  };
}
#endif
