/***************************************************************************
                          kweather.h  -  description
                             -------------------
    begin                : Wed Jul  5 23:09:02 CDT 2000
    copyright            : (C) 2000 by Ian Reinhart Geiser
    email                : geiseri@msoe.edu
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KWEATHER_H
#define KWEATHER_H

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <kapplication.h>
#include <qwidget.h>
#include <kpanelapplet.h>
#include <qtimer.h>
#include <dockwidget.h>
#include <kio/job.h>
#include <klocale.h>
#include <qpixmap.h>
#include <qfont.h>
#include <dcopclient.h>

#include "prefsDialog.h"
#include "reportview.h"
#include "weatherIface.h"

class prefsDialog;

class kweather : public KPanelApplet, public weatherIface
{
    Q_OBJECT

public:
	kweather(const QString& configFile, Type t = Normal, int actions = 0, QWidget *parent = 0, const char *name = 0);
	~kweather();
	void help();
	int heightForWidth(int i) const;
	int widthForHeight(int i) const;
	void refresh(QString);

public slots: // Public slots
	void preferences();
	void about();
	void getButtonEvent();
	void doReport();
	void timeout();
	void slotPrefsAccepted();
	void slotPrefsFinished();
	void slotReportFinished();

private: // Private methods
	void loadPrefs();
	void savePrefs();
	void showWeather();
	void writeLogEntry();
	void mousePressEvent(QMouseEvent * ev);
	
	// DCOP service wrapper
	QString temperature(QString stationID);
	QString dewPoint(QString stationID);
	QString relHumidity(QString stationID);
	QString heatIndex(QString stationID);
	QString windChill(QString stationID);
	QString wind(QString stationID);
	QString pressure(QString stationID);
	QPixmap currentIcon(QString stationID);
	QString currentIconString(QString stationID);
	QString date(QString stationID);
	QStringList weather(QString stationID);
	QString visibility(QString stationID);
	QStringList cover(QString stationID);
	void update(QString stationID);
	bool attach();
		
	QString reportLocation;
	int interval;
	QString fileName;
	bool logOn;
	bool firstrun;
	bool offlineMode;
	bool smallviewMode;
	QTimer *timeOut;
	QFont theFont;
	int status;
	dockwidget *p;
	reportView *theView;
	KIO::TransferJob *theJob;
	QString metarData;
	prefsDialog *mPrefs;
	reportView *mReport;
	DCOPClient *client;
};

#endif
