/***************************************************************************
                          akbytestreamsender.cpp  -  description
                             -------------------
    begin                : Mit Jul 24 2002
    copyright            : (C) 2002 by Arnold Krille
    email                : arnold@arnoldarts.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "akbytestreamsender.h"

#include <qfile.h>

#include <kdebug.h>
#include <fcntl.h>

AKByteStreamSender::AKByteStreamSender( RecordFile *input, float minStreamBufferTime, QObject *parent, const char* name )
	: QObject(parent,name)
{
kdDebug()<<"AKByteStreamSender::AKByteStreamSender( RecordFile *"<<input<<", float "<<minStreamBufferTime<<", QObject *"<<parent<<", const char* \""<<name<<"\" )"<<endl; // (DEBUG)
	cfgSamplingRate = 44100;
	cfgChannels = 2;
	cfgBits = 16;
	if(name==0) cfgTitle = "AKByteStreamSender::Out";
	else cfgTitle = name;

	_file = 0;

	i_minStreamBufferTime = minStreamBufferTime;

	if(input)
		file( input );
kdDebug()<<_file<<endl;
}

AKByteStreamSender::~AKByteStreamSender(){
	kdDebug()<<"AKByteStreamSender::~AKByteStreamSender()"<<endl; // (DEBUG)
}

void AKByteStreamSender::file(){
	//kdDebug()<<"AKByteStreamSender::file( FILE *"<<nfile<<" ) "<<_file<<endl; // (DEBUG)
#if 0
	pfile = nfile;

	pfd = fileno(pfile);

	int rc = fcntl(pfd, F_SETFL, O_NONBLOCK);
	assert(rc != -1);
#endif

	/*
	 * calculate stream buffer paramters
	 */
	float streamBufferTime;
	packets = 7;
	do {
		packets++;
		streamBufferTime = (float)(packets * packetCapacity * 1000)
			/ (float)(samplingRate() * channels() * 2);
	} while(streamBufferTime < i_minStreamBufferTime);

	emit sCanPlay(true);
}

void AKByteStreamSender::streamStart(){
	//kdDebug()<<"AKByteStreamSender::streamStart()"<<endl; // (DEBUG)
	if(_file)
	{
		/*
		 * start streaming
		 */
		outdata.setPull(packets, packetCapacity);

		emit sPlayIsRunning();
	}
}

void AKByteStreamSender::handle_eof(){
	//kdDebug()<<"AKByteStreamSender::handle_eof()"<<endl; // (DEBUG)
	/*
	 * cleanup
	 */
	outdata.endPull();
	_file->closeFile();
	_file=0;

	// Stop yourselve
	this->stop();
	emit sPlayStops();
	emit sCanPlay(false);
}

void AKByteStreamSender::request_outdata(DataPacket<mcopbyte> *packet){
	if( _file && _file->file().isOpen() )
	{
		packet->size = _file->file().readBlock( ( char* )packet->contents, packetCapacity ); //read(pfd, packet->contents, packetCapacity);
		if(packet->size > 0)
		{
			packet->send();
			return;
		}
		packet->send();
		handle_eof();
	}
}

void AKByteStreamSender::file( RecordFile *input ){
kdDebug()<<"AKByteStreamSender::file( RecordFile *"<<input<<" )"<<endl; // (DEBUG)
	if(input!=_file)
	{
		if( !(input->openplay()) ) input->openFilePlay();
		if( input->openplay() )
		{
			if(_file)
			{
				_file->closeFile();
			}
			_file = input;
			file();
		}
	}
}

#include "akbytestreamsender.moc"

// vim: sw=4 ts=4
