/***************************************************************************
                            HTMLTableColElement.h -  description
                             -------------------
    begin                : Fri Mar  8 13:55:08 2002
    copyright            : (C) 2000-2002 Lost Highway Ltd. All rights reserved.
    email                : Lost_Highway@tipitina.demon.co.uk
    generated by         : duke@tipitina on Fri Mar  8 13:55:08 2002, using kalyptus 0.9.
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU Library General Public License as       *
 *   published by the Free Software Foundation; either version 2 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef HTMLTABLECOLELEMENT_H
#define HTMLTABLECOLELEMENT_H

#include <Foundation/NSObject.h>
#include <Foundation/NSString.h>
#include <kdeobjc/HTMLElement.h>

/**

 Regroups the <code> COL </code> and <code> COLGROUP </code>
 elements. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html edef]-COL">
 COL element definition </a> in HTML 4.0.

 
 @short 
 Regroups the <code> COL </code> and <code> COLGROUP </code>
 elements.
*/

@interface HTMLTableColElement : HTMLElement 
- init;
- copyWithZone: (NSZone *) zone;
- initWithDOMNode: (DOMNode*)other;
- (void) dealloc;

/** 
 Horizontal alignment of cell data in column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-align-TD">
 align attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) align;

/** 
 see @ref align
     
*/
- setAlign: (NSString *)arg1;

/** 
 Alignment character for cells in a column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-char">
 char attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) ch;

/** 
 see @ref ch
     
*/
- setCh: (NSString *)arg1;

/** 
 Offset of alignment character. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-charoff">
 charoff attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) chOff;

/** 
 see @ref chOff
     
*/
- setChOff: (NSString *)arg1;

/** 
 Indicates the number of columns in a group or affected by a
 grouping. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-span-COL">
 span attribute definition </a> in HTML 4.0.

     
*/
- (long) span;

/** 
 see @ref span
     
*/
- setSpan: (long)arg1;

/** 
 Vertical alignment of cell data in column. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-valign">
 valign attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) vAlign;

/** 
 see @ref vAlign
     
*/
- setVAlign: (NSString *)arg1;

/** 
 Default column width. See the <a
 href="http://www.w3.org/TR/REC-html40/struct/tables.-[html adef]-width-COL">
 width attribute definition </a> in HTML 4.0.

     
*/
- (NSString *) width;

/** 
 see @ref width
     
*/
- setWidth: (NSString *)arg1;
@end

#endif
