/*
 * Decompiled with CFR 0.152.
 */
package sun.security.validator;

import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

public class KeyStores {
    private KeyStores() {
    }

    private static boolean isValid(X509Certificate x509Certificate, Date date) {
        try {
            x509Certificate.checkValidity(date);
            return true;
        }
        catch (CertificateExpiredException certificateExpiredException) {
            return false;
        }
        catch (CertificateNotYetValidException certificateNotYetValidException) {
            return true;
        }
    }

    public static Set getTrustedCerts(KeyStore keyStore) {
        HashSet hashSet = new HashSet();
        Date date = new Date();
        try {
            Enumeration enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                X509Certificate x509Certificate;
                Certificate[] certificateArray;
                String string = (String)enumeration.nextElement();
                if (keyStore.isCertificateEntry(string)) {
                    certificateArray = keyStore.getCertificate(string);
                    if (!(certificateArray instanceof X509Certificate) || !KeyStores.isValid((X509Certificate)certificateArray, date)) continue;
                    hashSet.add(certificateArray);
                    continue;
                }
                if (!keyStore.isKeyEntry(string) || (certificateArray = keyStore.getCertificateChain(string)) == null || certificateArray.length <= 0 || !(certificateArray[0] instanceof X509Certificate) || !KeyStores.isValid(x509Certificate = (X509Certificate)certificateArray[0], date)) continue;
                hashSet.add(x509Certificate);
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return hashSet;
    }
}

