/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.server;

import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.rmi.MarshalledObject;
import java.rmi.NoSuchObjectException;
import java.rmi.RMISecurityManager;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.activation.Activatable;
import java.rmi.activation.ActivationDesc;
import java.rmi.activation.ActivationException;
import java.rmi.activation.ActivationGroup;
import java.rmi.activation.ActivationGroupID;
import java.rmi.activation.ActivationID;
import java.rmi.activation.UnknownObjectException;
import java.rmi.server.RMIClassLoader;
import java.rmi.server.UnicastRemoteObject;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Hashtable;
import sun.rmi.registry.RegistryImpl;

public class ActivationGroupImpl
extends ActivationGroup {
    private static final long serialVersionUID = 5758693559430427303L;
    private Hashtable active = new Hashtable(101);
    private boolean groupInactive = false;
    private ActivationGroupID groupID;
    private ArrayList lockedIDs = new ArrayList();
    private static Class[] objConstrParams = new Class[]{ActivationID.class, MarshalledObject.class};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkInactiveGroup() {
        boolean bl2 = false;
        ActivationGroupImpl activationGroupImpl = this;
        synchronized (activationGroupImpl) {
            if (this.active.size() == 0 && this.lockedIDs.size() == 0 && !this.groupInactive) {
                this.groupInactive = true;
                bl2 = true;
            }
        }
        if (bl2) {
            try {
                super.inactiveGroup();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                UnicastRemoteObject.unexportObject(this, true);
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acquireLock(ActivationID activationID) {
        while (true) {
            ActivationID activationID2;
            Serializable serializable = this.lockedIDs;
            synchronized (serializable) {
                int n2 = this.lockedIDs.indexOf(activationID);
                if (n2 < 0) {
                    this.lockedIDs.add(activationID);
                    return;
                }
                activationID2 = (ActivationID)this.lockedIDs.get(n2);
            }
            serializable = activationID2;
            synchronized (serializable) {
                ArrayList arrayList = this.lockedIDs;
                synchronized (arrayList) {
                    int n3 = this.lockedIDs.indexOf(activationID2);
                    if (n3 < 0) {
                        continue;
                    }
                    ActivationID activationID3 = (ActivationID)this.lockedIDs.get(n3);
                    if (activationID3 != activationID2) {
                        continue;
                    }
                }
                try {
                    activationID2.wait();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseLock(ActivationID activationID) {
        Serializable serializable = this.lockedIDs;
        synchronized (serializable) {
            activationID = (ActivationID)this.lockedIDs.remove(this.lockedIDs.indexOf(activationID));
        }
        serializable = activationID;
        synchronized (serializable) {
            activationID.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean inactiveObject(ActivationID activationID) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            object = (ActiveEntry)this.active.get(activationID);
            if (object == null) {
                throw new UnknownObjectException("object not active");
            }
            try {
                if (!Activatable.unexportObject(((ActiveEntry)object).impl, false)) {
                    boolean bl2 = false;
                    return bl2;
                }
            }
            catch (NoSuchObjectException noSuchObjectException) {
                // empty catch block
            }
            try {
                super.inactiveObject(activationID);
            }
            catch (UnknownObjectException unknownObjectException) {
                // empty catch block
            }
            this.active.remove(activationID);
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
        return true;
    }

    private static boolean covers(ClassLoader classLoader, ClassLoader classLoader2) {
        if (classLoader2 == null) {
            return true;
        }
        if (classLoader == null) {
            return false;
        }
        do {
            if (classLoader != classLoader2) continue;
            return true;
        } while ((classLoader = classLoader.getParent()) != null);
        return false;
    }

    public ActivationGroupImpl(ActivationGroupID activationGroupID, MarshalledObject marshalledObject) throws RemoteException {
        super(activationGroupID);
        this.groupID = activationGroupID;
        if (System.getSecurityManager() == null) {
            try {
                System.setSecurityManager(new RMISecurityManager());
            }
            catch (Exception exception) {
                throw new RemoteException("unable to set security manager", exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeObject(ActivationID activationID, Remote remote) throws ActivationException, UnknownObjectException, RemoteException {
        try {
            this.acquireLock(activationID);
            Object object = this;
            synchronized (object) {
                if (this.groupInactive) {
                    throw new ActivationException("group is inactive");
                }
            }
            if (!this.active.contains(activationID)) {
                object = new ActiveEntry(remote);
                this.active.put(activationID, object);
                super.activeObject(activationID, ((ActiveEntry)object).mobj);
            }
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MarshalledObject newInstance(final ActivationID activationID, final ActivationDesc activationDesc) throws ActivationException, RemoteException {
        RegistryImpl.checkAccess("ActivationInstantiator.newInstance");
        if (!this.groupID.equals(activationDesc.getGroupID())) {
            throw new ActivationException("newInstance in wrong group");
        }
        try {
            Remote remote;
            Object object;
            block22: {
                this.acquireLock(activationID);
                object = this;
                synchronized (object) {
                    if (this.groupInactive) {
                        throw new ActivationException("group is inactive");
                    }
                }
                object = (ActiveEntry)this.active.get(activationID);
                if (object != null) {
                    MarshalledObject marshalledObject = ((ActiveEntry)object).mobj;
                    return marshalledObject;
                }
                String string = activationDesc.getClassName();
                final Class clazz = RMIClassLoader.loadClass(activationDesc.getLocation(), string);
                remote = null;
                final Thread thread = Thread.currentThread();
                final ClassLoader classLoader = thread.getContextClassLoader();
                ClassLoader classLoader2 = clazz.getClassLoader();
                final ClassLoader classLoader3 = ActivationGroupImpl.covers(classLoader2, classLoader) ? classLoader2 : classLoader;
                try {
                    remote = (Remote)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        public Object run() throws InstantiationException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
                            Constructor constructor = clazz.getDeclaredConstructor(objConstrParams);
                            constructor.setAccessible(true);
                            Object[] objectArray = new Object[]{activationID, activationDesc.getData()};
                            try {
                                thread.setContextClassLoader(classLoader3);
                                Remote remote = (Remote)constructor.newInstance(objectArray);
                                return remote;
                            }
                            finally {
                                thread.setContextClassLoader(classLoader);
                            }
                        }
                    });
                }
                catch (PrivilegedActionException privilegedActionException) {
                    Exception exception = privilegedActionException.getException();
                    if (exception instanceof InstantiationException) {
                        throw (InstantiationException)exception;
                    }
                    if (exception instanceof NoSuchMethodException) {
                        throw (NoSuchMethodException)exception;
                    }
                    if (exception instanceof IllegalAccessException) {
                        throw (IllegalAccessException)exception;
                    }
                    if (exception instanceof InvocationTargetException) {
                        throw (InvocationTargetException)exception;
                    }
                    if (exception instanceof RuntimeException) {
                        throw (RuntimeException)exception;
                    }
                    if (!(exception instanceof Error)) break block22;
                    throw (Error)((Object)exception);
                }
            }
            object = new ActiveEntry(remote);
            this.active.put(activationID, object);
            MarshalledObject marshalledObject = ((ActiveEntry)object).mobj;
            return marshalledObject;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodException);
        }
        catch (NoSuchMethodError noSuchMethodError) {
            throw new ActivationException("Activatable object must provide an activation constructor", noSuchMethodError);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ActivationException("exception in object constructor", invocationTargetException.getTargetException());
        }
        catch (Exception exception) {
            throw new ActivationException("unable to activate object", exception);
        }
        finally {
            this.releaseLock(activationID);
            this.checkInactiveGroup();
        }
    }

    private static class ActiveEntry {
        Remote impl;
        MarshalledObject mobj;

        ActiveEntry(Remote remote) throws ActivationException {
            this.impl = remote;
            try {
                this.mobj = new MarshalledObject(remote);
            }
            catch (IOException iOException) {
                throw new ActivationException("failed to marshal remote object", iOException);
            }
        }
    }
}

