/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sun.security.action.GetBooleanAction;

public class ProxyGenerator {
    private static final String superclassName = "java/lang/reflect/Proxy";
    private static final String handlerFieldName = "h";
    private static final boolean saveGeneratedFiles = (Boolean)AccessController.doPrivileged(new GetBooleanAction("sun.misc.ProxyGenerator.saveGeneratedFiles"));
    private static Method hashCodeMethod;
    private static Method equalsMethod;
    private static Method toStringMethod;
    private String className;
    private Class[] interfaces;
    private ConstantPool cp = new ConstantPool();
    private List fields = new ArrayList();
    private List methods = new ArrayList();
    private Map proxyMethods = new HashMap(11);
    static /* synthetic */ Class class$java$lang$Throwable;

    static {
        try {
            hashCodeMethod = Object.class.getMethod("hashCode", null);
            equalsMethod = Object.class.getMethod("equals", new Class[]{Object.class});
            toStringMethod = Object.class.getMethod("toString", null);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new NoSuchMethodError(noSuchMethodException.getMessage());
        }
    }

    private byte[] generateClassFile() {
        int n2;
        Object object;
        this.addProxyMethod(hashCodeMethod, Object.class);
        this.addProxyMethod(equalsMethod, Object.class);
        this.addProxyMethod(toStringMethod, Object.class);
        for (int i2 = 0; i2 < this.interfaces.length; ++i2) {
            object = this.interfaces[i2].getMethods();
            for (n2 = 0; n2 < ((Method[])object).length; ++n2) {
                this.addProxyMethod(object[n2], this.interfaces[i2]);
            }
        }
        try {
            this.methods.add(this.generateConstructor());
            Iterator iterator = this.proxyMethods.values().iterator();
            while (iterator.hasNext()) {
                object = (ProxyMethod)iterator.next();
                this.fields.add(new FieldInfo(((ProxyMethod)object).methodFieldName, "Ljava/lang/reflect/Method;", 10));
                this.methods.add(((ProxyMethod)object).generateMethod());
            }
            this.methods.add(this.generateStaticInitializer());
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        this.cp.getClass(ProxyGenerator.dotToSlash(this.className));
        this.cp.getClass(superclassName);
        for (int i3 = 0; i3 < this.interfaces.length; ++i3) {
            this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[i3].getName()));
        }
        this.cp.setReadOnly();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        object = new DataOutputStream(byteArrayOutputStream);
        try {
            Object object2;
            ((DataOutputStream)object).writeInt(-889275714);
            ((DataOutputStream)object).writeShort(3);
            ((DataOutputStream)object).writeShort(45);
            this.cp.write((OutputStream)object);
            ((DataOutputStream)object).writeShort(49);
            ((DataOutputStream)object).writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.className)));
            ((DataOutputStream)object).writeShort(this.cp.getClass(superclassName));
            ((DataOutputStream)object).writeShort(this.interfaces.length);
            for (n2 = 0; n2 < this.interfaces.length; ++n2) {
                ((DataOutputStream)object).writeShort(this.cp.getClass(ProxyGenerator.dotToSlash(this.interfaces[n2].getName())));
            }
            ((DataOutputStream)object).writeShort(this.fields.size());
            Iterator iterator = this.fields.iterator();
            while (iterator.hasNext()) {
                object2 = (FieldInfo)iterator.next();
                ((FieldInfo)object2).write((DataOutputStream)object);
            }
            ((DataOutputStream)object).writeShort(this.methods.size());
            iterator = this.methods.iterator();
            while (iterator.hasNext()) {
                object2 = (MethodInfo)iterator.next();
                ((MethodInfo)object2).write((DataOutputStream)object);
            }
            ((DataOutputStream)object).writeShort(0);
        }
        catch (IOException iOException) {
            throw new InternalError("unexpected I/O Exception");
        }
        return byteArrayOutputStream.toByteArray();
    }

    private static void _assert(boolean bl2) {
        if (!bl2) {
            throw new Error("assertion failure");
        }
    }

    private void codeLocalLoadStore(int n2, int n3, int n4, DataOutputStream dataOutputStream) throws IOException {
        ProxyGenerator._assert(n2 >= 0 && n2 <= 65535);
        if (n2 <= 3) {
            dataOutputStream.writeByte(n4 + n2);
        } else if (n2 <= 255) {
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeByte(n2 & 0xFF);
        } else {
            dataOutputStream.writeByte(196);
            dataOutputStream.writeByte(n3);
            dataOutputStream.writeShort(n2 & 0xFFFF);
        }
    }

    private void code_aload(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 25, 42, dataOutputStream);
    }

    private void code_astore(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 58, 75, dataOutputStream);
    }

    private void code_dload(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 24, 38, dataOutputStream);
    }

    private void code_dstore(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 57, 71, dataOutputStream);
    }

    private void code_fload(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 23, 34, dataOutputStream);
    }

    private void code_fstore(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 56, 67, dataOutputStream);
    }

    private void code_iload(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 21, 26, dataOutputStream);
    }

    private void code_ipush(int n2, DataOutputStream dataOutputStream) throws IOException {
        if (n2 >= -1 && n2 <= 5) {
            dataOutputStream.writeByte(3 + n2);
        } else if (n2 >= -128 && n2 <= 127) {
            dataOutputStream.writeByte(16);
            dataOutputStream.writeByte(n2 & 0xFF);
        } else if (n2 >= Short.MIN_VALUE && n2 <= Short.MAX_VALUE) {
            dataOutputStream.writeByte(17);
            dataOutputStream.writeShort(n2 & 0xFFFF);
        } else {
            ProxyGenerator._assert(false);
        }
    }

    private void code_istore(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 54, 59, dataOutputStream);
    }

    private void code_ldc(int n2, DataOutputStream dataOutputStream) throws IOException {
        ProxyGenerator._assert(n2 >= 0 && n2 <= 65535);
        if (n2 <= 255) {
            dataOutputStream.writeByte(18);
            dataOutputStream.writeByte(n2 & 0xFF);
        } else {
            dataOutputStream.writeByte(19);
            dataOutputStream.writeShort(n2 & 0xFFFF);
        }
    }

    private void code_lload(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 22, 30, dataOutputStream);
    }

    private void code_lstore(int n2, DataOutputStream dataOutputStream) throws IOException {
        this.codeLocalLoadStore(n2, 55, 63, dataOutputStream);
    }

    private static int getWordsPerType(Class clazz) {
        if (clazz == Long.TYPE || clazz == Double.TYPE) {
            return 2;
        }
        return 1;
    }

    private MethodInfo generateConstructor() throws IOException {
        MethodInfo methodInfo = new MethodInfo("<init>", "(Ljava/lang/reflect/InvocationHandler;)V", 1);
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        this.code_aload(0, dataOutputStream);
        this.code_aload(1, dataOutputStream);
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef(superclassName, "<init>", "(Ljava/lang/reflect/InvocationHandler;)V"));
        dataOutputStream.writeByte(177);
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)2;
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private MethodInfo generateStaticInitializer() throws IOException {
        short s2;
        MethodInfo methodInfo = new MethodInfo("<clinit>", "()V", 8);
        int n2 = 1;
        short s3 = 0;
        DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
        Iterator iterator = this.proxyMethods.values().iterator();
        while (iterator.hasNext()) {
            ProxyMethod proxyMethod = (ProxyMethod)iterator.next();
            proxyMethod.codeFieldInitialization(dataOutputStream);
        }
        dataOutputStream.writeByte(177);
        short s4 = s2 = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s3, s4, s2, this.cp.getClass("java/lang/NoSuchMethodException")));
        this.code_astore(n2, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoSuchMethodError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n2, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoSuchMethodError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        s2 = (short)methodInfo.code.size();
        methodInfo.exceptionTable.add(new ExceptionTableEntry(s3, s4, s2, this.cp.getClass("java/lang/ClassNotFoundException")));
        this.code_astore(n2, dataOutputStream);
        dataOutputStream.writeByte(187);
        dataOutputStream.writeShort(this.cp.getClass("java/lang/NoClassDefFoundError"));
        dataOutputStream.writeByte(89);
        this.code_aload(n2, dataOutputStream);
        dataOutputStream.writeByte(182);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Throwable", "getMessage", "()Ljava/lang/String;"));
        dataOutputStream.writeByte(183);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/NoClassDefFoundError", "<init>", "(Ljava/lang/String;)V"));
        dataOutputStream.writeByte(191);
        methodInfo.maxStack = (short)10;
        methodInfo.maxLocals = (short)(n2 + 1);
        methodInfo.declaredExceptions = new short[0];
        return methodInfo;
    }

    private void codeClassForName(Class clazz, DataOutputStream dataOutputStream) throws IOException {
        this.code_ldc(this.cp.getString(clazz.getName()), dataOutputStream);
        dataOutputStream.writeByte(184);
        dataOutputStream.writeShort(this.cp.getMethodRef("java/lang/Class", "forName", "(Ljava/lang/String;)Ljava/lang/Class;"));
    }

    private ProxyGenerator(String string, Class[] classArray) {
        this.className = string;
        this.interfaces = classArray;
    }

    public static byte[] generateProxyClass(final String string, Class[] classArray) {
        ProxyGenerator proxyGenerator = new ProxyGenerator(string, classArray);
        final byte[] byArray = proxyGenerator.generateClassFile();
        if (saveGeneratedFiles) {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        FileOutputStream fileOutputStream = new FileOutputStream(ProxyGenerator.dotToSlash(string) + ".class");
                        fileOutputStream.write(byArray);
                        fileOutputStream.close();
                        return null;
                    }
                    catch (IOException iOException) {
                        throw new InternalError("I/O exception saving generated file: " + iOException);
                    }
                }
            });
        }
        return byArray;
    }

    private void addProxyMethod(Method method, Class clazz) {
        String string = method.getName();
        Class[] classArray = method.getParameterTypes();
        Class clazz2 = method.getReturnType();
        Class[] classArray2 = method.getExceptionTypes();
        String string2 = string + ProxyGenerator.getParameterDescriptors(classArray);
        ProxyMethod proxyMethod = (ProxyMethod)this.proxyMethods.get(string2);
        if (proxyMethod != null) {
            if (clazz2 != proxyMethod.returnType) {
                throw new IllegalArgumentException("methods with same name and parameter signature but different return type in " + proxyMethod.fromClass + " and " + clazz + ": " + string2);
            }
            ArrayList arrayList = new ArrayList();
            ProxyGenerator.collectCompatibleTypes(classArray2, proxyMethod.exceptionTypes, arrayList);
            ProxyGenerator.collectCompatibleTypes(proxyMethod.exceptionTypes, classArray2, arrayList);
            proxyMethod.exceptionTypes = new Class[arrayList.size()];
            proxyMethod.exceptionTypes = (Class[])arrayList.toArray(proxyMethod.exceptionTypes);
        } else {
            proxyMethod = new ProxyMethod(string, classArray, clazz2, classArray2, clazz, "m" + this.proxyMethods.size());
            this.proxyMethods.put(string2, proxyMethod);
        }
    }

    private static String getFieldType(Class clazz) {
        if (clazz.isPrimitive()) {
            return PrimitiveTypeInfo.get((Class)clazz).baseTypeString;
        }
        if (clazz.isArray()) {
            return clazz.getName().replace('.', '/');
        }
        return "L" + ProxyGenerator.dotToSlash(clazz.getName()) + ";";
    }

    private static String getParameterDescriptors(Class[] classArray) {
        StringBuffer stringBuffer = new StringBuffer("(");
        for (int i2 = 0; i2 < classArray.length; ++i2) {
            stringBuffer.append(ProxyGenerator.getFieldType(classArray[i2]));
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    private static String dotToSlash(String string) {
        return string.replace('.', '/');
    }

    private static List computeUniqueCatchList(Class[] classArray) {
        ArrayList arrayList = new ArrayList();
        arrayList.add(Error.class);
        arrayList.add(RuntimeException.class);
        block0: for (int i2 = 0; i2 < classArray.length; ++i2) {
            Class clazz = classArray[i2];
            if (clazz.isAssignableFrom(class$java$lang$Throwable == null ? ProxyGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable)) {
                arrayList.clear();
                break;
            }
            if (!(class$java$lang$Throwable == null ? ProxyGenerator.class$("java.lang.Throwable") : class$java$lang$Throwable).isAssignableFrom(clazz)) continue;
            int n2 = 0;
            while (n2 < arrayList.size()) {
                Class clazz2 = (Class)arrayList.get(n2);
                if (clazz2.isAssignableFrom(clazz)) continue block0;
                if (clazz.isAssignableFrom(clazz2)) {
                    arrayList.remove(n2);
                    continue;
                }
                ++n2;
            }
            arrayList.add(clazz);
        }
        return arrayList;
    }

    private static String getMethodDescriptor(Class[] classArray, Class clazz) {
        return ProxyGenerator.getParameterDescriptors(classArray) + (clazz == Void.TYPE ? "V" : ProxyGenerator.getFieldType(clazz));
    }

    private static void collectCompatibleTypes(Class[] classArray, Class[] classArray2, List list) {
        block0: for (int i2 = 0; i2 < classArray.length; ++i2) {
            if (list.contains(classArray[i2])) continue;
            for (int i3 = 0; i3 < classArray2.length; ++i3) {
                if (!classArray2[i3].isAssignableFrom(classArray[i2])) continue;
                list.add(classArray[i2]);
                continue block0;
            }
        }
    }

    private static class ConstantPool {
        private List pool = new ArrayList(32);
        private Map map = new HashMap(16);
        private boolean readOnly = false;

        private ConstantPool() {
        }

        public void setReadOnly() {
            this.readOnly = true;
        }

        public short getFloat(float f2) {
            return this.getValue(new Float(f2));
        }

        public short getInteger(int n2) {
            return this.getValue(new Integer(n2));
        }

        public void write(OutputStream outputStream) throws IOException {
            DataOutputStream dataOutputStream = new DataOutputStream(outputStream);
            dataOutputStream.writeShort(this.pool.size() + 1);
            Iterator iterator = this.pool.iterator();
            while (iterator.hasNext()) {
                Entry entry = (Entry)iterator.next();
                entry.write(dataOutputStream);
            }
        }

        private short getValue(Object object) {
            Short s2 = (Short)this.map.get(object);
            if (s2 != null) {
                return s2;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition: " + object);
            }
            short s3 = this.addEntry(new ValueEntry(object));
            this.map.put(object, new Short(s3));
            return s3;
        }

        public short getClass(String string) {
            short s2 = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(7, s2));
        }

        public short getString(String string) {
            short s2 = this.getUtf8(string);
            return this.getIndirect(new IndirectEntry(8, s2));
        }

        public short getUtf8(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.getValue(string);
        }

        private short addEntry(Entry entry) {
            this.pool.add(entry);
            return (short)this.pool.size();
        }

        private short getIndirect(IndirectEntry indirectEntry) {
            Short s2 = (Short)this.map.get(indirectEntry);
            if (s2 != null) {
                return s2;
            }
            if (this.readOnly) {
                throw new InternalError("late constant pool addition");
            }
            short s3 = this.addEntry(indirectEntry);
            this.map.put(indirectEntry, new Short(s3));
            return s3;
        }

        public short getNameAndType(String string, String string2) {
            short s2 = this.getUtf8(string);
            short s3 = this.getUtf8(string2);
            return this.getIndirect(new IndirectEntry(12, s2, s3));
        }

        public short getFieldRef(String string, String string2, String string3) {
            short s2 = this.getClass(string);
            short s3 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(9, s2, s3));
        }

        public short getInterfaceMethodRef(String string, String string2, String string3) {
            short s2 = this.getClass(string);
            short s3 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(11, s2, s3));
        }

        public short getMethodRef(String string, String string2, String string3) {
            short s2 = this.getClass(string);
            short s3 = this.getNameAndType(string2, string3);
            return this.getIndirect(new IndirectEntry(10, s2, s3));
        }

        private static abstract class Entry {
            private Entry() {
            }

            public abstract void write(DataOutputStream var1) throws IOException;
        }

        private static class IndirectEntry
        extends Entry {
            private int tag;
            private short index0;
            private short index1;

            public int hashCode() {
                return this.tag + this.index0 + this.index1;
            }

            public IndirectEntry(int n2, short s2) {
                this.tag = n2;
                this.index0 = s2;
                this.index1 = 0;
            }

            public IndirectEntry(int n2, short s2, short s3) {
                this.tag = n2;
                this.index0 = s2;
                this.index1 = s3;
            }

            public void write(DataOutputStream dataOutputStream) throws IOException {
                dataOutputStream.writeByte(this.tag);
                dataOutputStream.writeShort(this.index0);
                if (this.tag == 9 || this.tag == 10 || this.tag == 11 || this.tag == 12) {
                    dataOutputStream.writeShort(this.index1);
                }
            }

            public boolean equals(Object object) {
                if (object instanceof IndirectEntry) {
                    IndirectEntry indirectEntry = (IndirectEntry)object;
                    if (this.tag == indirectEntry.tag && this.index0 == indirectEntry.index0 && this.index1 == indirectEntry.index1) {
                        return true;
                    }
                }
                return false;
            }
        }

        private static class ValueEntry
        extends Entry {
            private Object value;

            public void write(DataOutputStream dataOutputStream) throws IOException {
                if (this.value instanceof String) {
                    dataOutputStream.writeByte(1);
                    dataOutputStream.writeUTF((String)this.value);
                } else if (this.value instanceof Integer) {
                    dataOutputStream.writeByte(3);
                    dataOutputStream.writeInt((Integer)this.value);
                } else if (this.value instanceof Float) {
                    dataOutputStream.writeByte(4);
                    dataOutputStream.writeFloat(((Float)this.value).floatValue());
                } else if (this.value instanceof Long) {
                    dataOutputStream.writeByte(5);
                    dataOutputStream.writeLong((Long)this.value);
                } else if (this.value instanceof Double) {
                    dataOutputStream.writeDouble(6.0);
                    dataOutputStream.writeDouble((Double)this.value);
                } else {
                    throw new InternalError("bogus value entry: " + this.value);
                }
            }

            public ValueEntry(Object object) {
                this.value = object;
            }
        }
    }

    private static class ExceptionTableEntry {
        public short startPc;
        public short endPc;
        public short handlerPc;
        public short catchType;

        public ExceptionTableEntry(short s2, short s3, short s4, short s5) {
            this.startPc = s2;
            this.endPc = s3;
            this.handlerPc = s4;
            this.catchType = s5;
        }
    }

    private class FieldInfo {
        public int accessFlags;
        public String name;
        public String descriptor;

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(0);
        }

        public FieldInfo(String string, String string2, int n2) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n2;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
        }
    }

    private class MethodInfo {
        public int accessFlags;
        public String name;
        public String descriptor;
        public short maxStack;
        public short maxLocals;
        public ByteArrayOutputStream code = new ByteArrayOutputStream();
        public List exceptionTable = new ArrayList();
        public short[] declaredExceptions;

        public void write(DataOutputStream dataOutputStream) throws IOException {
            dataOutputStream.writeShort(this.accessFlags);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.name));
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8(this.descriptor));
            dataOutputStream.writeShort(2);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Code"));
            dataOutputStream.writeInt(12 + this.code.size() + 8 * this.exceptionTable.size());
            dataOutputStream.writeShort(this.maxStack);
            dataOutputStream.writeShort(this.maxLocals);
            dataOutputStream.writeInt(this.code.size());
            this.code.writeTo(dataOutputStream);
            dataOutputStream.writeShort(this.exceptionTable.size());
            Iterator iterator = this.exceptionTable.iterator();
            while (iterator.hasNext()) {
                ExceptionTableEntry exceptionTableEntry = (ExceptionTableEntry)iterator.next();
                dataOutputStream.writeShort(exceptionTableEntry.startPc);
                dataOutputStream.writeShort(exceptionTableEntry.endPc);
                dataOutputStream.writeShort(exceptionTableEntry.handlerPc);
                dataOutputStream.writeShort(exceptionTableEntry.catchType);
            }
            dataOutputStream.writeShort(0);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getUtf8("Exceptions"));
            dataOutputStream.writeInt(2 + 2 * this.declaredExceptions.length);
            dataOutputStream.writeShort(this.declaredExceptions.length);
            for (int i2 = 0; i2 < this.declaredExceptions.length; ++i2) {
                dataOutputStream.writeShort(this.declaredExceptions[i2]);
            }
        }

        public MethodInfo(String string, String string2, int n2) {
            this.name = string;
            this.descriptor = string2;
            this.accessFlags = n2;
            ProxyGenerator.this.cp.getUtf8(string);
            ProxyGenerator.this.cp.getUtf8(string2);
            ProxyGenerator.this.cp.getUtf8("Code");
            ProxyGenerator.this.cp.getUtf8("Exceptions");
        }
    }

    private static class PrimitiveTypeInfo {
        public String baseTypeString;
        public String wrapperClassName;
        public String wrapperConstructorDesc;
        public String unwrapMethodName;
        public String unwrapMethodDesc;
        private static Map table = new HashMap(11);

        static {
            table.put(Integer.TYPE, new PrimitiveTypeInfo("I", "java/lang/Integer", "(I)V", "intValue", "()I"));
            table.put(Boolean.TYPE, new PrimitiveTypeInfo("Z", "java/lang/Boolean", "(Z)V", "booleanValue", "()Z"));
            table.put(Byte.TYPE, new PrimitiveTypeInfo("B", "java/lang/Byte", "(B)V", "byteValue", "()B"));
            table.put(Character.TYPE, new PrimitiveTypeInfo("C", "java/lang/Character", "(C)V", "charValue", "()C"));
            table.put(Short.TYPE, new PrimitiveTypeInfo("S", "java/lang/Short", "(S)V", "shortValue", "()S"));
            table.put(Long.TYPE, new PrimitiveTypeInfo("J", "java/lang/Long", "(J)V", "longValue", "()J"));
            table.put(Float.TYPE, new PrimitiveTypeInfo("F", "java/lang/Float", "(F)V", "floatValue", "()F"));
            table.put(Double.TYPE, new PrimitiveTypeInfo("D", "java/lang/Double", "(D)V", "doubleValue", "()D"));
        }

        public static PrimitiveTypeInfo get(Class clazz) {
            return (PrimitiveTypeInfo)table.get(clazz);
        }

        private PrimitiveTypeInfo(String string, String string2, String string3, String string4, String string5) {
            this.baseTypeString = string;
            this.wrapperClassName = string2;
            this.wrapperConstructorDesc = string3;
            this.unwrapMethodName = string4;
            this.unwrapMethodDesc = string5;
        }
    }

    private class ProxyMethod {
        public String methodName;
        public Class[] parameterTypes;
        public Class returnType;
        public Class[] exceptionTypes;
        public Class fromClass;
        public String methodFieldName;

        private void codeFieldInitialization(DataOutputStream dataOutputStream) throws IOException {
            ProxyGenerator.this.codeClassForName(this.fromClass, dataOutputStream);
            ProxyGenerator.this.code_ldc(ProxyGenerator.this.cp.getString(this.methodName), dataOutputStream);
            ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
            dataOutputStream.writeByte(189);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Class"));
            for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_ipush(i2, dataOutputStream);
                if (this.parameterTypes[i2].isPrimitive()) {
                    PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(this.parameterTypes[i2]);
                    dataOutputStream.writeByte(178);
                    dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(primitiveTypeInfo.wrapperClassName, "TYPE", "Ljava/lang/Class;"));
                } else {
                    ProxyGenerator.this.codeClassForName(this.parameterTypes[i2], dataOutputStream);
                }
                dataOutputStream.writeByte(83);
            }
            dataOutputStream.writeByte(182);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;"));
            dataOutputStream.writeByte(179);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
        }

        private MethodInfo generateMethod() throws IOException {
            short s2;
            int n2;
            String string = ProxyGenerator.getMethodDescriptor(this.parameterTypes, this.returnType);
            MethodInfo methodInfo = new MethodInfo(this.methodName, string, 17);
            int[] nArray = new int[this.parameterTypes.length];
            int n3 = 1;
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = n3;
                n3 += ProxyGenerator.getWordsPerType(this.parameterTypes[n2]);
            }
            n2 = n3;
            short s3 = 0;
            DataOutputStream dataOutputStream = new DataOutputStream(methodInfo.code);
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(180);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.superclassName, ProxyGenerator.handlerFieldName, "Ljava/lang/reflect/InvocationHandler;"));
            ProxyGenerator.this.code_aload(0, dataOutputStream);
            dataOutputStream.writeByte(178);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getFieldRef(ProxyGenerator.dotToSlash(ProxyGenerator.this.className), this.methodFieldName, "Ljava/lang/reflect/Method;"));
            if (this.parameterTypes.length > 0) {
                ProxyGenerator.this.code_ipush(this.parameterTypes.length, dataOutputStream);
                dataOutputStream.writeByte(189);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/Object"));
                for (int i2 = 0; i2 < this.parameterTypes.length; ++i2) {
                    dataOutputStream.writeByte(89);
                    ProxyGenerator.this.code_ipush(i2, dataOutputStream);
                    this.codeWrapArgument(this.parameterTypes[i2], nArray[i2], dataOutputStream);
                    dataOutputStream.writeByte(83);
                }
            } else {
                dataOutputStream.writeByte(1);
            }
            dataOutputStream.writeByte(185);
            dataOutputStream.writeShort(ProxyGenerator.this.cp.getInterfaceMethodRef("java/lang/reflect/InvocationHandler", "invoke", "(Ljava/lang/Object;Ljava/lang/reflect/Method;[Ljava/lang/Object;)Ljava/lang/Object;"));
            dataOutputStream.writeByte(4);
            dataOutputStream.writeByte(0);
            if (this.returnType == Void.TYPE) {
                dataOutputStream.writeByte(87);
                dataOutputStream.writeByte(177);
            } else {
                this.codeUnwrapReturnValue(this.returnType, dataOutputStream);
            }
            short s4 = s2 = (short)methodInfo.code.size();
            List list = ProxyGenerator.computeUniqueCatchList(this.exceptionTypes);
            if (list.size() > 0) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Class clazz = (Class)iterator.next();
                    methodInfo.exceptionTable.add(new ExceptionTableEntry(s3, s4, s2, ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName()))));
                }
                dataOutputStream.writeByte(191);
                s2 = (short)methodInfo.code.size();
                methodInfo.exceptionTable.add(new ExceptionTableEntry(s3, s4, s2, ProxyGenerator.this.cp.getClass("java/lang/Throwable")));
                ProxyGenerator.this.code_astore(n2, dataOutputStream);
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass("java/lang/reflect/UndeclaredThrowableException"));
                dataOutputStream.writeByte(89);
                ProxyGenerator.this.code_aload(n2, dataOutputStream);
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef("java/lang/reflect/UndeclaredThrowableException", "<init>", "(Ljava/lang/Throwable;)V"));
                dataOutputStream.writeByte(191);
            }
            methodInfo.maxStack = (short)10;
            methodInfo.maxLocals = (short)(n2 + 1);
            methodInfo.declaredExceptions = new short[this.exceptionTypes.length];
            for (int i3 = 0; i3 < this.exceptionTypes.length; ++i3) {
                methodInfo.declaredExceptions[i3] = ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(this.exceptionTypes[i3].getName()));
            }
            return methodInfo;
        }

        private void codeWrapArgument(Class clazz, int n2, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                dataOutputStream.writeByte(187);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(primitiveTypeInfo.wrapperClassName));
                dataOutputStream.writeByte(89);
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    ProxyGenerator.this.code_iload(n2, dataOutputStream);
                } else if (clazz == Long.TYPE) {
                    ProxyGenerator.this.code_lload(n2, dataOutputStream);
                } else if (clazz == Float.TYPE) {
                    ProxyGenerator.this.code_fload(n2, dataOutputStream);
                } else if (clazz == Double.TYPE) {
                    ProxyGenerator.this.code_dload(n2, dataOutputStream);
                } else {
                    ProxyGenerator._assert(false);
                }
                dataOutputStream.writeByte(183);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, "<init>", primitiveTypeInfo.wrapperConstructorDesc));
            } else {
                ProxyGenerator.this.code_aload(n2, dataOutputStream);
            }
        }

        private void codeUnwrapReturnValue(Class clazz, DataOutputStream dataOutputStream) throws IOException {
            if (clazz.isPrimitive()) {
                PrimitiveTypeInfo primitiveTypeInfo = PrimitiveTypeInfo.get(clazz);
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(primitiveTypeInfo.wrapperClassName));
                dataOutputStream.writeByte(182);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getMethodRef(primitiveTypeInfo.wrapperClassName, primitiveTypeInfo.unwrapMethodName, primitiveTypeInfo.unwrapMethodDesc));
                if (clazz == Integer.TYPE || clazz == Boolean.TYPE || clazz == Byte.TYPE || clazz == Character.TYPE || clazz == Short.TYPE) {
                    dataOutputStream.writeByte(172);
                } else if (clazz == Long.TYPE) {
                    dataOutputStream.writeByte(173);
                } else if (clazz == Float.TYPE) {
                    dataOutputStream.writeByte(174);
                } else if (clazz == Double.TYPE) {
                    dataOutputStream.writeByte(175);
                } else {
                    ProxyGenerator._assert(false);
                }
            } else {
                dataOutputStream.writeByte(192);
                dataOutputStream.writeShort(ProxyGenerator.this.cp.getClass(ProxyGenerator.dotToSlash(clazz.getName())));
                dataOutputStream.writeByte(176);
            }
        }

        private ProxyMethod(String string, Class[] classArray, Class clazz, Class[] classArray2, Class clazz2, String string2) {
            this.methodName = string;
            this.parameterTypes = classArray;
            this.returnType = clazz;
            this.exceptionTypes = classArray2;
            this.fromClass = clazz2;
            this.methodFieldName = string2;
        }
    }
}

