/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsDevice;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.print.PrinterJob;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.StreamTokenizer;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.Vector;
import sun.awt.DebugHelper;
import sun.awt.FontProperties;
import sun.awt.X11GraphicsDevice;
import sun.awt.font.NativeFontWrapper;
import sun.awt.motif.MFontProperties;
import sun.java2d.SunGraphicsEnvironment;
import sun.print.PSPrinterJob;
import sun.security.action.GetPropertyAction;
import sun.security.action.LoadLibraryAction;

public class X11GraphicsEnvironment
extends SunGraphicsEnvironment {
    private static final DebugHelper dbg;
    static Boolean xinerState;
    private HashSet fontPropDirs;
    Map fontNameMap;
    Map xFontDirsMap;
    Map xlfdMap;
    Vector registeredPaths;
    private static boolean registerNativeFonts;
    private static boolean isSolaris;
    private static String display;
    private static boolean isDisplayLocal;
    private static final int FOUNDRY_FIELD = 1;
    private static final int FAMILY_NAME_FIELD = 2;
    private static final int WEIGHT_NAME_FIELD = 3;
    private static final int SLANT_FIELD = 4;
    private static final int SETWIDTH_NAME_FIELD = 5;
    private static final int ADD_STYLE_NAME_FIELD = 6;
    private static final int PIXEL_SIZE_FIELD = 7;
    private static final int POINT_SIZE_FIELD = 8;
    private static final int RESOLUTION_X_FIELD = 9;
    private static final int RESOLUTION_Y_FIELD = 10;
    private static final int SPACING_FIELD = 11;
    private static final int AVERAGE_WIDTH_FIELD = 12;
    private static final int CHARSET_REGISTRY_FIELD = 13;
    private static final int CHARSET_ENCODING_FIELD = 14;
    private static final int[] fontIDFields;
    private Vector nativeFonts;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static native int checkShmExt();

    protected native int getDefaultScreenNum();

    protected native int getNumScreens();

    static {
        String string;
        $assertionsDisabled = !X11GraphicsEnvironment.class.desiredAssertionStatus();
        dbg = DebugHelper.create(X11GraphicsEnvironment.class);
        xinerState = null;
        registerNativeFonts = false;
        isSolaris = false;
        AccessController.doPrivileged(new LoadLibraryAction("awt"));
        if (!X11GraphicsEnvironment.isHeadless()) {
            X11GraphicsEnvironment.initDisplay();
            string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.registerNativeFonts"));
            if (string != null) {
                registerNativeFonts = true;
            }
        }
        isSolaris = (string = (String)AccessController.doPrivileged(new GetPropertyAction("os.name"))) != null && string.startsWith("SunOS");
        display = null;
        isDisplayLocal = false;
        fontIDFields = new int[]{0, 2, 3, 4, 5, 13, 14};
    }

    private static synchronized native void initDisplay();

    private void initNativeFonts() {
        if (this.nativeFonts != null || X11GraphicsEnvironment.isHeadless()) {
            return;
        }
        String[] stringArray = this.getNativeFonts();
        if (stringArray != null) {
            this.nativeFonts = new Vector();
            if (this.fontNameMap == null) {
                this.fontNameMap = new Hashtable();
            }
            if (this.xlfdMap == null) {
                this.xlfdMap = new Hashtable();
            }
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                String string = this.specificFontIDForName(stringArray[i2]);
                String string2 = (String)this.fontNameMap.get(string);
                if (string2 != null) continue;
                this.nativeFonts.addElement(stringArray[i2]);
                this.fontNameMap.put(string, stringArray[i2]);
                Vector vector = new Vector();
                vector.add(stringArray[i2]);
                this.xlfdMap.put(stringArray[i2], vector);
            }
        }
    }

    public static synchronized boolean isDisplayLocal() {
        if (display != null) {
            return isDisplayLocal;
        }
        if (X11GraphicsEnvironment.isHeadless()) {
            display = "";
            isDisplayLocal = true;
            return true;
        }
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.java2d.remote"));
        if (string != null) {
            display = "";
            isDisplayLocal = string.equals("false");
            return isDisplayLocal;
        }
        int n2 = X11GraphicsEnvironment.checkShmExt();
        if (n2 != -1) {
            display = "";
            isDisplayLocal = n2 == 1;
            return isDisplayLocal;
        }
        display = X11GraphicsEnvironment.getDisplayString();
        int n3 = display.indexOf(":");
        final String string2 = display.substring(0, n3);
        if (n3 <= 0) {
            isDisplayLocal = true;
            return true;
        }
        Boolean bl2 = (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                InetAddress[] inetAddressArray = null;
                Enumeration enumeration = null;
                Enumeration enumeration2 = null;
                try {
                    enumeration2 = NetworkInterface.getNetworkInterfaces();
                    inetAddressArray = InetAddress.getAllByName(string2);
                    if (inetAddressArray == null) {
                        return Boolean.FALSE;
                    }
                }
                catch (UnknownHostException unknownHostException) {
                    System.err.println("Unknown host: " + string2);
                    return Boolean.FALSE;
                }
                catch (SocketException socketException) {
                    System.err.println(socketException.getMessage());
                    return Boolean.FALSE;
                }
                while (enumeration2.hasMoreElements()) {
                    enumeration = ((NetworkInterface)enumeration2.nextElement()).getInetAddresses();
                    while (enumeration.hasMoreElements()) {
                        for (int i2 = 0; i2 < inetAddressArray.length; ++i2) {
                            if (!enumeration.nextElement().equals(inetAddressArray[i2])) continue;
                            return Boolean.TRUE;
                        }
                    }
                }
                return Boolean.FALSE;
            }
        });
        isDisplayLocal = bl2;
        return isDisplayLocal;
    }

    private static native boolean pRunningXinerama();

    protected boolean registerNativeFonts() {
        if (!registerNativeFonts) {
            return false;
        }
        if (this.nativeFonts != null) {
            Vector vector = new Vector(20, 10);
            for (int i2 = 0; i2 < this.nativeFonts.size(); ++i2) {
                String string = (String)this.nativeFonts.elementAt(i2);
                if (this.registeredFonts.containsKey(string)) continue;
                vector.addElement(string);
                this.registeredFonts.put(string, string);
            }
            NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5, false);
            return true;
        }
        return false;
    }

    private synchronized boolean runningXinerama() {
        if (xinerState == null) {
            xinerState = new Boolean(X11GraphicsEnvironment.pRunningXinerama());
        }
        return xinerState;
    }

    public GraphicsDevice getDefaultScreenDevice() {
        return this.getScreenDevices()[this.getDefaultScreenNum()];
    }

    protected GraphicsDevice makeScreenDevice(int n2) {
        return new X11GraphicsDevice(n2);
    }

    public Point getCenterPoint() {
        Point point;
        if (this.runningXinerama() && (point = X11GraphicsEnvironment.getXineramaCenterPoint()) != null) {
            return point;
        }
        return super.getCenterPoint();
    }

    private static native Point getXineramaCenterPoint();

    public Rectangle getMaximumWindowBounds() {
        if (this.runningXinerama()) {
            return this.getXineramaWindowBounds();
        }
        return super.getMaximumWindowBounds();
    }

    protected Rectangle getXineramaWindowBounds() {
        Point point = this.getCenterPoint();
        GraphicsDevice[] graphicsDeviceArray = this.getScreenDevices();
        Rectangle rectangle = null;
        Rectangle rectangle2 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[0]);
        for (int i2 = 0; i2 < graphicsDeviceArray.length; ++i2) {
            Rectangle rectangle3 = X11GraphicsEnvironment.getUsableBounds(graphicsDeviceArray[i2]);
            if (rectangle == null && rectangle3.width / 2 + rectangle3.x > point.x - 1 && rectangle3.height / 2 + rectangle3.y > point.y - 1 && rectangle3.width / 2 + rectangle3.x < point.x + 1 && rectangle3.height / 2 + rectangle3.y < point.y + 1) {
                rectangle = rectangle3;
            }
            rectangle2 = rectangle2.union(rectangle3);
        }
        if (rectangle2.width / 2 + rectangle2.x > point.x - 1 && rectangle2.height / 2 + rectangle2.y > point.y - 1 && rectangle2.width / 2 + rectangle2.x < point.x + 1 && rectangle2.height / 2 + rectangle2.y < point.y + 1) {
            return rectangle2;
        }
        if (rectangle != null) {
            return rectangle;
        }
        return rectangle2;
    }

    public PrinterJob getPrinterJob() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPrintJobAccess();
        }
        return new PSPrinterJob();
    }

    private void parseFontDir(File file) throws FileNotFoundException, IOException {
        String string = file.getParent();
        if (debugMapping) {
            System.out.println("ParseFontDir " + string);
        }
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 8192);
            StreamTokenizer streamTokenizer = new StreamTokenizer(bufferedInputStream);
            streamTokenizer.eolIsSignificant(true);
            int n2 = streamTokenizer.nextToken();
            if (n2 == -2) {
                int n3 = (int)streamTokenizer.nval;
                n2 = streamTokenizer.nextToken();
                if (n2 == 10) {
                    int n4;
                    if (this.fontNameMap == null) {
                        this.fontNameMap = new Hashtable();
                    }
                    if (this.xlfdMap == null) {
                        this.xlfdMap = new Hashtable();
                    }
                    if (this.xFontDirsMap == null) {
                        this.xFontDirsMap = new Hashtable();
                    }
                    streamTokenizer.resetSyntax();
                    streamTokenizer.wordChars(32, 127);
                    streamTokenizer.wordChars(160, 255);
                    streamTokenizer.whitespaceChars(0, 31);
                    for (int i2 = 0; i2 < n3 && (n2 = streamTokenizer.nextToken()) != -1 && n2 == -3 && (n4 = streamTokenizer.sval.indexOf(" ")) > 0; ++i2) {
                        Serializable serializable;
                        String string2 = streamTokenizer.sval.substring(0, n4);
                        String string3 = streamTokenizer.sval.substring(n4 + 1);
                        if (debugMapping) {
                            System.out.println("file=" + string2 + " xlfd=" + string3);
                        }
                        String string4 = this.specificFontIDForName(string3);
                        String string5 = (String)this.fontNameMap.get(string4);
                        if (debugMapping) {
                            System.out.println("fontID=" + string4 + " sVal=" + string5);
                        }
                        String string6 = null;
                        try {
                            serializable = new File(string, string2);
                            File file2 = ((File)serializable).getParentFile();
                            if (file2 != null) {
                                this.xFontDirsMap.put(string4, file2.getAbsolutePath());
                            }
                            string6 = ((File)serializable).getCanonicalPath();
                        }
                        catch (IOException iOException) {
                            string6 = string + File.separator + string2;
                        }
                        serializable = (Vector)this.xlfdMap.get(string6);
                        if (debugMapping) {
                            System.out.println("fullPath=" + string6 + " xVal=" + serializable);
                        }
                        if ((serializable == null || !((Vector)serializable).contains(string3)) && string5 == null || !string5.startsWith("/")) {
                            if (debugMapping) {
                                System.out.println("Map fontID:" + string4 + "to file:" + string6);
                            }
                            this.fontNameMap.put(string4, string6);
                            if (serializable == null) {
                                serializable = new Vector();
                                this.xlfdMap.put(string6, serializable);
                            }
                            ((Vector)serializable).add(string3);
                        }
                        if ((n2 = streamTokenizer.nextToken()) != 10) break;
                    }
                }
            }
        }
    }

    private static native String getDisplayString();

    private native String[] getNativeFonts();

    protected void addPlatformNameForFontProperties(String string) {
        if (this.fontPropDirs == null) {
            this.fontPropDirs = new HashSet();
        }
        if (this.xFontDirsMap == null) {
            return;
        }
        String string2 = this.specificFontIDForName(string);
        String string3 = (String)this.xFontDirsMap.get(string2);
        if (string3 != null && !this.fontPropDirs.contains(string3)) {
            this.fontPropDirs.add(string3);
        }
    }

    protected void addToFontPath(String string) {
        NativeFontWrapper.setNativeFontPath(string);
    }

    protected void registerFontPath(String string) {
        final File file = new File(string + File.separator + "fonts.dir");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    X11GraphicsEnvironment.this.parseFontDir(file);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return null;
            }
        });
    }

    protected void registerFontPaths(String string) {
        boolean bl2 = false;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        if (this.registeredPaths == null) {
            this.registeredPaths = new Vector();
        }
        try {
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if (string2 == null || this.registeredPaths.contains(string2)) continue;
                this.registeredPaths.add(string2);
                this.registerFontPath(string2);
            }
        }
        catch (NoSuchElementException noSuchElementException) {
            System.err.println(noSuchElementException);
        }
        if (this.loadNativeFonts) {
            this.initNativeFonts();
        }
    }

    protected void registerNative(String string) {
        Vector vector = new Vector(1, 1);
        vector.addElement(string);
        this.registeredFonts.put(string, string);
        NativeFontWrapper.registerFonts(vector, vector.size(), vector, 5, false);
    }

    protected String getBasePlatformFontPath(boolean bl2) {
        if (isSolaris) {
            return "";
        }
        return this.getPlatformFontPath(bl2);
    }

    protected void addPlatformCompatibilityFileNames(Map map) {
        if (this.fontNameMap == null || this.xlfdMap == null) {
            return;
        }
        Iterator iterator = this.fontNameMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string;
            String string2;
            String string3 = (String)iterator.next();
            String string4 = (String)this.fontNameMap.get(string3);
            if (map.get(string4) != null || string4.startsWith("-") || !this.isCompatibilityFont(string2 = this.getFontIDField(string3, 2), string = this.getFontIDField(string3, 13) + "-" + this.getFontIDField(string3, 14))) continue;
            HashSet hashSet = new HashSet();
            List list = (List)this.xlfdMap.get(string4);
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string5 = (String)iterator2.next();
                string2 = this.getXLFDField(string5, 2);
                if (!this.isCompatibilityFont(string2, string = this.getXLFDField(string5, 13) + "-" + this.getXLFDField(string5, 14))) continue;
                hashSet.add(string5);
            }
            map.put(string4, hashSet);
        }
    }

    protected void registerFontPropertiesFonts(TreeMap treeMap) {
        Object[] objectArray = treeMap.keySet().toArray();
        for (int i2 = 0; i2 < objectArray.length; ++i2) {
            String string = (String)objectArray[i2];
            HashSet hashSet = (HashSet)treeMap.get(string);
            Vector vector = this.getNativeNames(string);
            String[] stringArray = (String[])hashSet.toArray(new String[0]);
            Vector vector2 = new Vector();
            for (int i3 = 0; i3 < stringArray.length; ++i3) {
                vector2.add(this.specificFontIDForName(stringArray[i3]));
            }
            Vector vector3 = new Vector(hashSet);
            for (int i4 = 0; i4 < vector.size(); ++i4) {
                String string2 = (String)vector.elementAt(i4);
                String string3 = this.specificFontIDForName(string2);
                if (vector2.contains(string3)) continue;
                vector3.add(string2);
            }
            this.registerFontFile(string, vector3);
        }
        String[] stringArray = (String[])this.fontPropDirs.toArray(new String[0]);
        for (int i5 = 0; i5 < stringArray.length; ++i5) {
            if (debugMapping) {
                System.out.println("Add " + stringArray[i5] + " to X11 fontpath");
            }
            this.addToFontPath(stringArray[i5]);
        }
        this.fontPropDirs = null;
        this.xFontDirsMap = null;
    }

    protected FontProperties createFontProperties() {
        return new MFontProperties();
    }

    protected String getFileNameFromPlatformName(String string) {
        String string2 = null;
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap == null) {
            this.fontNameMap = new Hashtable();
        }
        if ((string2 = super.getFileNameFromPlatformName(string)) != null) {
            if (string2.startsWith("-")) {
                if (X11GraphicsEnvironment.isHeadless()) {
                    return null;
                }
                if (this.fontNameMap.get(this.specificFontIDForName(string2)) == null && (string2 = (String)this.fontNameMap.get(this.switchFontIDForName(string2))) == null) {
                    return null;
                }
            }
            this.fontNameMap.put(string3, string2);
            return string2;
        }
        if (string3 != null) {
            string2 = (String)this.fontNameMap.get(string3);
            if (!(this.registeredAllPaths || string2 != null && string2.startsWith("/"))) {
                if (debugMapping) {
                    System.out.println("** Registering all font paths");
                }
                String string4 = this.getPlatformFontPath(this.noType1Font);
                this.fontPath = this.fontPath + File.pathSeparator + string4;
                this.registerFontPaths(string4);
                string2 = (String)this.fontNameMap.get(string3);
            }
            if (string2 == null) {
                string3 = this.switchFontIDForName(string);
                string2 = (String)this.fontNameMap.get(string3);
            }
        }
        return string2;
    }

    protected String getFontPropertyFD(String string) {
        return string;
    }

    protected String parseFamilyNameProperty(String string) {
        String string2 = "default";
        String string3 = this.specificFontIDForName(string);
        if (this.fontNameMap != null && string3 != null) {
            String string4;
            String string5 = (String)this.fontNameMap.get(string3);
            if (string5 == null) {
                string3 = this.switchFontIDForName(string);
                string5 = (String)this.fontNameMap.get(string3);
            }
            if (string5 != null && (string4 = NativeFontWrapper.getFullNameByFileName(string5)) != null) {
                string2 = string4;
            }
        }
        return string2;
    }

    private String specificFontIDForName(String string) {
        String string2 = this.getXLFDField(string, 2);
        String string3 = this.getXLFDField(string, 3);
        String string4 = this.getXLFDField(string, 4);
        String string5 = this.getXLFDField(string, 5);
        String string6 = this.getXLFDField(string, 13);
        String string7 = this.getXLFDField(string, 14);
        String string8 = "-" + string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String switchFontIDForName(String string) {
        String string2 = this.getXLFDField(string, 2);
        String string3 = this.getXLFDField(string, 3);
        String string4 = this.getXLFDField(string, 4);
        String string5 = this.getXLFDField(string, 5);
        String string6 = this.getXLFDField(string, 13);
        String string7 = this.getXLFDField(string, 14);
        if (string4.equals("i")) {
            string4 = "o";
        } else if (string4.equals("o")) {
            string4 = "i";
        }
        if (string2.equals("itc zapfdingbats") && string6.equals("sun") && string7.equals("fontspecific")) {
            string6 = "adobe";
        }
        String string8 = "-" + string2 + "-" + string3 + "-" + string4 + "-" + string5 + "-" + string6 + "-" + string7;
        return string8.toLowerCase(Locale.ENGLISH);
    }

    private String getFontField(String string, int n2) {
        int n3 = 0;
        int n4 = 0;
        while (n2-- > 0 && n3 >= 0) {
            n3 = string.indexOf("-", n3) + 1;
        }
        if (n3 == -1) {
            return "";
        }
        n4 = string.indexOf("-", n3);
        if (n4 == -1) {
            return string.substring(n3);
        }
        return string.substring(n3, n4);
    }

    private String getFontIDField(String string, int n2) {
        for (int i2 = 1; i2 < fontIDFields.length; ++i2) {
            if (fontIDFields[i2] != n2) continue;
            return this.getFontField(string, i2);
        }
        if (!$assertionsDisabled) {
            throw new AssertionError();
        }
        return null;
    }

    private String getXLFDField(String string, int n2) {
        return this.getFontField(string, n2);
    }

    private boolean isCompatibilityFont(String string, String string2) {
        return "iso8859-1".equals(string2) && ("timesroman".equals(string) || "helvetica".equals(string) || "courier".equals(string));
    }

    protected Vector getNativeNames(String string) {
        Vector vector;
        if (this.xlfdMap == null || (vector = (Vector)this.xlfdMap.get(string)) == null) {
            Vector vector2 = new Vector();
            return vector2;
        }
        return vector;
    }

    protected void registerFontFile(String string, Vector vector) {
        int n2;
        if (this.registeredFonts.containsKey(string)) {
            return;
        }
        if (new SunGraphicsEnvironment.TTFilter().accept(null, string)) {
            n2 = 0;
        } else if (new SunGraphicsEnvironment.T1Filter().accept(null, string)) {
            n2 = 1;
        } else if (new SunGraphicsEnvironment.T2KFilter().accept(null, string)) {
            n2 = 2;
        } else {
            this.registerNative(string);
            return;
        }
        File file = new File(string);
        if (file.canRead()) {
            Vector vector2 = new Vector(1, 1);
            Vector vector3 = new Vector(1, 1);
            vector3.addElement(vector);
            String string2 = null;
            try {
                string2 = file.getCanonicalPath();
                file = new File(string2);
            }
            catch (IOException iOException) {
                string2 = file.getAbsolutePath();
            }
            vector2.addElement(string2);
            this.registeredFonts.put(string, string);
            NativeFontWrapper.registerFonts(vector2, vector2.size(), vector3, n2, false);
        }
    }
}

