/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.LayeredHighlighter;
import javax.swing.text.Position;
import javax.swing.text.Segment;
import javax.swing.text.SegmentCache;
import javax.swing.text.StateInvariantError;
import javax.swing.text.TabExpander;
import javax.swing.text.Utilities;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class PlainView
extends View
implements TabExpander {
    protected FontMetrics metrics;
    Element longLine;
    Font font;
    Segment lineBuffer;
    int tabSize;
    int tabBase;
    int sel0;
    int sel1;
    Color unselected;
    Color selected;
    int firstLineOffset;

    protected int getTabSize() {
        Integer n2 = (Integer)this.getDocument().getProperty("tabSize");
        int n3 = n2 != null ? n2 : 8;
        return n3;
    }

    private void calculateLongestLine() {
        Container container = this.getContainer();
        this.font = container.getFont();
        this.metrics = container.getFontMetrics(this.font);
        Document document = this.getDocument();
        Element element = this.getElement();
        int n2 = element.getElementCount();
        int n3 = -1;
        for (int i2 = 0; i2 < n2; ++i2) {
            Element element2 = element.getElement(i2);
            int n4 = this.getLineWidth(element2);
            if (n4 <= n3) continue;
            n3 = n4;
            this.longLine = element2;
        }
    }

    protected void updateMetrics() {
        Container container = this.getContainer();
        Font font = container.getFont();
        if (this.font != font) {
            this.calculateLongestLine();
            this.tabSize = this.getTabSize() * this.metrics.charWidth('m');
        }
    }

    public void setSize(float f2, float f3) {
        super.setSize(f2, f3);
        this.updateMetrics();
    }

    public float nextTabStop(float f2, int n2) {
        if (this.tabSize == 0) {
            return f2;
        }
        int n3 = ((int)f2 - this.tabBase) / this.tabSize;
        return this.tabBase + (n3 + 1) * this.tabSize;
    }

    public float getPreferredSpan(int n2) {
        this.updateMetrics();
        switch (n2) {
            case 0: {
                return this.getLineWidth(this.longLine);
            }
            case 1: {
                return this.getElement().getElementCount() * this.metrics.getHeight();
            }
        }
        throw new IllegalArgumentException("Invalid axis: " + n2);
    }

    protected void drawLine(int n2, Graphics graphics, int n3, int n4) {
        Element element = this.getElement().getElement(n2);
        try {
            if (element.isLeaf()) {
                this.drawElement(n2, element, graphics, n3, n4);
            } else {
                int n5 = element.getElementCount();
                for (int i2 = 0; i2 < n5; ++i2) {
                    Element element2 = element.getElement(i2);
                    n3 = this.drawElement(n2, element2, graphics, n3, n4);
                }
            }
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError("Can't render line: " + n2);
        }
    }

    protected int drawSelectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.selected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    protected int drawUnselectedText(Graphics graphics, int n2, int n3, int n4, int n5) throws BadLocationException {
        graphics.setColor(this.unselected);
        Document document = this.getDocument();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n5 - n4, segment);
        int n6 = Utilities.drawTabbedText(segment, n2, n3, graphics, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        return n6;
    }

    private int getLineWidth(Element element) {
        int n2;
        int n3 = element.getStartOffset();
        int n4 = element.getEndOffset();
        Segment segment = SegmentCache.getSharedSegment();
        try {
            element.getDocument().getText(n3, n4 - n3, segment);
            n2 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n3);
        }
        catch (BadLocationException badLocationException) {
            n2 = 0;
        }
        SegmentCache.releaseSharedSegment(segment);
        return n2;
    }

    public PlainView(Element element) {
        super(element);
    }

    protected final Segment getLineBuffer() {
        if (this.lineBuffer == null) {
            this.lineBuffer = new Segment();
        }
        return this.lineBuffer;
    }

    protected void damageLineRange(int n2, int n3, Shape shape, Component component) {
        if (shape != null) {
            Rectangle rectangle = this.lineToRect(shape, n2);
            Rectangle rectangle2 = this.lineToRect(shape, n3);
            if (rectangle != null && rectangle2 != null) {
                Rectangle rectangle3 = rectangle.union(rectangle2);
                component.repaint(rectangle3.x, rectangle3.y, rectangle3.width, rectangle3.height);
            } else {
                component.repaint();
            }
        }
    }

    private int drawElement(int n2, Element element, Graphics graphics, int n3, int n4) throws BadLocationException {
        AttributeSet attributeSet;
        int n5 = element.getStartOffset();
        int n6 = element.getEndOffset();
        n6 = Math.min(this.getDocument().getLength(), n6);
        if (n2 == 0) {
            n3 += this.firstLineOffset;
        }
        if (Utilities.isComposedTextAttributeDefined(attributeSet = element.getAttributes())) {
            graphics.setColor(this.unselected);
            n3 = Utilities.drawComposedText(attributeSet, graphics, n3, n4, n5 - element.getStartOffset(), n6 - element.getStartOffset());
        } else if (this.sel0 == this.sel1) {
            n3 = this.drawUnselectedText(graphics, n3, n4, n5, n6);
        } else if (n5 >= this.sel0 && n5 <= this.sel1 && n6 >= this.sel0 && n6 <= this.sel1) {
            n3 = this.drawSelectedText(graphics, n3, n4, n5, n6);
        } else if (this.sel0 >= n5 && this.sel0 <= n6) {
            if (this.sel1 >= n5 && this.sel1 <= n6) {
                n3 = this.drawUnselectedText(graphics, n3, n4, n5, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, this.sel1);
                n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n6);
            } else {
                n3 = this.drawUnselectedText(graphics, n3, n4, n5, this.sel0);
                n3 = this.drawSelectedText(graphics, n3, n4, this.sel0, n6);
            }
        } else if (this.sel1 >= n5 && this.sel1 <= n6) {
            n3 = this.drawSelectedText(graphics, n3, n4, n5, this.sel1);
            n3 = this.drawUnselectedText(graphics, n3, n4, this.sel1, n6);
        } else {
            n3 = this.drawUnselectedText(graphics, n3, n4, n5, n6);
        }
        return n3;
    }

    protected Rectangle lineToRect(Shape shape, int n2) {
        Rectangle rectangle = null;
        this.updateMetrics();
        if (this.metrics != null) {
            Rectangle rectangle2 = shape.getBounds();
            if (n2 == 0) {
                rectangle2.x += this.firstLineOffset;
                rectangle2.width -= this.firstLineOffset;
            }
            rectangle = new Rectangle(rectangle2.x, rectangle2.y + n2 * this.metrics.getHeight(), rectangle2.width, this.metrics.getHeight());
        }
        return rectangle;
    }

    public void paint(Graphics graphics, Shape shape) {
        Shape shape2 = shape;
        shape = this.adjustPaintRegion(shape);
        Rectangle rectangle = (Rectangle)shape;
        this.tabBase = rectangle.x;
        JTextComponent jTextComponent = (JTextComponent)this.getContainer();
        graphics.setFont(jTextComponent.getFont());
        this.sel0 = jTextComponent.getSelectionStart();
        this.sel1 = jTextComponent.getSelectionEnd();
        this.unselected = jTextComponent.isEnabled() ? jTextComponent.getForeground() : jTextComponent.getDisabledTextColor();
        Caret caret = jTextComponent.getCaret();
        this.selected = caret.isSelectionVisible() ? jTextComponent.getSelectedTextColor() : this.unselected;
        this.updateMetrics();
        Rectangle rectangle2 = graphics.getClipBounds();
        int n2 = this.metrics.getHeight();
        int n3 = rectangle.y + rectangle.height - (rectangle2.y + rectangle2.height);
        int n4 = Math.max(0, n3 / n2);
        int n5 = rectangle2.y - rectangle.y;
        int n6 = Math.max(0, n5 / n2);
        int n7 = rectangle.height / n2;
        if (rectangle.height % n2 != 0) {
            ++n7;
        }
        Rectangle rectangle3 = this.lineToRect(shape, n6);
        int n8 = rectangle3.y + this.metrics.getAscent();
        int n9 = rectangle3.x;
        Element element = this.getElement();
        int n10 = element.getElementCount();
        int n11 = Math.min(n10, n7 - n4);
        --n10;
        Highlighter highlighter = jTextComponent.getHighlighter();
        LayeredHighlighter layeredHighlighter = highlighter instanceof LayeredHighlighter ? (LayeredHighlighter)highlighter : null;
        for (int i2 = n6; i2 < n11; ++i2) {
            if (layeredHighlighter != null) {
                Element element2 = element.getElement(i2);
                if (i2 == n10) {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset(), shape2, jTextComponent, this);
                } else {
                    layeredHighlighter.paintLayeredHighlights(graphics, element2.getStartOffset(), element2.getEndOffset() - 1, shape2, jTextComponent, this);
                }
            }
            this.drawLine(i2, graphics, n9, n8);
            n8 += n2;
            if (i2 != 0) continue;
            n9 -= this.firstLineOffset;
        }
    }

    Shape adjustPaintRegion(Shape shape) {
        return shape;
    }

    public int viewToModel(float f2, float f3, Shape shape, Position.Bias[] biasArray) {
        biasArray[0] = Position.Bias.Forward;
        Rectangle rectangle = shape.getBounds();
        Document document = this.getDocument();
        int n2 = (int)f2;
        int n3 = (int)f3;
        if (n3 < rectangle.y) {
            return this.getStartOffset();
        }
        if (n3 > rectangle.y + rectangle.height) {
            return this.getEndOffset() - 1;
        }
        Element element = document.getDefaultRootElement();
        int n4 = Math.abs((n3 - rectangle.y) / this.metrics.getHeight());
        if (n4 >= element.getElementCount()) {
            return this.getEndOffset() - 1;
        }
        Element element2 = element.getElement(n4);
        boolean bl2 = false;
        if (n4 == 0) {
            rectangle.x += this.firstLineOffset;
            rectangle.width -= this.firstLineOffset;
        }
        if (n2 < rectangle.x) {
            return element2.getStartOffset();
        }
        if (n2 > rectangle.x + rectangle.width) {
            return element2.getEndOffset() - 1;
        }
        try {
            int n5 = element2.getStartOffset();
            int n6 = element2.getEndOffset() - 1;
            Segment segment = SegmentCache.getSharedSegment();
            document.getText(n5, n6 - n5, segment);
            this.tabBase = rectangle.x;
            int n7 = n5 + Utilities.getTabbedTextOffset(segment, this.metrics, this.tabBase, n2, this, n5);
            SegmentCache.releaseSharedSegment(segment);
            return n7;
        }
        catch (BadLocationException badLocationException) {
            return -1;
        }
    }

    public Shape modelToView(int n2, Shape shape, Position.Bias bias) throws BadLocationException {
        Document document = this.getDocument();
        Element element = this.getElement();
        int n3 = element.getElementIndex(n2);
        Rectangle rectangle = this.lineToRect(shape, n3);
        this.tabBase = rectangle.x;
        Element element2 = element.getElement(n3);
        int n4 = element2.getStartOffset();
        Segment segment = SegmentCache.getSharedSegment();
        document.getText(n4, n2 - n4, segment);
        int n5 = Utilities.getTabbedTextWidth(segment, this.metrics, this.tabBase, this, n4);
        SegmentCache.releaseSharedSegment(segment);
        rectangle.x += n5;
        rectangle.width = 1;
        rectangle.height = this.metrics.getHeight();
        return rectangle;
    }

    public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.updateDamage(documentEvent, shape, viewFactory);
    }

    protected void updateDamage(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        Element[] elementArray;
        Container container = this.getContainer();
        this.updateMetrics();
        Element element = this.getElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementChange != null ? elementChange.getChildrenAdded() : null;
        Element[] elementArray3 = elementArray = elementChange != null ? elementChange.getChildrenRemoved() : null;
        if (elementArray2 != null && elementArray2.length > 0 || elementArray != null && elementArray.length > 0) {
            int n2;
            if (elementArray2 != null) {
                n2 = this.getLineWidth(this.longLine);
                for (int i2 = 0; i2 < elementArray2.length; ++i2) {
                    int n3 = this.getLineWidth(elementArray2[i2]);
                    if (n3 <= n2) continue;
                    n2 = n3;
                    this.longLine = elementArray2[i2];
                }
            }
            if (elementArray != null) {
                for (n2 = 0; n2 < elementArray.length; ++n2) {
                    if (elementArray[n2] != this.longLine) continue;
                    this.calculateLongestLine();
                    break;
                }
            }
            this.preferenceChanged(null, true, true);
            container.repaint();
        } else {
            Element element2 = this.getElement();
            int n4 = element2.getElementIndex(documentEvent.getOffset());
            this.damageLineRange(n4, n4, shape, container);
            if (documentEvent.getType() == DocumentEvent.EventType.INSERT) {
                int n5 = this.getLineWidth(this.longLine);
                Element element3 = element2.getElement(n4);
                if (element3 == this.longLine) {
                    this.preferenceChanged(null, true, false);
                } else if (this.getLineWidth(element3) > n5) {
                    this.longLine = element3;
                    this.preferenceChanged(null, true, false);
                }
            } else if (documentEvent.getType() == DocumentEvent.EventType.REMOVE && element2.getElement(n4) == this.longLine) {
                this.calculateLongestLine();
                this.preferenceChanged(null, true, false);
            }
        }
    }
}

