/*
 * Decompiled with CFR 0.152.
 */
package javax.sound.sampled;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.Line;

public interface DataLine
extends Line {
    public float getLevel();

    public int available();

    public int getBufferSize();

    public int getFramePosition();

    public long getMicrosecondPosition();

    public void drain();

    public void flush();

    public void start();

    public void stop();

    public boolean isActive();

    public boolean isRunning();

    public AudioFormat getFormat();

    public static class Info
    extends Line.Info {
        private AudioFormat[] formats;
        private int minBufferSize;
        private int maxBufferSize;

        public int getMaxBufferSize() {
            return this.maxBufferSize;
        }

        public int getMinBufferSize() {
            return this.minBufferSize;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            if (this.formats.length == 1 && this.formats[0] != null) {
                stringBuffer.append(" supporting format " + this.formats[0]);
            } else if (this.getFormats().length > 1) {
                stringBuffer.append(" supporting " + this.getFormats().length + " audio formats");
            }
            if (this.minBufferSize != -1 && this.maxBufferSize != -1) {
                stringBuffer.append(", and buffers of " + this.minBufferSize + " to " + this.maxBufferSize + " bytes");
            } else if (this.minBufferSize != -1 && this.minBufferSize > 0) {
                stringBuffer.append(", and buffers of at least " + this.minBufferSize + " bytes");
            } else if (this.maxBufferSize != -1) {
                stringBuffer.append(", and buffers of up to " + this.minBufferSize + " bytes");
            }
            return new String(super.toString() + stringBuffer);
        }

        public AudioFormat[] getFormats() {
            AudioFormat[] audioFormatArray = new AudioFormat[this.formats.length];
            System.arraycopy(this.formats, 0, audioFormatArray, 0, this.formats.length);
            return audioFormatArray;
        }

        public boolean isFormatSupported(AudioFormat audioFormat) {
            for (int i2 = 0; i2 < this.formats.length; ++i2) {
                if (!audioFormat.matches(this.formats[i2])) continue;
                return true;
            }
            return false;
        }

        public boolean matches(Line.Info info) {
            if (!super.matches(info)) {
                return false;
            }
            Info info2 = (Info)info;
            if (this.getMaxBufferSize() != -1 && info2.getMaxBufferSize() != -1 && this.getMaxBufferSize() > info2.getMaxBufferSize()) {
                return false;
            }
            if (this.getMinBufferSize() != -1 && info2.getMinBufferSize() != -1 && this.getMinBufferSize() < info2.getMinBufferSize()) {
                return false;
            }
            AudioFormat[] audioFormatArray = this.getFormats();
            if (audioFormatArray != null) {
                for (int i2 = 0; i2 < audioFormatArray.length; ++i2) {
                    if (audioFormatArray[i2] == null || info2.isFormatSupported(audioFormatArray[i2])) continue;
                    return false;
                }
            }
            return true;
        }

        public Info(Class clazz, AudioFormat audioFormat) {
            this(clazz, audioFormat, -1);
        }

        public Info(Class clazz, AudioFormat audioFormat, int n2) {
            super(clazz);
            if (audioFormat == null) {
                this.formats = new AudioFormat[0];
            } else {
                AudioFormat[] audioFormatArray = new AudioFormat[]{audioFormat};
                this.formats = audioFormatArray;
            }
            this.minBufferSize = n2;
            this.maxBufferSize = n2;
        }

        public Info(Class clazz, AudioFormat[] audioFormatArray, int n2, int n3) {
            super(clazz);
            this.formats = audioFormatArray == null ? new AudioFormat[0] : audioFormatArray;
            this.minBufferSize = n2;
            this.maxBufferSize = n3;
        }
    }
}

