/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;
    public static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private byte[] tmpbuf = new byte[128];

    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    private void readHeader() throws IOException {
        CheckedInputStream checkedInputStream = new CheckedInputStream(this.in, this.crc);
        this.crc.reset();
        if (this.readUShort(checkedInputStream) != 35615) {
            throw new IOException("Not in GZIP format");
        }
        if (this.readUByte(checkedInputStream) != 8) {
            throw new IOException("Unsupported compression method");
        }
        int n2 = this.readUByte(checkedInputStream);
        this.skipBytes(checkedInputStream, 6);
        if ((n2 & 4) == 4) {
            this.skipBytes(checkedInputStream, this.readUShort(checkedInputStream));
        }
        if ((n2 & 8) == 8) {
            while (this.readUByte(checkedInputStream) != 0) {
            }
        }
        if ((n2 & 0x10) == 16) {
            while (this.readUByte(checkedInputStream) != 0) {
            }
        }
        if ((n2 & 2) == 2) {
            int n3 = (int)this.crc.getValue() & 0xFFFF;
            if (this.readUShort(checkedInputStream) != n3) {
                throw new IOException("Corrupt GZIP header");
            }
        }
    }

    private void readTrailer() throws IOException {
        InputStream inputStream = this.in;
        int n2 = this.inf.getRemaining();
        if (n2 > 0) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n2, n2), inputStream);
        }
        long l2 = this.crc.getValue();
        if (this.readUInt(inputStream) != l2 || this.readUInt(inputStream) != (long)this.inf.getTotalOut()) {
            throw new IOException("Corrupt GZIP trailer");
        }
    }

    public int read(byte[] byArray, int n2, int n3) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        if ((n3 = super.read(byArray, n2, n3)) == -1) {
            this.readTrailer();
            this.eos = true;
        } else {
            this.crc.update(byArray, n2, n3);
        }
        return n3;
    }

    private int readUByte(InputStream inputStream) throws IOException {
        int n2 = inputStream.read();
        if (n2 == -1) {
            throw new EOFException();
        }
        return n2;
    }

    private int readUShort(InputStream inputStream) throws IOException {
        int n2 = this.readUByte(inputStream);
        return this.readUByte(inputStream) << 8 | n2;
    }

    private long readUInt(InputStream inputStream) throws IOException {
        long l2 = this.readUShort(inputStream);
        return (long)this.readUShort(inputStream) << 16 | l2;
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    public GZIPInputStream(InputStream inputStream, int n2) throws IOException {
        super(inputStream, new Inflater(true), n2);
        this.usesDefaultInflater = true;
        this.readHeader();
        this.crc.reset();
    }

    private void skipBytes(InputStream inputStream, int n2) throws IOException {
        while (n2 > 0) {
            int n3 = inputStream.read(this.tmpbuf, 0, n2 < this.tmpbuf.length ? n2 : this.tmpbuf.length);
            if (n3 == -1) {
                throw new EOFException();
            }
            n2 -= n3;
        }
    }
}

