/*
 * Decompiled with CFR 0.152.
 */
package java.util.prefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.TreeMap;
import java.util.logging.Logger;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Base64;
import java.util.prefs.InvalidPreferencesFormatException;
import java.util.prefs.Preferences;
import java.util.prefs.XmlSupport;

class FileSystemPreferences
extends AbstractPreferences {
    private static final int SYNC_INTERVAL = Math.max(1, Integer.parseInt((String)AccessController.doPrivileged(new PrivilegedAction(){

        public Object run() {
            return System.getProperty("java.util.prefs.syncInterval", "30");
        }
    })));
    private static File systemRootDir;
    private static boolean isSystemRootWritable;
    private static File userRootDir;
    private static boolean isUserRootWritable;
    static Preferences userRoot;
    static Preferences systemRoot;
    private static final int USER_READ_WRITE = 384;
    private static final int USER_RW_ALL_READ = 420;
    private static final int USER_RWX_ALL_RX = 493;
    private static final int USER_RWX = 448;
    static File userLockFile;
    static File systemLockFile;
    private static int userRootLockHandle;
    private static int systemRootLockHandle;
    private final File dir;
    private final File prefsFile;
    private final File tmpFile;
    private static File userRootModFile;
    private static boolean isUserRootModified;
    private static long userRootModTime;
    private static File systemRootModFile;
    private static boolean isSystemRootModified;
    private static long systemRootModTime;
    private Map prefsCache = null;
    private long lastSyncTime = 0L;
    private static final int EAGAIN = 11;
    private static final int EACCES = 13;
    private static final int LOCK_HANDLE = 0;
    private static final int ERROR_CODE = 1;
    final List changeLog = new ArrayList();
    NodeCreate nodeCreate = null;
    private static Timer syncTimer;
    private final boolean isUserNode;
    private static final String[] EMPTY_STRING_ARRAY;
    private static int INIT_SLEEP_TIME;
    private static int MAX_ATTEMPTS;
    static /* synthetic */ Class class$java$util$prefs$FileSystemPreferences;

    static {
        userRoot = null;
        userRootLockHandle = 0;
        systemRootLockHandle = 0;
        isUserRootModified = false;
        isSystemRootModified = false;
        syncTimer = new Timer(true);
        syncTimer.schedule(new TimerTask(){

            public void run() {
                FileSystemPreferences.syncWorld();
            }
        }, SYNC_INTERVAL * 1000, (long)(SYNC_INTERVAL * 1000));
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                Runtime.getRuntime().addShutdownHook(new Thread(this){
                    private final /* synthetic */ 5 this$0;

                    public void run() {
                        FileSystemPreferences.access$1300().cancel();
                        FileSystemPreferences.access$1200();
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
                return null;
            }
        });
        EMPTY_STRING_ARRAY = new String[0];
        INIT_SLEEP_TIME = 50;
        MAX_ATTEMPTS = 5;
    }

    public void flush() throws BackingStoreException {
        if (this.isRemoved()) {
            return;
        }
        this.sync();
    }

    protected void flushSpi() throws BackingStoreException {
    }

    private void initCacheIfNecessary() {
        if (this.prefsCache != null) {
            return;
        }
        try {
            this.loadCache();
        }
        catch (Exception exception) {
            this.prefsCache = new TreeMap();
        }
    }

    private void loadCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    TreeMap treeMap = new TreeMap();
                    long l2 = 0L;
                    try {
                        l2 = FileSystemPreferences.this.prefsFile.lastModified();
                        FileInputStream fileInputStream = new FileInputStream(FileSystemPreferences.this.prefsFile);
                        XmlSupport.importMap(fileInputStream, treeMap);
                        fileInputStream.close();
                    }
                    catch (Exception exception) {
                        if (exception instanceof InvalidPreferencesFormatException) {
                            FileSystemPreferences.getLogger().warning("Invalid preferences format in " + FileSystemPreferences.this.prefsFile.getPath());
                            FileSystemPreferences.this.prefsFile.renameTo(new File(FileSystemPreferences.this.prefsFile.getParentFile(), "IncorrectFormatPrefs.xml"));
                            treeMap = new TreeMap();
                        }
                        if (exception instanceof FileNotFoundException) {
                            FileSystemPreferences.getLogger().warning("Prefs file removed in background " + FileSystemPreferences.this.prefsFile.getPath());
                        }
                        throw new BackingStoreException(exception);
                    }
                    FileSystemPreferences.this.prefsCache = treeMap;
                    FileSystemPreferences.this.lastSyncTime = l2;
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode() throws BackingStoreException {
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(false)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            try {
                super.removeNode();
                Object var3_2 = null;
                this.unlockFile();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.unlockFile();
                throw throwable;
            }
        }
    }

    protected void removeNodeSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    if (FileSystemPreferences.this.changeLog.contains(FileSystemPreferences.this.nodeCreate)) {
                        FileSystemPreferences.this.changeLog.remove(FileSystemPreferences.this.nodeCreate);
                        FileSystemPreferences.this.nodeCreate = null;
                        return null;
                    }
                    if (!FileSystemPreferences.this.dir.exists()) {
                        return null;
                    }
                    FileSystemPreferences.this.prefsFile.delete();
                    FileSystemPreferences.this.tmpFile.delete();
                    Object[] objectArray = FileSystemPreferences.this.dir.listFiles();
                    if (objectArray.length != 0) {
                        FileSystemPreferences.getLogger().warning("Found extraneous files when removing node: " + Arrays.asList(objectArray));
                        int n2 = 0;
                        while (n2 < objectArray.length) {
                            ((File)objectArray[n2]).delete();
                            ++n2;
                        }
                    }
                    if (!FileSystemPreferences.this.dir.delete()) {
                        throw new BackingStoreException("Couldn't delete dir: " + FileSystemPreferences.this.dir);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    private void replayChanges() {
        int n2 = 0;
        int n3 = this.changeLog.size();
        while (n2 < n3) {
            ((Change)this.changeLog.get(n2)).replay();
            ++n2;
        }
    }

    private static void setupSystemRoot() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("java.util.prefs.systemRoot", "/etc/.java");
                systemRootDir = new File(string, ".systemPrefs");
                if (!systemRootDir.exists()) {
                    systemRootDir = new File(System.getProperty("java.home"), ".systemPrefs");
                    if (!systemRootDir.exists()) {
                        if (systemRootDir.mkdirs()) {
                            FileSystemPreferences.getLogger().info("Created system preferences directoryin java.home.");
                            try {
                                FileSystemPreferences.chmod(systemRootDir.getCanonicalPath(), 493);
                            }
                            catch (IOException iOException) {}
                        } else {
                            FileSystemPreferences.getLogger().warning("Could not create system preferences directory. System preferences are unusable.");
                        }
                    }
                }
                isSystemRootWritable = systemRootDir.canWrite();
                systemLockFile = new File(systemRootDir, ".system.lock");
                systemRootModFile = new File(systemRootDir, ".systemRootModFile");
                if (!systemRootModFile.exists() && isSystemRootWritable) {
                    try {
                        systemRootModFile.createNewFile();
                        int n2 = FileSystemPreferences.chmod(systemRootModFile.getCanonicalPath(), 420);
                        if (n2 != 0) {
                            FileSystemPreferences.getLogger().warning("Chmod failed on " + systemRootModFile.getCanonicalPath() + " Unix error code " + n2);
                        }
                    }
                    catch (IOException iOException) {
                        FileSystemPreferences.getLogger().warning(iOException.toString());
                    }
                }
                systemRootModTime = systemRootModFile.lastModified();
                return null;
            }
        });
    }

    private static void setupUserRoot() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                userRootDir = new File(System.getProperty("java.util.prefs.userRoot", System.getProperty("user.home")), ".java/.userPrefs");
                if (!userRootDir.exists()) {
                    if (userRootDir.mkdirs()) {
                        try {
                            FileSystemPreferences.chmod(userRootDir.getCanonicalPath(), 448);
                        }
                        catch (IOException iOException) {
                            FileSystemPreferences.getLogger().warning("Could not change permissions on userRoot directory. ");
                        }
                        FileSystemPreferences.getLogger().info("Created user preferences directory.");
                    } else {
                        FileSystemPreferences.getLogger().warning("Couldn't create user preferences directory. User preferences are unusable.");
                    }
                }
                isUserRootWritable = userRootDir.canWrite();
                String string = System.getProperty("user.name");
                userLockFile = new File(userRootDir, ".user.lock." + string);
                userRootModFile = new File(userRootDir, ".userRootModFile." + string);
                if (!userRootModFile.exists()) {
                    try {
                        userRootModFile.createNewFile();
                        int n2 = FileSystemPreferences.chmod(userRootModFile.getCanonicalPath(), 384);
                        if (n2 != 0) {
                            FileSystemPreferences.getLogger().warning("Problem creating userRoot mod file. Chmod failed on " + userRootModFile.getCanonicalPath() + " Unix error code " + n2);
                        }
                    }
                    catch (IOException iOException) {
                        FileSystemPreferences.getLogger().warning(iOException.toString());
                    }
                }
                userRootModTime = userRootModFile.lastModified();
                return null;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void sync() throws BackingStoreException {
        boolean bl2 = this.isUserNode();
        boolean bl3 = bl2 ? false : !isSystemRootWritable;
        File file = this.isUserNode() ? userLockFile : systemLockFile;
        synchronized (file) {
            if (!this.lockFile(bl3)) {
                throw new BackingStoreException("Couldn't get file lock.");
            }
            final Long l2 = (Long)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    long l2;
                    if (FileSystemPreferences.this.isUserNode()) {
                        l2 = userRootModFile.lastModified();
                        isUserRootModified = userRootModTime == l2;
                    } else {
                        l2 = systemRootModFile.lastModified();
                        isSystemRootModified = systemRootModTime == l2;
                    }
                    return new Long(l2);
                }
            });
            try {
                super.sync();
                AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        if (FileSystemPreferences.this.isUserNode()) {
                            userRootModTime = l2 + 1000L;
                            userRootModFile.setLastModified(userRootModTime);
                        } else {
                            systemRootModTime = l2 + 1000L;
                            systemRootModFile.setLastModified(systemRootModTime);
                        }
                        return null;
                    }
                });
                Object var6_5 = null;
                this.unlockFile();
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                this.unlockFile();
                throw throwable;
            }
        }
    }

    protected void syncSpi() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    FileSystemPreferences.this.syncSpiPrivileged();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    private void syncSpiPrivileged() throws BackingStoreException {
        long l2;
        if (this.isRemoved()) {
            throw new IllegalStateException("Node has been removed");
        }
        if (this.prefsCache == null) {
            return;
        }
        if (this.isUserNode() ? isUserRootModified : isSystemRootModified) {
            l2 = this.prefsFile.lastModified();
            if (l2 != this.lastSyncTime) {
                this.loadCache();
                this.replayChanges();
                this.lastSyncTime = l2;
            }
        } else if (this.lastSyncTime != 0L && !this.dir.exists()) {
            this.prefsCache = new TreeMap();
            this.replayChanges();
        }
        if (!this.changeLog.isEmpty()) {
            this.writeBackCache();
            l2 = this.prefsFile.lastModified();
            if (this.lastSyncTime <= l2) {
                this.lastSyncTime = l2 + 1000L;
                this.prefsFile.setLastModified(this.lastSyncTime);
            }
            this.changeLog.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void syncWorld() {
        Preferences preferences;
        Preferences preferences2;
        Class clazz = class$java$util$prefs$FileSystemPreferences == null ? (class$java$util$prefs$FileSystemPreferences = FileSystemPreferences.class$("java.util.prefs.FileSystemPreferences")) : class$java$util$prefs$FileSystemPreferences;
        synchronized (clazz) {
            preferences2 = userRoot;
            preferences = systemRoot;
        }
        try {
            if (preferences2 != null) {
                preferences2.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            FileSystemPreferences.getLogger().warning("Couldn't flush user prefs: " + backingStoreException);
        }
        try {
            if (preferences != null) {
                preferences.flush();
            }
        }
        catch (BackingStoreException backingStoreException) {
            FileSystemPreferences.getLogger().warning("Couldn't flush system prefs: " + backingStoreException);
        }
    }

    private void unlockFile() {
        int n2;
        boolean bl2 = this.isUserNode();
        File file = bl2 ? userLockFile : systemLockFile;
        int n3 = n2 = bl2 ? userRootLockHandle : systemRootLockHandle;
        if (n2 == 0) {
            FileSystemPreferences.getLogger().warning("Unlock: zero lockHandle for " + (bl2 ? "user" : "system") + " preferences.)");
            return;
        }
        int n4 = FileSystemPreferences.unlockFile0(n2);
        if (n4 != 0) {
            FileSystemPreferences.getLogger().warning("Could not drop file-lock on " + (this.isUserNode() ? "user" : "system") + " preferences." + "Unix error code " + n4 + ".");
            if (n4 == 13) {
                throw new SecurityException("Could not unlock" + (this.isUserNode() ? "User prefs." : "System prefs.") + "Lock file access denied.");
            }
        }
        if (this.isUserNode()) {
            userRootLockHandle = 0;
        } else {
            systemRootLockHandle = 0;
        }
    }

    private void writeBackCache() throws BackingStoreException {
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws BackingStoreException {
                    try {
                        if (!FileSystemPreferences.this.dir.exists() && !FileSystemPreferences.this.dir.mkdirs()) {
                            throw new BackingStoreException(FileSystemPreferences.this.dir + " create failed.");
                        }
                        FileOutputStream fileOutputStream = new FileOutputStream(FileSystemPreferences.this.tmpFile);
                        XmlSupport.exportMap(fileOutputStream, FileSystemPreferences.this.prefsCache);
                        fileOutputStream.close();
                        if (!FileSystemPreferences.this.tmpFile.renameTo(FileSystemPreferences.this.prefsFile)) {
                            throw new BackingStoreException("Can't rename " + FileSystemPreferences.this.tmpFile + " to " + FileSystemPreferences.this.prefsFile);
                        }
                    }
                    catch (Exception exception) {
                        if (exception instanceof BackingStoreException) {
                            throw (BackingStoreException)exception;
                        }
                        throw new BackingStoreException(exception);
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (BackingStoreException)privilegedActionException.getException();
        }
    }

    public boolean isUserNode() {
        return this.isUserNode;
    }

    private static boolean isDirChar(char c2) {
        return c2 > '\u001f' && c2 < '\u007f' && c2 != '/' && c2 != '.' && c2 != '_';
    }

    private static native int unlockFile0(int var0);

    private void checkLockFile0ErrorCode(int n2) throws SecurityException {
        if (n2 == 13) {
            throw new SecurityException("Could not lock" + (this.isUserNode() ? "User prefs." : "System prefs.") + "Lock file access denied.");
        }
        if (n2 != 11) {
            FileSystemPreferences.getLogger().warning("Could not lock " + (this.isUserNode() ? "User prefs. " : "System prefs.") + "Unix error code " + n2 + ".");
        }
    }

    private FileSystemPreferences(boolean bl2) {
        super(null, "");
        this.isUserNode = bl2;
        this.dir = bl2 ? userRootDir : systemRootDir;
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
    }

    private boolean lockFile(boolean bl2) throws SecurityException {
        boolean bl3 = this.isUserNode();
        int n2 = 0;
        File file = bl3 ? userLockFile : systemLockFile;
        long l2 = INIT_SLEEP_TIME;
        int n3 = 0;
        while (n3 < MAX_ATTEMPTS) {
            try {
                int n4 = bl3 ? 384 : 420;
                int[] nArray = FileSystemPreferences.lockFile0(file.getCanonicalPath(), n4, bl2);
                n2 = nArray[1];
                if (nArray[0] != 0) {
                    if (bl3) {
                        userRootLockHandle = nArray[0];
                    } else {
                        systemRootLockHandle = nArray[0];
                    }
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                Thread.sleep(l2);
            }
            catch (InterruptedException interruptedException) {
                this.checkLockFile0ErrorCode(n2);
                return false;
            }
            l2 *= 2L;
            ++n3;
        }
        this.checkLockFile0ErrorCode(n2);
        return false;
    }

    protected String[] childrenNamesSpi() {
        return (String[])AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                ArrayList arrayList = new ArrayList();
                File[] fileArray = FileSystemPreferences.this.dir.listFiles();
                if (fileArray != null) {
                    int n2 = 0;
                    while (n2 < fileArray.length) {
                        if (fileArray[n2].isDirectory()) {
                            arrayList.add(FileSystemPreferences.nodeName(fileArray[n2].getName()));
                        }
                        ++n2;
                    }
                }
                return arrayList.toArray(EMPTY_STRING_ARRAY);
            }
        });
    }

    protected String[] keysSpi() {
        this.initCacheIfNecessary();
        return (String[])this.prefsCache.keySet().toArray(new String[this.prefsCache.size()]);
    }

    protected void removeSpi(String string) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Remove(string));
        this.prefsCache.remove(string);
    }

    private static byte[] byteArray(String string) {
        int n2 = string.length();
        byte[] byArray = new byte[2 * n2];
        int n3 = 0;
        int n4 = 0;
        while (n3 < n2) {
            char c2 = string.charAt(n3);
            byArray[n4++] = (byte)(c2 >> 8);
            byArray[n4++] = (byte)c2;
            ++n3;
        }
        return byArray;
    }

    private static native int chmod(String var0, int var1);

    private static native int[] lockFile0(String var0, int var1, boolean var2);

    static /* synthetic */ Timer access$1300() {
        return syncTimer;
    }

    private static Logger getLogger() {
        return Logger.getLogger("java.util.prefs");
    }

    static synchronized Preferences getSystemRoot() {
        if (systemRoot == null) {
            FileSystemPreferences.setupSystemRoot();
            systemRoot = new FileSystemPreferences(false);
        }
        return systemRoot;
    }

    static synchronized Preferences getUserRoot() {
        if (userRoot == null) {
            FileSystemPreferences.setupUserRoot();
            userRoot = new FileSystemPreferences(true);
        }
        return userRoot;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private static String dirName(String string) {
        int n2 = 0;
        int n3 = string.length();
        while (n2 < n3) {
            if (!FileSystemPreferences.isDirChar(string.charAt(n2))) {
                return "_" + Base64.byteArrayToAltBase64(FileSystemPreferences.byteArray(string));
            }
            ++n2;
        }
        return string;
    }

    protected String getSpi(String string) {
        this.initCacheIfNecessary();
        return (String)this.prefsCache.get(string);
    }

    private static String nodeName(String string) {
        if (string.charAt(0) != '_') {
            return string;
        }
        byte[] byArray = Base64.altBase64ToByteArray(string.substring(1));
        StringBuffer stringBuffer = new StringBuffer(byArray.length / 2);
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3 = byArray[n2++] & 0xFF;
            int n4 = byArray[n2++] & 0xFF;
            stringBuffer.append((char)(n3 << 8 | n4));
        }
        return stringBuffer.toString();
    }

    protected void putSpi(String string, String string2) {
        this.initCacheIfNecessary();
        this.changeLog.add(new Put(string, string2));
        this.prefsCache.put(string, string2);
    }

    private FileSystemPreferences(FileSystemPreferences fileSystemPreferences, String string) {
        super(fileSystemPreferences, string);
        this.isUserNode = fileSystemPreferences.isUserNode;
        this.dir = new File(fileSystemPreferences.dir, FileSystemPreferences.dirName(string));
        this.prefsFile = new File(this.dir, "prefs.xml");
        this.tmpFile = new File(this.dir, "prefs.tmp");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                FileSystemPreferences.this.newNode = !FileSystemPreferences.this.dir.exists();
                return null;
            }
        });
        if (this.newNode) {
            this.prefsCache = new TreeMap();
            this.nodeCreate = new NodeCreate();
            this.changeLog.add(this.nodeCreate);
        }
    }

    protected AbstractPreferences childSpi(String string) {
        return new FileSystemPreferences(this, string);
    }

    private abstract class Change {
        abstract void replay();

        private Change() {
        }
    }

    private class NodeCreate
    extends Change {
        void replay() {
        }

        private NodeCreate() {
        }
    }

    private class Put
    extends Change {
        String key;
        String value;

        void replay() {
            FileSystemPreferences.this.prefsCache.put(this.key, this.value);
        }

        Put(String string, String string2) {
            this.key = string;
            this.value = string2;
        }
    }

    private class Remove
    extends Change {
        String key;

        void replay() {
            FileSystemPreferences.this.prefsCache.remove(this.key);
        }

        Remove(String string) {
            this.key = string;
        }
    }
}

