/*
 * Decompiled with CFR 0.152.
 */
package java.net;

import java.io.FileDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetAddressContainer;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketImpl;
import java.net.SocketInputStream;
import java.net.SocketOutputStream;
import java.net.UnknownHostException;
import java.security.AccessController;
import sun.net.ConnectionResetException;
import sun.security.action.LoadLibraryAction;

class PlainSocketImpl
extends SocketImpl {
    int timeout;
    private int trafficClass;
    private boolean shut_rd = false;
    private boolean shut_wr = false;
    private SocketInputStream socketInputStream = null;
    private int fdUseCount = 0;
    private Object fdLock = new Object();
    private boolean closePending = false;
    private int CONNECTION_NOT_RESET = 0;
    private int CONNECTION_RESET_PENDING = 1;
    private int CONNECTION_RESET = 2;
    private int resetState;
    private Object resetLock = new Object();
    public static final int SHUT_RD = 0;
    public static final int SHUT_WR = 1;

    protected synchronized int available() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Stream closed.");
        }
        if (this.isConnectionReset()) {
            return 0;
        }
        int n2 = 0;
        try {
            n2 = this.socketAvailable();
            if (n2 == 0 && this.isConnectionResetPending()) {
                this.setConnectionReset();
            }
        }
        catch (ConnectionResetException connectionResetException) {
            this.setConnectionResetPending();
            try {
                n2 = this.socketAvailable();
                if (n2 == 0) {
                    this.setConnectionReset();
                }
            }
            catch (ConnectionResetException connectionResetException2) {
                // empty catch block
            }
        }
        return n2;
    }

    public int getTimeout() {
        return this.timeout;
    }

    private native int socketAvailable() throws IOException;

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
        PlainSocketImpl.initProto();
    }

    PlainSocketImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() throws IOException {
        Object object = this.fdLock;
        synchronized (object) {
            if (this.fd != null) {
                if (this.fdUseCount == 0) {
                    this.closePending = true;
                    try {
                        this.socketPreClose();
                    }
                    finally {
                        this.socketClose();
                    }
                    this.fd = null;
                    return;
                }
                if (!this.closePending) {
                    this.closePending = true;
                    --this.fdUseCount;
                    this.socketPreClose();
                }
            }
        }
    }

    protected void finalize() throws IOException {
        this.close();
    }

    private static native void initProto();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void releaseFD() {
        Object object = this.fdLock;
        synchronized (object) {
            --this.fdUseCount;
            if (this.fdUseCount == -1 && this.fd != null) {
                try {
                    this.socketClose();
                }
                catch (IOException iOException) {
                }
                finally {
                    this.fd = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            this.resetState = this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            if (this.resetState == this.CONNECTION_NOT_RESET) {
                this.resetState = this.CONNECTION_RESET_PENDING;
            }
        }
    }

    protected void shutdownInput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(0);
            if (this.socketInputStream != null) {
                this.socketInputStream.setEOF(true);
            }
            this.shut_rd = true;
        }
    }

    protected void shutdownOutput() throws IOException {
        if (this.fd != null) {
            this.socketShutdown(1);
            this.shut_wr = true;
        }
    }

    private void socketClose() throws IOException {
        this.socketClose0(false);
    }

    private void socketPreClose() throws IOException {
        this.socketClose0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isClosedOrPending() {
        Object object = this.fdLock;
        synchronized (object) {
            return this.closePending || this.fd == null;
            {
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionReset() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isConnectionResetPending() {
        Object object = this.resetLock;
        synchronized (object) {
            return this.resetState == this.CONNECTION_RESET_PENDING;
        }
    }

    protected boolean supportsUrgentData() {
        return true;
    }

    protected synchronized void listen(int n2) throws IOException {
        this.socketListen(n2);
    }

    protected void sendUrgentData(int n2) throws IOException {
        if (this.fd == null) {
            throw new IOException("Socket Closed");
        }
        this.socketSendUrgentData(n2);
    }

    private native void socketListen(int var1) throws IOException;

    private native void socketSendUrgentData(int var1) throws IOException;

    private native void socketShutdown(int var1) throws IOException;

    protected synchronized void create(boolean bl2) throws IOException {
        this.fd = new FileDescriptor();
        this.socketCreate(bl2);
        if (this.socket != null) {
            this.socket.setCreated();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setCreated();
        }
    }

    private native void socketClose0(boolean var1) throws IOException;

    private native void socketCreate(boolean var1) throws IOException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FileDescriptor acquireFD() {
        Object object = this.fdLock;
        synchronized (object) {
            ++this.fdUseCount;
            return this.fd;
        }
    }

    PlainSocketImpl(FileDescriptor fileDescriptor) {
        this.fd = fileDescriptor;
    }

    protected synchronized InputStream getInputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_rd) {
            throw new IOException("Socket input is shutdown");
        }
        if (this.socketInputStream == null) {
            this.socketInputStream = new SocketInputStream(this);
        }
        return this.socketInputStream;
    }

    protected synchronized OutputStream getOutputStream() throws IOException {
        if (this.isClosedOrPending()) {
            throw new IOException("Socket Closed");
        }
        if (this.shut_wr) {
            throw new IOException("Socket output is shutdown");
        }
        return new SocketOutputStream(this);
    }

    public Object getOption(int n2) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        if (n2 == 4102) {
            return new Integer(this.timeout);
        }
        int n3 = 0;
        switch (n2) {
            case 1: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? new Boolean(false) : new Boolean(true);
            }
            case 4099: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? new Boolean(false) : new Boolean(true);
            }
            case 128: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? (Serializable)new Boolean(false) : (Serializable)new Integer(n3);
            }
            case 4: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? new Boolean(false) : new Boolean(true);
            }
            case 15: {
                InetAddressContainer inetAddressContainer = new InetAddressContainer();
                n3 = this.socketGetOption(n2, inetAddressContainer);
                return inetAddressContainer.addr;
            }
            case 4097: 
            case 4098: {
                n3 = this.socketGetOption(n2, null);
                return new Integer(n3);
            }
            case 3: {
                n3 = this.socketGetOption(n2, null);
                if (n3 == -1) {
                    return new Integer(this.trafficClass);
                }
                return new Integer(n3);
            }
            case 8: {
                n3 = this.socketGetOption(n2, null);
                return n3 == -1 ? new Boolean(false) : new Boolean(true);
            }
        }
        return null;
    }

    private native int socketGetOption(int var1, Object var2) throws SocketException;

    public void setOption(int n2, Object object) throws SocketException {
        if (this.isClosedOrPending()) {
            throw new SocketException("Socket Closed");
        }
        boolean bl2 = true;
        switch (n2) {
            case 128: {
                if (object == null || !(object instanceof Integer) && !(object instanceof Boolean)) {
                    throw new SocketException("Bad parameter for option");
                }
                if (!(object instanceof Boolean)) break;
                bl2 = false;
                break;
            }
            case 4102: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("Bad parameter for SO_TIMEOUT");
                }
                int n3 = (Integer)object;
                if (n3 < 0) {
                    throw new IllegalArgumentException("timeout < 0");
                }
                this.timeout = n3;
                break;
            }
            case 3: {
                if (object == null || !(object instanceof Integer)) {
                    throw new SocketException("bad argument for IP_TOS");
                }
                this.trafficClass = (Integer)object;
                break;
            }
            case 15: {
                throw new SocketException("Cannot re-bind socket");
            }
            case 1: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for TCP_NODELAY");
                }
                bl2 = (Boolean)object;
                break;
            }
            case 4097: 
            case 4098: {
                if (object != null && object instanceof Integer && (Integer)object > 0) break;
                throw new SocketException("bad parameter for SO_SNDBUF or SO_RCVBUF");
            }
            case 8: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_KEEPALIVE");
                }
                bl2 = (Boolean)object;
                break;
            }
            case 4099: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_OOBINLINE");
                }
                bl2 = (Boolean)object;
                break;
            }
            case 4: {
                if (object == null || !(object instanceof Boolean)) {
                    throw new SocketException("bad parameter for SO_REUSEADDR");
                }
                bl2 = (Boolean)object;
                break;
            }
            default: {
                throw new SocketException("unrecognized TCP option: " + n2);
            }
        }
        this.socketSetOption(n2, bl2, object);
    }

    private native void socketSetOption(int var1, boolean var2, Object var3) throws SocketException;

    protected void connect(String string, int n2) throws UnknownHostException, IOException {
        IOException iOException = null;
        try {
            InetAddress inetAddress = InetAddress.getByName(string);
            try {
                this.connectToAddress(inetAddress, n2, this.timeout);
                return;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
            }
        }
        catch (UnknownHostException unknownHostException) {
            iOException = unknownHostException;
        }
        this.close();
        throw iOException;
    }

    protected synchronized void bind(InetAddress inetAddress, int n2) throws IOException {
        this.socketBind(inetAddress, n2);
        if (this.socket != null) {
            this.socket.setBound();
        }
        if (this.serverSocket != null) {
            this.serverSocket.setBound();
        }
    }

    protected void connect(InetAddress inetAddress, int n2) throws IOException {
        this.port = n2;
        this.address = inetAddress;
        try {
            this.connectToAddress(inetAddress, n2, this.timeout);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private native void socketBind(InetAddress var1, int var2) throws IOException;

    private void connectToAddress(InetAddress inetAddress, int n2, int n3) throws IOException {
        if (inetAddress.isAnyLocalAddress()) {
            this.doConnect(InetAddress.getLocalHost(), n2, n3);
        } else {
            this.doConnect(inetAddress, n2, n3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void doConnect(InetAddress inetAddress, int n2, int n3) throws IOException {
        try {
            FileDescriptor fileDescriptor = this.acquireFD();
            try {
                this.socketConnect(inetAddress, n2, n3);
                if (this.socket != null) {
                    this.socket.setBound();
                    this.socket.setConnected();
                }
            }
            finally {
                this.releaseFD();
            }
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    private native void socketConnect(InetAddress var1, int var2, int var3) throws IOException;

    protected void connect(SocketAddress socketAddress, int n2) throws IOException {
        if (socketAddress == null || !(socketAddress instanceof InetSocketAddress)) {
            throw new IllegalArgumentException("unsupported address type");
        }
        InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
        if (inetSocketAddress.isUnresolved()) {
            throw new UnknownHostException(inetSocketAddress.getHostName());
        }
        this.port = inetSocketAddress.getPort();
        this.address = inetSocketAddress.getAddress();
        try {
            this.connectToAddress(this.address, this.port, n2);
            return;
        }
        catch (IOException iOException) {
            this.close();
            throw iOException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void accept(SocketImpl socketImpl) throws IOException {
        FileDescriptor fileDescriptor = this.acquireFD();
        try {
            this.socketAccept(socketImpl);
        }
        finally {
            this.releaseFD();
        }
    }

    private native void socketAccept(SocketImpl var1) throws IOException;

    void setInputStream(SocketInputStream socketInputStream) {
        this.socketInputStream = socketInputStream;
    }
}

