/*
 * Decompiled with CFR 0.152.
 */
package java.awt;

import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Menu;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.MenuItem;
import java.awt.MenuShortcut;
import java.awt.Toolkit;
import java.awt.event.KeyEvent;
import java.awt.peer.MenuBarPeer;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleRole;

public class MenuBar
extends MenuComponent
implements MenuContainer,
Accessible {
    Vector menus = new Vector();
    Menu helpMenu;
    private static final String base = "menubar";
    private static int nameCounter;
    private static final long serialVersionUID = -4930327919388951260L;
    private int menuBarSerializedDataVersion = 1;

    public int countMenus() {
        return this.getMenuCountImpl();
    }

    public int getMenuCount() {
        return this.countMenus();
    }

    final int getMenuCountImpl() {
        return this.menus.size();
    }

    static {
        Toolkit.loadLibraries();
        if (!GraphicsEnvironment.isHeadless()) {
            MenuBar.initIDs();
        }
        nameCounter = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.peer == null) {
                this.peer = Toolkit.getDefaultToolkit().createMenuBar(this);
            }
            int n2 = this.getMenuCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getMenu(i2).addNotify();
            }
        }
    }

    private static native void initIDs();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNotify() {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.getMenuCount();
            for (int i2 = 0; i2 < n2; ++i2) {
                this.getMenu(i2).removeNotify();
            }
            super.removeNotify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(int n2) {
        Object object = this.getTreeLock();
        synchronized (object) {
            Menu menu = this.getMenu(n2);
            this.menus.removeElementAt(n2);
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                menu.removeNotify();
                menu.parent = null;
                menuBarPeer.delMenu(n2);
            }
        }
    }

    public Menu getHelpMenu() {
        return this.helpMenu;
    }

    public Menu getMenu(int n2) {
        return this.getMenuImpl(n2);
    }

    final Menu getMenuImpl(int n2) {
        return (Menu)this.menus.elementAt(n2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHelpMenu(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (this.helpMenu == menu) {
                return;
            }
            if (this.helpMenu != null) {
                this.remove(this.helpMenu);
            }
            if (menu.parent != this) {
                this.add(menu);
            }
            this.helpMenu = menu;
            if (menu != null) {
                menu.isHelpMenu = true;
                menu.parent = this;
                MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
                if (menuBarPeer != null) {
                    if (menu.peer == null) {
                        menu.addNotify();
                    }
                    menuBarPeer.addHelpMenu(menu);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(MenuComponent menuComponent) {
        Object object = this.getTreeLock();
        synchronized (object) {
            int n2 = this.menus.indexOf(menuComponent);
            if (n2 >= 0) {
                this.remove(n2);
            }
        }
    }

    public void deleteShortcut(MenuShortcut menuShortcut) {
        int n2 = this.getMenuCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            this.getMenu(i2).deleteShortcut(menuShortcut);
        }
    }

    boolean handleShortcut(KeyEvent keyEvent) {
        int n2 = keyEvent.getID();
        if (n2 != 401 && n2 != 402) {
            return false;
        }
        int n3 = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        if ((keyEvent.getModifiers() & n3) == 0) {
            return false;
        }
        int n4 = this.getMenuCount();
        for (int i2 = 0; i2 < n4; ++i2) {
            Menu menu = this.getMenu(i2);
            if (!menu.handleShortcut(keyEvent)) continue;
            return true;
        }
        return false;
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException, HeadlessException {
        objectInputStream.defaultReadObject();
        for (int i2 = 0; i2 < this.menus.size(); ++i2) {
            Menu menu = (Menu)this.menus.elementAt(i2);
            menu.parent = this;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws ClassNotFoundException, IOException {
        objectOutputStream.defaultWriteObject();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String constructComponentName() {
        Class clazz = this.getClass();
        synchronized (clazz) {
            return base + nameCounter++;
        }
    }

    public synchronized Enumeration shortcuts() {
        Vector vector = new Vector();
        int n2 = this.getMenuCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            Enumeration enumeration = this.getMenu(i2).shortcuts();
            while (enumeration.hasMoreElements()) {
                vector.addElement(enumeration.nextElement());
            }
        }
        return vector.elements();
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleAWTMenuBar();
        }
        return this.accessibleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Menu add(Menu menu) {
        Object object = this.getTreeLock();
        synchronized (object) {
            if (menu.parent != null) {
                menu.parent.remove(menu);
            }
            this.menus.addElement(menu);
            menu.parent = this;
            MenuBarPeer menuBarPeer = (MenuBarPeer)this.peer;
            if (menuBarPeer != null) {
                if (menu.peer == null) {
                    menu.addNotify();
                }
                menuBarPeer.addMenu(menu);
            }
            return menu;
        }
    }

    public MenuItem getShortcutMenuItem(MenuShortcut menuShortcut) {
        int n2 = this.getMenuCount();
        for (int i2 = 0; i2 < n2; ++i2) {
            MenuItem menuItem = this.getMenu(i2).getShortcutMenuItem(menuShortcut);
            if (menuItem == null) continue;
            return menuItem;
        }
        return null;
    }

    protected class AccessibleAWTMenuBar
    extends MenuComponent.AccessibleAWTMenuComponent {
        protected AccessibleAWTMenuBar() {
            super(MenuBar.this);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.MENU_BAR;
        }
    }
}

