/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.standard;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.DocErrorReporter;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.SourcePosition;
import com.sun.tools.doclets.ClassTree;
import com.sun.tools.doclets.DocletAbortException;
import com.sun.tools.doclets.IndexBuilder;
import com.sun.tools.doclets.SourceToHTMLConverter;
import com.sun.tools.doclets.Util;
import com.sun.tools.doclets.standard.AllClassesFrameWriter;
import com.sun.tools.doclets.standard.ClassUseMapper;
import com.sun.tools.doclets.standard.ClassWriter;
import com.sun.tools.doclets.standard.ConfigurationStandard;
import com.sun.tools.doclets.standard.ConstantsSummaryWriter;
import com.sun.tools.doclets.standard.DeprecatedListWriter;
import com.sun.tools.doclets.standard.FrameOutputWriter;
import com.sun.tools.doclets.standard.HelpWriter;
import com.sun.tools.doclets.standard.HtmlStandardWriter;
import com.sun.tools.doclets.standard.PackageFrameWriter;
import com.sun.tools.doclets.standard.PackageIndexFrameWriter;
import com.sun.tools.doclets.standard.PackageIndexWriter;
import com.sun.tools.doclets.standard.PackageListWriter;
import com.sun.tools.doclets.standard.PackageTreeWriter;
import com.sun.tools.doclets.standard.PackageWriter;
import com.sun.tools.doclets.standard.PackagesFileWriter;
import com.sun.tools.doclets.standard.SerializedFormWriter;
import com.sun.tools.doclets.standard.SingleIndexWriter;
import com.sun.tools.doclets.standard.SplitIndexWriter;
import com.sun.tools.doclets.standard.StylesheetWriter;
import com.sun.tools.doclets.standard.TreeWriter;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.StringTokenizer;

public class Standard {
    public static final String BUILD_DATE = System.getProperty("java.version");
    public ConfigurationStandard configuration = Standard.configuration();

    protected void startGeneration(RootDoc rootDoc) {
        Object object;
        if (rootDoc.classes().length == 0) {
            this.configuration.standardmessage.error("doclet.No_Public_Classes_To_Document");
            return;
        }
        this.configuration.setOptions(rootDoc);
        if (!this.configuration.quiet) {
            this.configuration.standardmessage.notice("stddoclet.version", BUILD_DATE);
            this.configuration.printedVersion = true;
        }
        if (this.configuration.genSrc) {
            if (this.configuration.destdirname.length() > 0) {
                SourceToHTMLConverter.convertRoot(this.configuration, rootDoc, this.configuration.destdirname + File.separator + "src-html/");
            } else {
                SourceToHTMLConverter.convertRoot(this.configuration, rootDoc, "src-html/");
            }
        }
        ConstantsSummaryWriter.generate(this.configuration);
        if (this.configuration.topFile.length() == 0) {
            this.configuration.standardmessage.error("doclet.No_Non_Deprecated_Classes_To_Document");
            return;
        }
        boolean bl = this.configuration.nodeprecated;
        String string = this.configuration.destdirname;
        String string2 = this.configuration.helpfile;
        String string3 = this.configuration.stylesheetfile;
        this.performCopy(string, string2);
        this.performCopy(string, string3);
        Util.copyResourceFile(this.configuration, "inherit.gif", false);
        ClassTree classTree = new ClassTree(this.configuration, bl);
        if (this.configuration.classuse) {
            ClassUseMapper.generate(this.configuration, classTree);
        }
        IndexBuilder indexBuilder = new IndexBuilder(this.configuration, bl);
        PackageDoc[] packageDocArray = this.configuration.packages;
        if (this.configuration.createtree) {
            TreeWriter.generate(this.configuration, classTree);
        }
        if (this.configuration.createindex) {
            if (this.configuration.splitindex) {
                SplitIndexWriter.generate(this.configuration, indexBuilder);
            } else {
                SingleIndexWriter.generate(this.configuration, indexBuilder);
            }
        }
        if (!this.configuration.nodeprecatedlist && !bl) {
            DeprecatedListWriter.generate(this.configuration);
        }
        AllClassesFrameWriter.generate(this.configuration, new IndexBuilder(this.configuration, bl, true));
        FrameOutputWriter.generate(this.configuration);
        PackagesFileWriter.generate(this.configuration);
        if (this.configuration.createoverview) {
            PackageIndexWriter.generate(this.configuration);
        }
        if (packageDocArray.length > 1) {
            PackageIndexFrameWriter.generate(this.configuration);
        }
        if (packageDocArray.length != 1 || !packageDocArray[0].name().equals("")) {
            object = null;
            int n = 0;
            while (n < packageDocArray.length) {
                PackageFrameWriter.generate(this.configuration, packageDocArray[n]);
                if (packageDocArray[n].name().length() != 0) {
                    PackageDoc packageDoc = n + 1 < packageDocArray.length && packageDocArray[n + 1].name().length() > 0 ? packageDocArray[n + 1] : null;
                    packageDoc = n + 2 < packageDocArray.length && packageDoc == null ? packageDocArray[n + 2] : packageDoc;
                    PackageWriter.generate(this.configuration, packageDocArray[n], (PackageDoc)object, packageDoc);
                    if (this.configuration.createtree) {
                        PackageTreeWriter.generate(this.configuration, packageDocArray[n], (PackageDoc)object, packageDoc, bl);
                    }
                    object = packageDocArray[n];
                }
                ++n;
            }
        }
        this.generateClassFiles(rootDoc, classTree);
        if (this.configuration.sourcepath != null && this.configuration.sourcepath.length() > 0) {
            object = new StringTokenizer(this.configuration.sourcepath, ":");
            boolean bl2 = true;
            while (((StringTokenizer)object).hasMoreTokens()) {
                HtmlStandardWriter.copyDocFiles(this.configuration, ((StringTokenizer)object).nextToken() + File.separator, "doc-files", bl2);
                bl2 = false;
            }
        }
        if (this.generateSerializedFormPage(rootDoc)) {
            SerializedFormWriter.generate(this.configuration);
        }
        PackageListWriter.generate(this.configuration);
        if (this.configuration.helpfile.length() == 0 && !this.configuration.nohelp) {
            HelpWriter.generate(this.configuration);
        }
        if (this.configuration.stylesheetfile.length() == 0) {
            StylesheetWriter.generate(this.configuration);
        }
        this.configuration.tagletManager.printReport();
    }

    public boolean generateSerializedFormPage(RootDoc rootDoc) {
        PackageDoc[] packageDocArray = rootDoc.specifiedPackages();
        ClassDoc[] classDocArray = rootDoc.specifiedClasses();
        int n = 0;
        while (n < packageDocArray.length) {
            PackageDoc packageDoc = packageDocArray[n];
            boolean bl = HtmlStandardWriter.serialInclude(packageDoc);
            if (bl) {
                ClassDoc[] classDocArray2 = packageDoc.allClasses();
                int n2 = 0;
                while (n2 < classDocArray2.length) {
                    if (HtmlStandardWriter.serialInclude(classDocArray2[n2])) {
                        return true;
                    }
                    ++n2;
                }
            }
            ++n;
        }
        int n3 = 0;
        while (n3 < classDocArray.length) {
            if (HtmlStandardWriter.serialInclude(classDocArray[n3])) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static boolean start(RootDoc rootDoc) throws IOException {
        try {
            new Standard().startGeneration(rootDoc);
        }
        catch (DocletAbortException docletAbortException) {
            return false;
        }
        return true;
    }

    protected void generateClassCycle(ClassTree classTree) {
        String[] stringArray = this.configuration.classDocCatalog.packageNames();
        int n = 0;
        while (n < stringArray.length) {
            Object[] objectArray = this.configuration.classDocCatalog.allClasses(stringArray[n]);
            Arrays.sort(objectArray);
            this.generateClassCycle((ClassDoc[])objectArray, classTree);
            ++n;
        }
    }

    public static ConfigurationStandard configuration() {
        return new ConfigurationStandard();
    }

    public static int optionLength(String string) {
        return new ConfigurationStandard().optionLength(string);
    }

    public static boolean validOptions(String[][] stringArray, DocErrorReporter docErrorReporter) throws IOException {
        return new ConfigurationStandard().validOptions(stringArray, docErrorReporter);
    }

    protected void generateClassCycle(ClassDoc[] classDocArray, ClassTree classTree) {
        Arrays.sort(classDocArray);
        int n = 0;
        while (n < classDocArray.length) {
            if (this.configuration.isGeneratedDoc(classDocArray[n]) && classDocArray[n].isIncluded()) {
                ClassDoc classDoc = n == 0 ? null : classDocArray[n - 1];
                ClassDoc classDoc2 = classDocArray[n];
                ClassDoc classDoc3 = n + 1 == classDocArray.length ? null : classDocArray[n + 1];
                ClassWriter.generate(this.configuration, classDoc2, classDoc, classDoc3, classTree);
            }
            ++n;
        }
    }

    protected void generateClassFiles(RootDoc rootDoc, ClassTree classTree) {
        this.generateClassCycle(classTree);
        PackageDoc[] packageDocArray = this.configuration.root.specifiedPackages();
        int n = 0;
        while (n < packageDocArray.length) {
            PackageDoc packageDoc = packageDocArray[n];
            this.generateClassCycle(packageDoc.interfaces(), classTree);
            this.generateClassCycle(packageDoc.ordinaryClasses(), classTree);
            this.generateClassCycle(packageDoc.exceptions(), classTree);
            this.generateClassCycle(packageDoc.errors(), classTree);
            ++n;
        }
    }

    protected String classFileName(ClassDoc classDoc) {
        return classDoc.qualifiedName() + ".html";
    }

    protected void performCopy(String string, String string2) {
        try {
            String string3;
            String string4 = string3 = string.length() > 0 ? string + File.separatorChar : "";
            if (string2.length() > 0) {
                File file = new File(string2);
                String string5 = file.getParent();
                String string6 = string5 == null ? string2 : string2.substring(string5.length() + 1);
                File file2 = new File(string3 + string6);
                if (!file2.getCanonicalPath().equals(file.getCanonicalPath())) {
                    this.configuration.standardmessage.notice((SourcePosition)null, "doclet.Copying_File_0_To_File_1", file.toString(), file2.toString());
                    Util.copyFile(file2, file);
                }
            }
        }
        catch (IOException iOException) {
            this.configuration.standardmessage.error((SourcePosition)null, "doclet.perform_copy_exception_encountered", iOException.toString());
            throw new DocletAbortException();
        }
    }
}

