/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javaws;

import com.sun.javaws.BrowserSupport;
import com.sun.javaws.ConfigProperties;
import com.sun.javaws.DownloadWindow;
import com.sun.javaws.ExtensionInstallHandler;
import com.sun.javaws.JAuthenticator;
import com.sun.javaws.JPDA;
import com.sun.javaws.JnlpxArgs;
import com.sun.javaws.LaunchDownload;
import com.sun.javaws.LaunchErrorDialog;
import com.sun.javaws.LaunchSelection;
import com.sun.javaws.LocalApplicationProperties;
import com.sun.javaws.LocalInstallHandler;
import com.sun.javaws.Main;
import com.sun.javaws.Resources;
import com.sun.javaws.SplashScreen;
import com.sun.javaws.cache.DiskCacheEntry;
import com.sun.javaws.cache.DownloadProtocol;
import com.sun.javaws.cache.InstallCache;
import com.sun.javaws.debug.Debug;
import com.sun.javaws.debug.Globals;
import com.sun.javaws.exceptions.FailedDownloadingResourceException;
import com.sun.javaws.exceptions.JNLPException;
import com.sun.javaws.exceptions.JreExecException;
import com.sun.javaws.exceptions.LaunchDescException;
import com.sun.javaws.exceptions.MissingFieldException;
import com.sun.javaws.exceptions.OfflineLaunchException;
import com.sun.javaws.jnl.AppletDesc;
import com.sun.javaws.jnl.JREDesc;
import com.sun.javaws.jnl.LaunchDesc;
import com.sun.javaws.jnl.LaunchDescFactory;
import com.sun.javaws.security.AppPolicy;
import com.sun.javaws.security.JavaWebStartSecurity;
import com.sun.javaws.security.KeyStoreManager;
import com.sun.javaws.ui.console.Console;
import com.sun.javaws.util.URLUtil;
import com.sun.javaws.util.VersionID;
import com.sun.javaws.util.VersionString;
import com.sun.jnlp.AppletContainer;
import com.sun.jnlp.AppletContainerCallback;
import com.sun.jnlp.BasicServiceImpl;
import com.sun.jnlp.ExtensionInstallerServiceImpl;
import com.sun.jnlp.JNLPClassLoader;
import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.Authenticator;
import java.net.URL;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Date;
import java.util.Properties;
import javax.net.ssl.SSLHandshakeException;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class Launcher
implements Runnable {
    private DownloadWindow _downloadWindow = null;
    private Console _console = null;
    private LaunchDesc _launchDesc;
    private String[] _args;
    private JAuthenticator _ja;
    private boolean _shownDownloadWindow = false;

    public void run() {
        LaunchDesc launchDesc = LaunchDownload.getLaunchDescFromCache(this._launchDesc);
        this.removeTempJnlpFile(launchDesc);
        if (Globals.TraceStartup) {
            Debug.println(launchDesc.toString());
        }
        if (launchDesc.getResources() != null) {
            Globals.getDebugOptionsFromProperties(launchDesc.getResources().getResourceProperties());
        }
        if (this._console == null) {
            this._console = new Console();
        }
        this._downloadWindow = new DownloadWindow();
        ConfigProperties configProperties = ConfigProperties.getInstance();
        if (configProperties.getJAuthenticator() != 4) {
            this._ja = JAuthenticator.getInstance(this._downloadWindow);
            Authenticator.setDefault(this._ja);
        }
        int n = 0;
        boolean bl = false;
        do {
            bl = n == 3;
            this._downloadWindow.setLaunchDesc(launchDesc, true);
            launchDesc = this.handleLaunchFile(launchDesc, this._args, !bl);
            ++n;
        } while (launchDesc != null && !bl);
    }

    private void removeTempJnlpFile(LaunchDesc launchDesc) {
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation());
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
        }
        if (diskCacheEntry == null) {
            return;
        }
        File file = diskCacheEntry.getFile();
        if (file != null && JnlpxArgs.shouldRemoveArgumentFile()) {
            new File(this._args[0]).delete();
            JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            this._args[0] = file.getPath();
        }
    }

    private void executeInstallers(ArrayList arrayList) {
        if (this._downloadWindow.getFrame() != null) {
            String string = Resources.getString("launch.launchInstaller");
            this._downloadWindow.showLaunchingApplication(string);
            new Thread(new Runnable(){

                public void run() {
                    try {
                        Thread.sleep(5000L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Launcher.this._downloadWindow.getFrame().setVisible(false);
                }
            }).start();
        }
        int n = 0;
        while (n < arrayList.size()) {
            File file = (File)arrayList.get(n);
            try {
                LaunchDesc launchDesc = LaunchDescFactory.buildDescriptor(file);
                LocalApplicationProperties localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(file.getPath(), launchDesc);
                if (Globals.TraceExtensions) {
                    Debug.println("Installing extension: " + file);
                }
                String[] stringArray = new String[]{file.getAbsolutePath()};
                ConfigProperties.JREInformation jREInformation = LaunchSelection.selectJRE(launchDesc);
                if (jREInformation == null) {
                    this._downloadWindow.getFrame().setVisible(true);
                    LaunchErrorDialog.show(null, new LaunchDescException(launchDesc, Resources.getString("launch.error.missingjreversion"), null));
                }
                boolean bl = JnlpxArgs.shouldRemoveArgumentFile();
                JnlpxArgs.setShouldRemoveArgumentFile("false");
                Properties properties = launchDesc.getResources().getResourceProperties();
                Process process = Launcher.execProgram(jREInformation, stringArray, -1L, -1L, properties);
                EatInput.eatInput(process.getErrorStream());
                EatInput.eatInput(process.getInputStream());
                process.waitFor();
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(bl));
                localApplicationProperties.refresh();
                if (localApplicationProperties.isRebootNeeded()) {
                    boolean bl2 = false;
                    ExtensionInstallHandler extensionInstallHandler = ExtensionInstallHandler.getInstance();
                    if (extensionInstallHandler != null && extensionInstallHandler.doPreRebootActions(this._downloadWindow.getFrame())) {
                        bl2 = true;
                    }
                    localApplicationProperties.setLocallyInstalled(true);
                    localApplicationProperties.setRebootNeeded(false);
                    localApplicationProperties.store();
                    if (bl2 && extensionInstallHandler.doReboot()) {
                        Main.systemExit(0);
                    }
                }
                if (!localApplicationProperties.isLocallyInstalled()) {
                    this._downloadWindow.getFrame().setVisible(true);
                    LaunchErrorDialog.show(null, new LaunchDescException(launchDesc, Resources.getString("Launch.error.installfailed"), null));
                }
            }
            catch (JNLPException jNLPException) {
                this._downloadWindow.getFrame().setVisible(true);
                LaunchErrorDialog.show(null, jNLPException);
            }
            catch (IOException iOException) {
                this._downloadWindow.getFrame().setVisible(true);
                LaunchErrorDialog.show(null, iOException);
            }
            catch (InterruptedException interruptedException) {
                this._downloadWindow.getFrame().setVisible(true);
                LaunchErrorDialog.show(null, interruptedException);
            }
            ++n;
        }
    }

    private void notifyLocalInstallHandler(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, boolean bl) {
        block8: {
            if (localApplicationProperties == null) {
                return;
            }
            localApplicationProperties.setLastAccessed(new Date());
            localApplicationProperties.incrementLaunchCount();
            LocalInstallHandler localInstallHandler = LocalInstallHandler.getInstance();
            if (localInstallHandler != null && localInstallHandler.isLocalInstallSupported()) {
                JFrame jFrame = null;
                if (this._downloadWindow != null) {
                    jFrame = this._downloadWindow.getFrame();
                }
                if (localApplicationProperties.isLocallyInstalled()) {
                    if (bl) {
                        localInstallHandler.uninstall(launchDesc, localApplicationProperties);
                        localInstallHandler.install(jFrame, launchDesc, localApplicationProperties);
                    }
                } else {
                    localInstallHandler.installIfNecessaryFromLaunch(jFrame, launchDesc, localApplicationProperties);
                }
            }
            try {
                localApplicationProperties.store();
            }
            catch (IOException iOException) {
                if (!Globals.TraceStartup) break block8;
                Debug.println("Couldn't save LAP: " + iOException);
            }
        }
    }

    private void handleJnlpFileException(LaunchDesc launchDesc, Exception exception) {
        DiskCacheEntry diskCacheEntry = null;
        try {
            diskCacheEntry = DownloadProtocol.getCachedLaunchedFile(launchDesc.getLocation());
            if (diskCacheEntry != null) {
                InstallCache.getDiskCache().removeEntry(diskCacheEntry);
            }
        }
        catch (JNLPException jNLPException) {
            Debug.ignoredException(jNLPException);
        }
        JFrame jFrame = this._downloadWindow == null ? null : this._downloadWindow.getFrame();
        LaunchErrorDialog.show(jFrame, exception);
    }

    public Launcher(LaunchDesc launchDesc, String[] stringArray) {
        this._launchDesc = launchDesc;
        this._args = stringArray;
        ThreadGroup threadGroup = Thread.currentThread().getThreadGroup();
        while (threadGroup.getParent() != null) {
            threadGroup = threadGroup.getParent();
        }
        ThreadGroup threadGroup2 = new ThreadGroup(threadGroup, "javawsApplicationThreadGroup");
        Thread thread = new Thread(threadGroup2, this, "javawsApplicationMain");
        thread.start();
    }

    private void executeApplet(LaunchDesc launchDesc, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException {
        AppletDesc appletDesc = launchDesc.getAppletDescriptor();
        int n = appletDesc.getWidth();
        int n2 = appletDesc.getHeight();
        Applet applet = null;
        applet = (Applet)clazz.newInstance();
        SplashScreen.hide();
        if (downloadWindow.getFrame() == null) {
            downloadWindow.buildIntroScreen();
            downloadWindow.showLaunchingApplication(launchDesc.getInformation().getTitle());
        }
        final JFrame jFrame = downloadWindow.getFrame();
        boolean bl = BrowserSupport.isWebBrowserSupported();
        AppletContainerCallback appletContainerCallback = new AppletContainerCallback(){

            public void relativeResize(Dimension dimension) {
                Dimension dimension2 = jFrame.getSize();
                dimension2.width += dimension.width;
                dimension2.height += dimension.height;
                jFrame.setSize(dimension2);
            }

            public void showDocument(URL uRL) {
                BrowserSupport.showDocument(uRL);
            }
        };
        URL uRL = BasicServiceImpl.getInstance().getCodeBase();
        URL uRL2 = appletDesc.getDocumentBase();
        if (uRL2 == null) {
            uRL2 = uRL;
        }
        final AppletContainer appletContainer = new AppletContainer(appletContainerCallback, applet, appletDesc.getName(), uRL2, uRL, n, n2, appletDesc.getParameters());
        jFrame.removeWindowListener(downloadWindow);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                appletContainer.stopApplet();
            }
        });
        downloadWindow.clearWindow();
        jFrame.setTitle(launchDesc.getInformation().getTitle());
        Container container = jFrame.getContentPane();
        container.setLayout(new BorderLayout());
        container.add("Center", appletContainer);
        jFrame.pack();
        Dimension dimension = appletContainer.getPreferredFrameSize(jFrame);
        jFrame.setSize(dimension);
        jFrame.getRootPane().revalidate();
        jFrame.getRootPane().repaint();
        if (!jFrame.isVisible()) {
            jFrame.show();
        }
        appletContainer.startApplet();
    }

    private void executeApplication(LaunchDesc launchDesc, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, NoSuchMethodException, InvocationTargetException {
        String[] stringArray = null;
        if (launchDesc.getLaunchType() == 4) {
            downloadWindow.reset();
            stringArray = new String[]{"install"};
        } else {
            downloadWindow.disposeWindow();
            SplashScreen.hide();
            stringArray = launchDesc.getApplicationDescriptor().getArguments();
        }
        downloadWindow = null;
        Object[] objectArray = new Object[]{stringArray};
        Class[] classArray = new Class[]{new String[0].getClass()};
        Method method = clazz.getMethod("main", classArray);
        if (!Modifier.isStatic(method.getModifiers())) {
            throw new NoSuchMethodException(Resources.getString("launch.error.nonstaticmainmethod"));
        }
        method.setAccessible(true);
        method.invoke(null, objectArray);
    }

    private void executeMainClass(LaunchDesc launchDesc, Class clazz, DownloadWindow downloadWindow) throws IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException {
        if (launchDesc.getLaunchType() == 2) {
            this.executeApplet(launchDesc, clazz, downloadWindow);
        } else {
            this.executeApplication(launchDesc, clazz, downloadWindow);
        }
    }

    private LaunchDesc handleLaunchFile(LaunchDesc launchDesc, String[] stringArray, boolean bl) {
        VersionID versionID;
        VersionString versionString = new VersionString(launchDesc.getSpecVersion());
        if (!versionString.contains(versionID = new VersionID("1.0"))) {
            JNLPException.setDefaultLaunchDesc(launchDesc);
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, Resources.getString("launch.error.badjnlversion", launchDesc.getSpecVersion()), null));
        }
        if (launchDesc.getResources() == null) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, Resources.getString("launch.error.noappresources", launchDesc.getSpecVersion()), null));
        }
        if (!launchDesc.isJRESpecified()) {
            this.handleJnlpFileException(launchDesc, new LaunchDescException(launchDesc, Resources.getString("launch.error.missingjreversion"), null));
        }
        if (launchDesc.isApplicationDescriptor()) {
            return this.handleApplicationDesc(launchDesc, stringArray, false, bl);
        }
        if (launchDesc.getLaunchType() == 4) {
            return this.handleApplicationDesc(launchDesc, stringArray, true, bl);
        }
        JNLPException.setDefaultLaunchDesc(launchDesc);
        this.handleJnlpFileException(launchDesc, new MissingFieldException(launchDesc.getSource(), "<application-desc>|<applet-desc>"));
        return null;
    }

    private LaunchDesc handleApplicationDesc(LaunchDesc launchDesc, String[] stringArray, boolean bl, boolean bl2) {
        boolean bl3;
        Object object;
        boolean bl4;
        JNLPException.setDefaultLaunchDesc(launchDesc);
        ConfigProperties configProperties = ConfigProperties.getInstance();
        JFrame jFrame = this._downloadWindow.getFrame();
        URL uRL = launchDesc.getCanonicalHome();
        if (uRL == null) {
            LaunchErrorDialog.show(jFrame, new LaunchDescException(launchDesc, Resources.getString("launch.error.nomainjar"), null));
        }
        LocalApplicationProperties localApplicationProperties = null;
        if (!bl) {
            localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(uRL, launchDesc);
        } else {
            localApplicationProperties = InstallCache.getCache().getLocalApplicationProperties(stringArray[0], launchDesc);
            uRL = localApplicationProperties.getLocation();
        }
        if (Globals.TraceStartup) {
            Debug.println("LaunchDesc location: " + uRL + ", version: " + localApplicationProperties.getVersionId());
        }
        boolean bl5 = Globals.isOffline();
        boolean bl6 = LaunchDownload.isInCache(launchDesc);
        ConfigProperties.JREInformation jREInformation = LaunchSelection.selectJRE(launchDesc);
        int n = configProperties.getRapidUpdateTimeout();
        boolean bl7 = bl4 = !bl6 || jREInformation == null || !bl5 && (configProperties.getForceUpdateCheck() || localApplicationProperties.forceUpdateCheck() || new RapidUpdateCheck().doUpdateCheck(launchDesc, localApplicationProperties, n)) || bl;
        if (Globals.TraceStartup) {
            Debug.println("Offline mode: " + bl5);
            Debug.println("IsInCache: " + bl6);
            Debug.println("forceUpdate: " + bl4);
            Debug.println("Installed JRE: " + jREInformation);
            Debug.println("IsInstaller: " + bl);
        }
        if (bl4 && bl5) {
            LaunchErrorDialog.show(jFrame, new OfflineLaunchException());
        }
        ArrayList arrayList = new ArrayList();
        if (bl4) {
            object = this.downloadResources(launchDesc, jREInformation == null, bl2, arrayList);
            if (object != null) {
                this.removeTempJnlpFile(launchDesc);
                return object;
            }
            if (localApplicationProperties.forceUpdateCheck()) {
                localApplicationProperties.setForceUpdateCheck(false);
                try {
                    localApplicationProperties.store();
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
            }
        }
        SplashScreen.generateCustomSplash(jFrame, launchDesc, bl4);
        if (!arrayList.isEmpty()) {
            if (bl) {
                // empty if block
            }
            this.executeInstallers(arrayList);
            jREInformation = null;
        }
        if (this._downloadWindow.getFrame() != null) {
            object = Resources.getString("launch.launchApplication");
            if (launchDesc.getLaunchType() == 4) {
                object = Resources.getString("launch.launchInstaller");
            }
            this._downloadWindow.showLaunchingApplication((String)object);
        }
        if (jREInformation == null) {
            configProperties.refresh();
            jREInformation = LaunchSelection.selectJRE(launchDesc);
            if (jREInformation == null) {
                LaunchErrorDialog.show(null, new LaunchDescException(launchDesc, Resources.getString("launch.error.missingjreversion"), null));
            }
        }
        object = launchDesc.getResources().getSelectedJRE();
        long l = ((JREDesc)object).getMinHeap();
        long l2 = ((JREDesc)object).getMaxHeap();
        boolean bl8 = JnlpxArgs.isCurrentRunningJREHeap(l, l2);
        Properties properties = launchDesc.getResources().getResourceProperties();
        boolean bl9 = JnlpxArgs.isSecurePropsMatch(properties);
        boolean bl10 = bl3 = JPDA.getDebuggeeType() == 1 || JPDA.getDebuggeeType() == 3;
        if (!(!bl3 && jREInformation.isCurrentRunningJRE() && arrayList.isEmpty() && bl8 && bl9)) {
            try {
                Launcher.execProgram(jREInformation, stringArray, l, l2, properties);
            }
            catch (IOException iOException) {
                LaunchErrorDialog.show(null, new JreExecException(jREInformation.getInstalledPath(), iOException));
            }
            if (JnlpxArgs.shouldRemoveArgumentFile()) {
                JnlpxArgs.setShouldRemoveArgumentFile(String.valueOf(false));
            }
            Main.systemExit(0);
        }
        JnlpxArgs.removeArgumentFile(stringArray);
        if (Globals.TraceStartup) {
            Debug.println("continuing launch in this VM");
        }
        this.continueLaunch(jFrame, localApplicationProperties, bl5, uRL, launchDesc, bl4);
        return null;
    }

    private LaunchDesc downloadResources(LaunchDesc launchDesc, boolean bl, boolean bl2, ArrayList arrayList) {
        if (!this._shownDownloadWindow) {
            this._shownDownloadWindow = true;
            this._downloadWindow.buildIntroScreen();
            this._downloadWindow.showLoadingProgressScreen();
            this._downloadWindow.getFrame().show();
            SplashScreen.hide();
        }
        try {
            LaunchDesc launchDesc2;
            if (bl2 && (launchDesc2 = LaunchDownload.getUpdatedLaunchDesc(launchDesc)) != null) {
                return launchDesc2;
            }
            if (bl) {
                LaunchDownload.downloadJRE(launchDesc, this._downloadWindow, arrayList);
            }
            LaunchDownload.downloadExtensions(launchDesc, this._downloadWindow, 0, arrayList);
            LaunchDownload.checkJNLPSecurity(launchDesc);
            LaunchDownload.downloadEagerorAll(launchDesc, false, this._downloadWindow, false);
        }
        catch (SecurityException securityException) {
            LaunchErrorDialog.show(this._downloadWindow.getFrame(), securityException);
        }
        catch (JNLPException jNLPException) {
            LaunchErrorDialog.show(this._downloadWindow.getFrame(), jNLPException);
        }
        catch (IOException iOException) {
            LaunchErrorDialog.show(this._downloadWindow.getFrame(), iOException);
        }
        return null;
    }

    private void continueLaunch(Frame frame, LocalApplicationProperties localApplicationProperties, boolean bl, URL uRL, LaunchDesc launchDesc, boolean bl2) {
        Object object;
        try {
            KeyStoreManager.initialize();
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        AppPolicy appPolicy = AppPolicy.createInstance(launchDesc.getCanonicalHome().getHost());
        try {
            LaunchDownload.checkSignedResources(launchDesc);
            LaunchDownload.checkSignedLaunchDesc(launchDesc);
        }
        catch (JNLPException jNLPException) {
            LaunchErrorDialog.show(frame, jNLPException);
        }
        catch (IOException iOException) {
            LaunchErrorDialog.show(frame, iOException);
        }
        final JNLPClassLoader jNLPClassLoader = JNLPClassLoader.createClassLoader(launchDesc, appPolicy);
        Thread.currentThread().setContextClassLoader(jNLPClassLoader);
        System.setSecurityManager(new JavaWebStartSecurity());
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    Thread.currentThread().setContextClassLoader(jNLPClassLoader);
                    try {
                        UIManager.setLookAndFeel(UIManager.getLookAndFeel());
                    }
                    catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
                        unsupportedLookAndFeelException.printStackTrace();
                        Debug.ignoredException(unsupportedLookAndFeelException);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            Debug.ignoredException(interruptedException);
        }
        catch (InvocationTargetException invocationTargetException) {
            Debug.ignoredException(invocationTargetException);
        }
        String string = null;
        Class<?> clazz = null;
        try {
            string = LaunchDownload.getMainClassName(launchDesc, true);
            if (Globals.TraceStartup) {
                Debug.println("Main-class: " + string);
            }
            clazz = jNLPClassLoader.loadClass(string);
            if (this.getClass().getPackage().equals(clazz.getPackage())) {
                throw new ClassNotFoundException(string);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            LaunchErrorDialog.show(frame, classNotFoundException);
        }
        catch (IOException iOException) {
            LaunchErrorDialog.show(frame, iOException);
        }
        catch (JNLPException jNLPException) {
            LaunchErrorDialog.show(frame, jNLPException);
        }
        URL uRL2 = launchDesc.getCodebase();
        if (uRL2 == null) {
            uRL2 = URLUtil.getBase(uRL);
        }
        if (this._console != null) {
            this._console.show(launchDesc.getInformation().getTitle());
        }
        try {
            BasicServiceImpl.initialize(uRL2, bl, BrowserSupport.isWebBrowserSupported());
            if (launchDesc.getLaunchType() == 4) {
                object = InstallCache.getCache().getNewExtensionInstallDirectory();
                ExtensionInstallerServiceImpl.initialize((String)object, localApplicationProperties, this._downloadWindow);
            }
        }
        catch (IOException iOException) {
            LaunchErrorDialog.show(frame, iOException);
        }
        try {
            if (launchDesc.getLaunchType() != 4 && launchDesc.getLocation() != null) {
                this.notifyLocalInstallHandler(launchDesc, localApplicationProperties, bl2);
            }
            object = this._downloadWindow;
            this._downloadWindow = null;
            if (Globals.TCKHarnessRun) {
                Debug.tckprintln("JNLP Launching");
            }
            this.executeMainClass(launchDesc, clazz, (DownloadWindow)object);
        }
        catch (SecurityException securityException) {
            LaunchErrorDialog.show(frame, securityException);
        }
        catch (IllegalAccessException illegalAccessException) {
            LaunchErrorDialog.show(frame, illegalAccessException);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            LaunchErrorDialog.show(frame, illegalArgumentException);
        }
        catch (InstantiationException instantiationException) {
            LaunchErrorDialog.show(frame, instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            LaunchErrorDialog.show(frame, invocationTargetException.getTargetException());
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LaunchErrorDialog.show(frame, noSuchMethodException);
        }
    }

    private static Process execProgram(ConfigProperties.JREInformation jREInformation, String[] stringArray, long l, long l2, Properties properties) throws IOException {
        String string = jREInformation.getInstalledPath();
        Debug.jawsAssert(string.length() != 0, "must exist");
        String[] stringArray2 = JnlpxArgs.getArgumentList(string, l, l2, properties);
        int n = 1 + stringArray2.length + stringArray.length;
        String[] stringArray3 = new String[n];
        int n2 = 0;
        stringArray3[n2++] = string;
        int n3 = 0;
        while (n3 < stringArray2.length) {
            stringArray3[n2++] = stringArray2[n3];
            ++n3;
        }
        int n4 = 0;
        while (n4 < stringArray.length) {
            stringArray3[n2++] = stringArray[n4];
            ++n4;
        }
        stringArray3 = JPDA.JpdaSetup(stringArray3, jREInformation);
        if (Globals.TraceStartup) {
            Debug.println("Launching new JRE version: " + jREInformation);
            int n5 = 0;
            while (n5 < stringArray3.length) {
                Debug.println("cmd " + n5 + " : " + stringArray3[n5]);
                ++n5;
            }
        }
        if (Globals.TCKHarnessRun) {
            Debug.tckprintln("JVM Starting");
        }
        return Runtime.getRuntime().exec(stringArray3);
    }

    private static class EatInput
    implements Runnable {
        private InputStream _is;

        public void run() {
            byte[] byArray = new byte[1024];
            try {
                while (true) {
                    int n = this._is.read(byArray);
                }
            }
            catch (IOException iOException) {
                return;
            }
        }

        EatInput(InputStream inputStream) {
            this._is = inputStream;
        }

        private static void eatInput(InputStream inputStream) {
            EatInput eatInput = new EatInput(inputStream);
            new Thread(eatInput).start();
        }
    }

    private class RapidUpdateCheck
    extends Thread {
        private LaunchDesc _ld = null;
        private LocalApplicationProperties _lap;
        private boolean _updateAvailable;
        private boolean _checkCompleted;
        private Object _signalObject = new Object();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            block9: {
                boolean bl = false;
                try {
                    bl = LaunchDownload.isUpdateAvailable(this._ld);
                }
                catch (FailedDownloadingResourceException failedDownloadingResourceException) {
                    Throwable throwable;
                    if (this._ld.isHttps() && (throwable = failedDownloadingResourceException.getWrappedException()) != null && throwable instanceof SSLHandshakeException) {
                        Main.systemExit(0);
                    }
                    Debug.ignoredException(failedDownloadingResourceException);
                }
                catch (JNLPException jNLPException) {
                    Debug.ignoredException(jNLPException);
                }
                Object object = this._signalObject;
                synchronized (object) {
                    this._updateAvailable = bl;
                    this._checkCompleted = true;
                    this._signalObject.notify();
                }
                if (!this._updateAvailable) break block9;
                this._lap.setForceUpdateCheck(true);
                try {
                    this._lap.store();
                }
                catch (IOException iOException) {
                    Debug.ignoredException(iOException);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean doUpdateCheck(LaunchDesc launchDesc, LocalApplicationProperties localApplicationProperties, int n) {
            this._ld = launchDesc;
            this._lap = localApplicationProperties;
            boolean bl = false;
            Object object = this._signalObject;
            synchronized (object) {
                this._updateAvailable = false;
                this._checkCompleted = false;
                this.start();
                do {
                    if (launchDesc.getInformation().supportsOfflineOperation()) {
                        try {
                            this._signalObject.wait(n);
                            bl = this._updateAvailable;
                        }
                        catch (InterruptedException interruptedException) {
                            bl = false;
                        }
                        continue;
                    }
                    try {
                        this._signalObject.wait(n);
                        bl = this._updateAvailable || !this._checkCompleted;
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                } while (this._ld.isHttps() && !this._checkCompleted || Launcher.this._ja != null && Launcher.this._ja.isChallanging());
            }
            return bl;
        }
    }
}

