# 
# Author:       James Brister <brister@vix.com> -- berkeley-unix --
# Start Date:   Sat, 24 Aug 1996 22:08:19 +0200
# Project:      INN 
# File:         innshellvars.pl
# RCSId:        $Id: innshellvars.pl.in,v 1.9 2002/09/16 17:38:03 rra Exp $
# Description:  Set up any and all variables that an INN perl script
#               might need.

package inn ;

eval `/usr/lib/news/bin/innconfval -p`;

$newshome = $pathnews;
$newslib = "/usr/lib/news/lib";
$spooldir = $pathspool;
$most_logs = $pathlog;

$errlog = "${most_logs}/errlog" ;
$log = "${most_logs}/news" ;

$spool = $patharticles;
$overviewdir = $pathoverview;
$archivedir = $patharchive;
$badnews = "$pathincoming/bad";
$spoolnews = $pathincoming;
$batch = $pathoutgoing;
$incoming = $pathincoming;

$locks = $pathrun;
$newsbin = $pathbin;
$innddir = $pathrun;
$newsetc = $pathetc;
$newslbin = "$pathnews/local";

$active = "${pathdb}/active" ;
$activetimes = "${pathdb}/active.times" ;
$ctlfile = "${newsetc}/control.ctl" ;
$ctlwatch = "${newsetc}/innwatch.ctl" ;
$history = "${pathdb}/history" ;
$newactive = "${pathdb}/active.tmp" ;
$newsfeeds = "${newsetc}/newsfeeds" ;
$newsgroups = "${pathdb}/newsgroups" ;
$oldactive = "${pathdb}/active.old" ;
$path_motd = "${newsetc}/motd.news" ;
$localgroups = "$newsetc/localgroups" ;
$expirectl = "${newsetc}/expire.ctl" ;

$controlprogs = $pathcontrol;
$inews = "${newsbin}/inews" ;
$innconfval = "${newsbin}/innconfval" ;
$innd = "${newsbin}/innd" ;
$inndstart = "${newsbin}/inndstart" ;
$innwatch = "${newsbin}/innwatch" ;
$rnews = "${newsbin}/rnews" ;
$perl_startup_innd = "$pathfilter/startup_innd.pl" ;
$perl_filter_innd = "$pathfilter/filter_innd.pl" ;
$perl_filter_nnrpd = "$pathfilter/filter_nnrpd.pl" ;
$python_filter_innd = "$pathfilter/filter_innd.py" ;
$path_python_inn_module ="$pathfilter/INN.py" ;
$path_tcl_startup = "$pathfilter/startup.tcl" ;
$path_tcl_filter = "$pathfilter/filter.tcl" ;

$daily = "${locks}/LOCK.news.daily" ;

$newscontrol = "${innddir}/control" ;
$nntpconnect = "${innddir}/nntpin" ;
$serverpid = "${innddir}/innd.pid" ;
$innwstatus = "${innddir}/innwatch.status" ;
$watchpid = "${innddir}/innwatch.pid" ;

$awk = "/usr/bin/awk" ;
$sed = "/usr/bin/sed" ;
$inndf = "${newsbin}/inndf" ;
$egrep = "/usr/bin/egrep" ;
$gpgv = "/usr/bin/gpgv" ;
$perl = "/usr/bin/perl" ;
$pgp = "" ;
$sort = "/usr/bin/sort" ;
$getftp = "/usr/bin/wget" ;
$compress = "/usr/bin/compress" ;
$gzip = "/usr/bin/gzip" ;
$uncompress = "/usr/bin/compress -d" ;
$log_compress = "/usr/bin/gzip" ;
$z = ".gz" ;

if ($ovmethod && $ovmethod eq "ovdb") {
    $ENV{'DB_HOME'} = $pathoverview;
}

($tempsock = "${innddir}/ctlinndXXXXXX") =~ s!.*/(.*)XXXXXX$!$1*! ;
($tempsockdir = "${innddir}/ctlinndXXXXXX") =~ s!/[^/]*$!! ;

$have_uustat = ("DO" eq "DO" ? 1 : 0) ;

$newsmaster = 'news' ;
$newsuser = 'news' ;
$newsgroup = 'news' ;

$ENV{'TMPDIR'} = $pathtmp;
$tmpdir = $pathtmp;
$spooltemp = $pathtmp;

$umask = 02 ;

$syslog_facility = lc("LOG_NEWS");
$syslog_facility =~ s/log_//;

$ENV{'PATH'} = "${newslbin}:${newsbin}:$ENV{'PATH'}:/bin:/usr/bin:/usr/ucb" ;

1 ;
