#include <stdlib.h>
#include <stdio.h>

#include "psk31.h"
#include "filter.h"
#include "coeff.h"

#define	K	5
#define	POLY1	0x17
#define	POLY2	0x19

static void psk31_txinit(struct trx *trx)
{
	struct psk31 *s = (struct psk31 *) trx->modem;

	s->phaseacc = 0;

	s->prevsymbol.re = 1.0;
	s->prevsymbol.im = 0.0;

	s->preamble = 32;

	s->shreg = 0;
}

static void psk31_rxinit(struct trx *trx)
{
	struct psk31 *s = (struct psk31 *) trx->modem;

	s->phaseacc = 0;

	s->prevsymbol.re = 1.0;
	s->prevsymbol.im = 0.0;

	s->quality.re = 0.0;
	s->quality.im = 0.0;

	s->shreg = 0;
	s->dcdshreg = 0;
	s->dcd = 0;

	s->bitclk = 0;
}

static void psk31_free(struct psk31 *s)
{
	if (s) {
		filter_free(s->fir1);
		filter_free(s->fir2);

		encoder_free(s->enc);
		viterbi_free(s->dec);

		free(s);
	}
}

static void psk31_destructor(struct trx *trx)
{
	struct psk31 *s = (struct psk31 *) trx->modem;

	psk31_free(s);

	trx->modem = NULL;
	trx->txinit = NULL;
	trx->rxinit = NULL;
	trx->txprocess = NULL;
	trx->rxprocess = NULL;
	trx->destructor = NULL;
}

void psk31_init(struct trx *trx)
{
	struct psk31 *s;
	int i;

	if ((s = calloc(1, sizeof(struct psk31))) == NULL)
		return;

	switch (trx->mode) {
	case MODE_BPSK31:
		s->qpsk = 0;
		break;
	case MODE_QPSK31:
		s->qpsk = 1;
		break;
	default:
		psk31_free(s);
		return;
	}

	s->fir1 = filter_init(FIRLEN, 16, fir1c, fir1c);
	s->fir2 = filter_init(FIRLEN, 1,  fir2c, fir2c);

	if (!s->fir1 || !s->fir2) {
		psk31_free(s);
		return;
	}

	if (s->qpsk) {
		s->enc = encoder_init(K, POLY1, POLY2);
		s->dec = viterbi_init(K, POLY1, POLY2);

		if (!s->enc || !s->dec) {
			psk31_free(s);
			return;
		}
	}

	/* raised cosine shape for the transmitter */
	for (i = 0; i < SymbolLen; i++)
		s->txshape[i] = cos(i * M_PI / SymbolLen) / 2.0 + 0.5;

        trx->modem = s;

	trx->txinit = psk31_txinit;
	trx->rxinit = psk31_rxinit;

	trx->txprocess = psk31_txprocess;
	trx->rxprocess = psk31_rxprocess;

	trx->destructor = psk31_destructor;

	trx->samplerate = SampleRate;
	trx->fragmentsize = 256;
	trx->bandwidth = (double) SampleRate / SymbolLen;
}
