/*
 * ypbind.h,v
 * Revision 2.4  1995/01/24  12:24:32  swen
 * Added RCS keywords.
 *
 */

#ifndef BINDINGDIR
#define BINDINGDIR "/var/yp/binding"
#endif
#define USE_BINDINGDIR 1
#ifndef _PATH_YPCONF
#define _PATH_YPCONF "/etc/yp.conf"
#endif
#define CHECK_INTERVAL 60 /* check binding every 60 seconds */
#define YPSET_NO	0
#define YPSET_LOCAL	1
#define YPSET_ALL	2

struct _dom_binding {
  struct              _dom_binding *dom_pnext;
  char                dom_domain[YPMAXDOMAIN + 1];
  struct sockaddr_in  dom_server_addr;
  unsigned short int  dom_server_port;
  int                 dom_socket;
  CLIENT             *dom_client;
  long int            dom_vers;
  time_t              dom_check_t;
  int                 dom_lockfd;
  int                 dom_alive;
};

struct ypservers 
{
  struct ypservers *next_server;
  char *server;
};

typedef char *domainname;

extern void *ypbindproc_null_2_svc(struct svc_req *);
extern struct ypbind_resp *ypbindproc_domain_2_svc(domainname, struct svc_req *);
extern void *ypbindproc_setdom_2_svc(struct ypbind_setdom, struct svc_req *);
extern struct ypservers *ypconf_read(const char *);

extern bool_t xdr_domainname(XDR *, char *);
