------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                         S Y S T E M . O S 2 L I B                        --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--             Copyright (c) 1993,1994 NYU, All Rights Reserved             --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2,  or (at  your  option)  any --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

--  This package (and children) provide interface definitions to the standard
--  OS/2 Library. They are merely a translation of the various <bse*.h> files.

--  It is intended that higher level interfaces (with better names, and
--  stronger typing!) be built on top of this one for Ada (i.e. clean)
--  programming.

--  We have chosen to keep names, types, etc.  as close as possible to the
--  C definition to provide easier reference to the documentation. The main
--  exception is when a formal and its type (in C) differed only by the case
--  of letters (like in HMUX hmux). In this case, we have prepended "F_" to
--  the formal (i.e. F_hmux : HMUX).

with Interfaces.C;         use Interfaces.C;
with Interfaces.C.Strings; use Interfaces.C.Strings;

package System.OS2Lib is
pragma Preelaborate (OS2Lib);

   -------------------
   -- General Types --
   -------------------

   type    APIRET   is new unsigned_long;
   type    APIRET16 is new unsigned_short;
   subtype APIRET32 is     APIRET;

   subtype PSZ   is chars_ptr;
   subtype PCHAR is chars_ptr;
   subtype PVOID is System.Address;

   type BOOL32 is new unsigned_long;
   False32 : constant BOOL32 := 0;
   True32  : constant BOOL32 := 1;

   type UCHAR  is new unsigned_char;
   type USHORT is new unsigned_short;
   type ULONG  is new unsigned_long;
   type PULONG is access all ULONG;

   ---------------------
   -- Time Manegement --
   ---------------------

   procedure DosSleep (How_long : int);
   pragma Import (C, DosSleep, External_Name => "DosSleep");

   type DATETIME is
      record
           hours      : UCHAR;
           minutes    : UCHAR;
           seconds    : UCHAR;
           hundredths : UCHAR;
           day        : UCHAR;
           month      : UCHAR;
           year       : USHORT;
           timezone   : short;
           weekday    : UCHAR;
      end record;

   type PDATETIME is access all DATETIME;

   function DosGetDateTime (pdt : PDATETIME) return APIRET;
   pragma Import (C, DosGetDateTime, External_Name => "DosGetDateTime");

   function DosSetDateTime (pdt : PDATETIME) return APIRET;
   pragma Import (C, DosSetDateTime, External_Name => "DosSetDateTime");

   ----------------------------
   -- Miscelleneous Features --
   ----------------------------

   --  Features which do not fit any child

   function DosBeep (Freq : ULONG; Dur : ULONG) return APIRET;
   pragma Import (C, DosBeep, External_Name => "DosBeep");

   procedure Must_Not_Fail (Return_Code : OS2Lib.APIRET);
   --  Many OS/2 functions return APIRET and are not supposed to fail. In C
   --  style, these would be called as procedures, disregarding the returned
   --  value. This procedure can be used to achieve the same effect with a
   --  call of the form: Must_Not_Fail (Some_OS2_Function (...));

end System.OS2Lib;
