------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 4                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.23 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Expand routines for chapter 4 constructs

with Types; use Types;

package Exp_Ch4 is

   procedure Expand_N_Allocator                   (N : Node_Id);
   procedure Expand_N_And_Then                    (N : Node_Id);
   procedure Expand_N_Concat_Multiple             (N : Node_Id);
   procedure Expand_N_Conditional_Expression      (N : Node_Id);
   procedure Expand_N_Expression_Actions          (N : Node_Id);
   procedure Expand_N_In                          (N : Node_Id);
   procedure Expand_N_Not_In                      (N : Node_Id);
   procedure Expand_N_Op_Abs                      (N : Node_Id);
   procedure Expand_N_Op_Add                      (N : Node_Id);
   procedure Expand_N_Op_And                      (N : Node_Id);
   procedure Expand_N_Op_Concat                   (N : Node_Id);
   procedure Expand_N_Op_Divide                   (N : Node_Id);
   procedure Expand_N_Op_Expon                    (N : Node_Id);
   procedure Expand_N_Op_Eq                       (N : Node_Id);
   procedure Expand_N_Op_Ge                       (N : Node_Id);
   procedure Expand_N_Op_Gt                       (N : Node_Id);
   procedure Expand_N_Op_Le                       (N : Node_Id);
   procedure Expand_N_Op_Lt                       (N : Node_Id);
   procedure Expand_N_Op_Minus                    (N : Node_Id);
   procedure Expand_N_Op_Mod                      (N : Node_Id);
   procedure Expand_N_Op_Multiply                 (N : Node_Id);
   procedure Expand_N_Op_Ne                       (N : Node_Id);
   procedure Expand_N_Op_Not                      (N : Node_Id);
   procedure Expand_N_Op_Or                       (N : Node_Id);
   procedure Expand_N_Op_Rem                      (N : Node_Id);
   procedure Expand_N_Op_Subtract                 (N : Node_Id);
   procedure Expand_N_Op_Xor                      (N : Node_Id);
   procedure Expand_N_Or_Else                     (N : Node_Id);
   procedure Expand_N_Slice                       (N : Node_Id);
   procedure Expand_N_Selected_Component          (N : Node_Id);
   procedure Expand_N_Type_Conversion             (N : Node_Id);

   function Build_Length_Check
     (Expr : Node_Id;
      Typ  : Entity_Id)
      return List_Id;
   --  Expr is an expression of array type, and Typ is a constrained array
   --  type. This function builds a sequence of declarations and statements
   --  which can be executed to perform a length check on the expression.
   --  If no length check is required, then No_List is returned. Note that
   --  Expr may be modified to avoid improper multiple evaluation of the
   --  prefix in the case of an explicit deference. The caller must analyze
   --  the list of actions, and also reanalyze and reresolve the expression
   --  in case it gets modified by multi-use processing.

   function Expand_Record_Equality
     (Loc  : Source_Ptr;
      Typ  : Entity_Id;
      Lhs  : Node_Id;
      Rhs  : Node_Id)
      return Node_Id;
   --  Expand a record equality into an expression that compares the fields
   --  individually to yield the required Boolean result. Loc is the location
   --  for the generated nodes. Typ is the type of the record, and Lhs, Rhs
   --  are the record expressions to be compared. Note that the case of
   --  variant records is not implemented yet ???.

end Exp_Ch4;
