#include <stdio.h>
#include "man.h"
#include "gripes.h"
#include "version.h"

extern void gripe (), fatal (), read_config_file ();
extern char *strdup (), *getenv(), *strchr(), *getval();
extern char *pager, *roff_directive, *progname;
extern char *colon_sep_section_list;
extern int debug, apropos, whatis, nocats, findall;
extern int print_where, one_per_line, do_troff, do_compress;

int alt_systems = 1;
int alt_system;
char *alt_system_name;
char *opt_manpath;

void
usage (void) {
  gripe (VERSION, progname, version);
  gripe (USAGE1, progname);

  if (alt_systems)
    gripe (USAGE2);

  gripe (USAGE3);
  gripe (USAGE4);
  gripe (USAGE5);    /* maybe only if troff found? */
  gripe (USAGE6);

  if (alt_systems)
    gripe (USAGE7);

  gripe (USAGE8);
  exit(1);
}

static char short_opts[] = "C:M:P:S:acdDfhkm:p:twW?";

#ifndef NOGETOPT
#include <getopt.h>

static const struct option long_opts[] = {
    { "path",       no_argument,            NULL, 'w' },
    { NULL, 0, NULL, 0 }
};
#endif

/*
 * Get options from the command line and user environment.
 * Also reads the configuration file.
 */

void
man_getopt (argc, argv)
     register int argc;
     register char **argv;
{
  register int c;
  char *config_file = NULL;
  char *manp = NULL;
  extern char *optarg;
  extern int getopt_long ();

#ifndef NOGETOPT
  while ((c = getopt_long (argc, argv, short_opts, long_opts, NULL)) != -1) {
#else
  while ((c = getopt (argc, argv, short_opts)) != -1) {
#endif
      switch (c) {
	case 'C':
	  config_file = strdup (optarg);
	  break;
	case 'M':
	  manp = strdup (optarg);
	  break;
	case 'P':
	  pager = strdup (optarg);
	  break;
	case 'S':
	  colon_sep_section_list = strdup (optarg); 
	  break;
	case 'a':
	  findall++;
	  break;
	case 'c':
	  nocats++;
	  break;
	case 'D':
	  debug++;
	case 'd':
	  debug++;
	  break;
	case 'f':
	  if (do_troff)
	    fatal (INCOMPAT, "-f", "-t");
	  if (apropos)
	    fatal (INCOMPAT, "-f", "-k");
	  if (print_where)
	    fatal (INCOMPAT, "-f", "-w");
	  whatis++;
	  break;
	case 'k':
	  if (do_troff)
	    fatal (INCOMPAT, "-k", "-t");
	  if (whatis)
	    fatal (INCOMPAT, "-k", "-f");
	  if (print_where)
	    fatal (INCOMPAT, "-k", "-w");
	  apropos++;
	  break;
	case 'm':
	  alt_system++;
	  alt_system_name = strdup (optarg);
	  break;
	/* or:  gripe (NO_ALTERNATE); exit(1); */
	case 'p':
	  roff_directive = strdup (optarg);
	  break;
	case 't':
	  if (apropos)
	    fatal (INCOMPAT, "-t", "-k");
	  if (whatis)
	    fatal (INCOMPAT, "-t", "-f");
	  if (print_where)
	    fatal (INCOMPAT, "-t", "-w");
	  do_troff++;
	  break;
	case 'W':
	  one_per_line++;
	  /* fall through */
	case 'w':
	  if (apropos)
	    fatal (INCOMPAT, "-w", "-k");
	  if (whatis)
	    fatal (INCOMPAT, "-w", "-f");
	  if (do_troff)
	    fatal (INCOMPAT, "-w", "-t");
	  print_where++;
	  break;
	case 'h':
	case '?':
	default:
	  usage();
	  break;
      }
  }

  read_config_file (config_file);

  if (pager == NULL || *pager == '\0')
    if ((pager = getenv ("PAGER")) == NULL)
      pager = getval ("PAGER");

  if (debug)
    gripe (PAGER_IS, pager);

  if (do_compress && !*getval("COMPRESS")) {
      if (debug)
	gripe (NO_COMPRESS);
      do_compress = 0;
  }

  if (do_troff && !*getval ("TROFF")) {
      extern char *configuration_file;
      gripe (NO_TROFF, configuration_file);
      exit (1);
  }

  opt_manpath = manp;		/* do not yet expand manpath -
				   maybe it is not needed */

  if (alt_system_name == NULL || *alt_system_name == '\0')
    if ((alt_system_name = getenv ("SYSTEM")) != NULL)
      alt_system_name = strdup (alt_system_name);

}
