------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--               A D A . T E X T _ I O . D E C I M A L _ I O                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994, 1995 NYU, All Rights Reserved       --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO.Decimal_Aux;

package body Ada.Text_IO.Decimal_IO is

   package Aux renames Ada.Text_IO.Decimal_Aux;

   Scale : constant Integer := Num'Scale;

   ---------
   -- Get --
   ---------

   procedure Get
     (File  : in File_Type;
      Item  : out Num;
      Width : in Field := 0)
   is
   begin
      if Num'Size > Integer'Size then
         Item := Num (Aux.Get_LLD (File, Width, Scale));
         --  Item := Num'Fixed_Value (Aux.Get_LLD (File, Width, Scale));
         --  above is what we should write, but gets assert error ???

      else
         Item := Num (Aux.Get_Dec (File, Width, Scale));
         --  Item := Num'Fixed_Value (Aux.Get_Dec (File, Width, Scale));
         --  above is what we should write, but gets assert error ???
      end if;

   exception
      when Constraint_Error => raise Data_Error;
   end Get;

   procedure Get
     (Item  : out Num;
      Width : in Field := 0)
   is
   begin
      Get (Current_In, Item, Width);
   end Get;

   procedure Get
     (From : in String;
      Item : out Num;
      Last : out Positive)
   is
   begin
      if Num'Size > Integer'Size then
         --  Item := Num'Fixed_Value
         --  should write above, but gets assert error ???
         Item := Num
                   (Aux.Gets_LLD (From, Last'Unrestricted_Access, Scale));
      else
         --  Item := Num'Fixed_Value
         --  should write above, but gets assert error ???
         Item := Num
                   (Aux.Gets_Dec (From, Last'Unrestricted_Access, Scale));
      end if;

   exception
      when Constraint_Error => raise Data_Error;
   end Get;

   ---------
   -- Put --
   ---------

   procedure Put
     (File : in File_Type;
      Item : in Num;
      Fore : in Field := Default_Fore;
      Aft  : in Field := Default_Aft;
      Exp  : in Field := Default_Exp)
   is
   begin
      if Num'Size > Integer'Size then
         Aux.Put_LLD
--           (File, Long_Long_Integer'Integer_Value (Item),
--  ???
           (File, Long_Long_Integer (Item),
            Fore, Aft, Exp, Scale);
      else
         Aux.Put_Dec
--           (File, Integer'Integer_Value (Item), Fore, Aft, Exp, Scale);
--  ???
           (File, Integer (Item), Fore, Aft, Exp, Scale);

      end if;
   end Put;

   procedure Put
     (Item : in Num;
      Fore : in Field := Default_Fore;
      Aft  : in Field := Default_Aft;
      Exp  : in Field := Default_Exp)
   is
   begin
      Put (Current_Out, Item, Aft, Exp);
   end Put;

   procedure Put
     (To   : out String;
      Item : in Num;
      Aft  : in Field := Default_Aft;
      Exp  : in Field := Default_Exp)
   is
   begin
      if Num'Size > Integer'Size then
--       Aux.Puts_LLD
--         (To, Long_Long_Integer'Integer_Value (Item), Aft, Exp, Scale);
--  ???
         Aux.Puts_LLD
           (To, Long_Long_Integer (Item), Aft, Exp, Scale);
      else
--       Aux.Puts_Dec (To, Integer'Integer_Value (Item), Aft, Exp, Scale);
--  ???
         Aux.Puts_Dec (To, Integer (Item), Aft, Exp, Scale);
      end if;
   end Put;

end Ada.Text_IO.Decimal_IO;
