#ifndef __IMAGE_H__
#define __IMAGE_H__

/* +-------------------------------------------------------------------+ */
/* | Copyright (C) 1993, David Koblas (koblas@netcom.com)              | */
/* |                                                                   | */
/* | Permission to use, copy, modify, and to distribute this software  | */
/* | and its documentation for any purpose is hereby granted without   | */
/* | fee, provided that the above copyright notice appear in all       | */
/* | copies and that both that copyright notice and this permission    | */
/* | notice appear in supporting documentation.  There is no           | */
/* | representations about the suitability of this software for        | */
/* | any purpose.  this software is provided "as is" without express   | */
/* | or implied warranty.                                              | */
/* |                                                                   | */
/* +-------------------------------------------------------------------+ */

typedef struct {
	int	refCount;	/* reference count */

	/*
	**  Special notes:
	**    if the image isBW then there will be a two entry
	**       colormap BLACK == 0, WHITE == 1
	**    if the image isGrey, then the colormap is 256 entries
	**       BLACK == 0 .. WHITE == 255
	*/
	int	isGrey, isBW;	/* simple indicator flags  GreyScale, Black & White */
	/*
	**   number of bytes per pixel (3 for RGB, 2 for 0..256+ cmap, 1 for 0..256 cmap)
	*/
	int	scale;
	/*
	**  Colormap entries
	**   rgb rgb rgb [1..size]
	*/
	int		cmapPacked;	/* Boolean, is the colormap packed 
					   down to just the used colors */
	int		cmapSize;	/* number of colors in colormap == 0 if no colormap */
	unsigned char	*cmapData;
	/*
	**  Image data
	**   either rgb rgb rgb
	**   or     idx idx idx
	**
	**   if image has colormap, and the size > 256, then
	**     data is pointers to unsigned shorts.
	*/
	int		width, height;	/* width, height of image */
	unsigned char	*data;		
	unsigned char	*maskData;

	/*
	**  These values are here because the XPM calls are TOO dependant
	**   on X Windows.  They are not, and should not, be used by anything
	**   else.
	*/
	unsigned long	sourcePixmap;
	unsigned long	sourceColormap;
	unsigned long	sourceMask;
} Image;

#define ImagePixel(image, x, y)						\
	(((image)->cmapSize == 0)					\
	  ? &((image)->data[(y * (image)->width + x) * 3])		\
	  : (((image)->cmapSize > 256)					\
	     ? &((image)->cmapData[((unsigned short *)(image)->data)	\
				[y * (image)->width + x] * 3])		\
	     : &((image)->cmapData[(image)->data[y * (image)->width + x] * 3])))

#define ImageSetCmap(image, index, r, g, b) do {		\
			image->cmapData[(index) * 3 + 0] = r;	\
			image->cmapData[(index) * 3 + 1] = g;	\
			image->cmapData[(index) * 3 + 2] = b;	\
		} while (0)

Image	*ImageNew(int, int);
Image	*ImageNewGrey(int, int);
Image	*ImageNewBW(int, int);
Image	*ImageNewCmap(int, int, int);
Image	*ImageCompress(Image *, int);
void	ImageDelete(Image *);
void	ImakeMakeMask(Image *);
#ifdef _XtIntrinsic_h
Image	*PixmapToImage(Widget, Pixmap, Colormap);
Boolean	ImageToPixmap(Image *, Widget, Pixmap*, Colormap*);
Boolean	ImageToPixmapCmap(Image *, Widget, Pixmap*, Colormap);
Pixmap  ImageMaskToPixmap(Widget, Image *);
void 	PixmapToImageMask(Widget, Image *, Pixmap);
#endif

#endif /* __IMAGE_H__ */
