'\" t
.TH X3270 1 "11 August 1993"
.SH NAME
x3270 \-
.SM IBM
host access tool
.SH SYNOPSIS
.B x3270
[
.I options
] [ [
.B a:
]
.I hostname
]
.SH DESCRIPTION
.B x3270
opens a telnet connection to an
.SM IBM
host in an X window.
Since the window created by
.B x3270
can use its own font for displaying characters, is a fairly accurate
representation of an
.SM IBM
3278.
It is similar to
.IR tn3270 (1)
except that it is X-based, not curses-based.
.LP
Prepending an
.B a:
onto
.I hostname
puts
.B x3270
in initial
.SM ANSI
emulation mode, which causes
.B x3270
to emulate an
.SM ANSI
X3.64 terminal.
See
.SM "ANSI MODE"
below for further information.
.SH OPTIONS
.B x3270 
is a toolkit based program, so it understands standard options and resources.
It also understands the following options:
.TP
.BI \-activeicon
Specifies that the icon should be a miniature version of the screen image.
See
.SM ICONS
below.
.TP
.BI \-efont " name"
Specifies a font for the emulator window.
See
.SM FONTS
below.
.TP
.BI \-keymap " name"
Specifies a keymap name, or list of keymap names.
See
.SM KEYMAPS
below.
.TP
.BI \-charset " name"
Specifies a national character set.
See
.SM CHARACTER SETS
below.
.TP
.B \-model
The type of 3278 to be emulated.
The sizes of various emulated models are:
.PP
.RS
.TS
center;
c c c l .
Model	Columns	Rows
_
2	80	24
3	80	30
4	80	43	default
5	132	27
.TE
.RE
.TP
.B \-mono
Forces monochrome emulation even on a color display.
.TP
.BI \-tn " name"
Specifies the terminal name to be transmitted over the telnet connection.
The default name is
.BI IBM\-3278\- n
where
.I n
is the model number.
The name can also be specified with the "*termName" resource.
.SH FONTS
By default,
.B x3270
ignores the "*font" resource.
Instead, it uses a custom 14-point font called
.BR 3270 ,
which is a close
approximation of a real 3278 display and allows
.B x3270
to display a complete
.SM EBCDIC
character set and special status-line symbols.
A more compact font,
.BR 3270-12 ,
is also supported.
.LP
The font may be specified with the
.B \-efont
option or the "*emulatorFont" resource.
.LP
.B x3270
can also use any constant-spaced X font, but unless the font includes the
full
.SM ISO
8859-1 (Latin 1) character set,
.B x3270
may not properly display several
.SM EBCDIC
graphics that do not have
.SM ASCII
equivalents.
.IP
.IR Note :
.B x3270
requires that fonts have a
.SM SPACING
property with the value
.SM C.
Many otherwise valid fonts are not properly configured and appear unusable.
You may override the check by placing a `!' in front of the font name.
.LP
For speed,
.B x3270
also uses a second font for bold (high-intensity) characters.
It finds this font by appending
.B bold
to the name of its emulator font; if such a font cannot be found, it uses the
slower method of overstriking each bold character.
The bold font may be specified explicitly with the
.B \-bfont
option or the "*boldFont" resource.
.SH "CHARACTER SETS"
The
.B \-charset
option or the "*charset" resource controls the
.SM EBCDIC
national character set used by
.B x3270.
By default, the U.S. character set (code 01) is used.
Available sets include:
.PP
.TS
center;
l c
lfB c.
Charset Name	Q121 Code
_
us	01
german	03
finnish	09
uk	22
norwegian	23
french	30
.TE
.PP
The charset name
.B oldibm
is also supported to communicate with older
.SM IBM
hosts which use
.SM EBCDIC
codes 0xAD and 0xBD for the `[' and `]' characters, repsectively.
.PP
You can also specify national-language translations for your keyboard; see
.SM KEYMAPS
below.
.SH KEYPAD
A keypad may optionally be displayed, with a mouse-clickable button for each
3270 function key (these functions are also available from the keyboard).
The keypad can be turned on and off by clicking on the ``keypad'' button in the
upper-right-hand corner of the window.
The "*keypad" resource controls where it is displayed.
Options are:
.PP
.TS
center;
l l.
right	in a separate window, to the right of the screen
bottom	in a separate window, below the screen
integral	in the same window as the screen, below it
.TE
.PP
The default is
.B right.
.PP
If the "*keypadOn" resource is set to
.BR true ,
the keypad will be displayed at startup.
.SH "HOSTS DATABASE"
.B x3270
uses the
.I ibm_hosts
database to construct a pull-down menu of hosts to connect to.
It supports the
.B loginstring
function, which allows you to specify a macro to be sent to the host when the
connection is first made.
See
.IR ibm_hosts (5)
for details.
.LP
You may specify a different
.I ibm_hosts
database with the "*hostsFile" resource.
.SH COLOR
.B x3270 
does not understand
.SM IBM
3270 color protocols.
It merely draws text in one of three colors depending on the field attributes.
Those colors may be customized using the following resources (shown with their
default values):
.nf
	x3270.normalColor:	green
	x3270.boldColor:	cyan
	x3270.inputColor:	orange
	x3270.colorBackground:	black
	x3270.selectBackground:	dim gray
.fi
.PP
It is possible to get monochrome colors and behavior using the
.B \-mono
switch.
.SH "ANSI MODE"
Some hosts use an
.SM ASCII
front-end to do initial login negotiation, then later switch to 3270 mode.
Prepending an
.B a:
onto the
.I hostname
causes
.B x3270
to emulate an
.SM ANSI
X.64 terminal until the host places it in 3270 mode (telnet
.SM BINARY
and
.SM "SEND EOR"
modes).
The emulation is far from complete, however, and not intended to make
.B x3270
a replacement for
.IR xterm (1).
.PP
If the host later negotiates to stop functioning in 3270 mode,
.B x3270
will disconnect.
.PP
When emulating an
.SM ANSI
terminal,
.B x3270
supports both character-at-a-time mode and line mode operation.
You may select the mode with a menu option.
When in line mode, the special characters and operational characteristics are
defined by resources:
.PP
.TS
center;
l c c.
Mode/Character	Resource	Default
_
Translate CR to NL	*icrnl	true
Translate NL to CR	*inlcr	false
Erase previous character	*erase	^?
Erase entire line	*kill	^U
Erase previous word	*werase	^W
Redisplay line	*rprnt	^R
Ignore special meaning of next character	*lnext	^V
Interrupt	*intr	^C
Quit	*quit	^\\\\
End of file	*eof	^D
.TE
.SH MENUS
.B x3270
has a menu bar with three pull-down menus (Quit, Options, and
Connect) and a button to turn the keypad on and off.
The pull-down menus are also available as pop-up menus by using the
.B Ctrl
key and the left, middle and right mouse buttons, respectively.
.PP
The menu bar can be turned off by setting the "*menuBar" resource to
.B false.
.SH ICONS
If the
.B \-activeicon
option is given (or the "*activeIcon" resource is set to
.BR true ),
.B x3270
will attempt to make its icon a miniature version of the current screen image.
This function is highly dependent on your window manager:
.TP
.B mwm
The size of the icon is limited by the "Mwm.iconImageMaximum" resource, which
defaults to
.B 50x50.
The image will be clipped at the bottom and right.
The icon cannot accept keyboard input.
.TP
.B olwm
The full screen image of all 3270 models can be displayed on the icon.
However, the icon cannot be resized, so if the model is later changed with an
.B x3270
menu option, the icon image will be corrupted.
The icon cannot accept keyboard input.
.TP
.BR twm " and " tvtwm
The full screen image of all 3270 models can be displayed on the icon, and the
icon can be resized.
The icon can accept keyboard input.
.IP
However,
.B twm
does not put labels on application-supplied icon windows.
You can have
.B x3270
add its own label to the icon by setting the "*labelIcon" resource to
.B true.
The default font for icon labels is
.BR 8x13 ;
you may change it with the "*iconLabelFont" resource.
.SH KEYMAPS
.PP
The type of keyboard may be specified with the
.B \-keymap
switch or using either the 
.SM KEYMAP
or
.SM KEYBD
environment variables.
The types of supported keyboards include
.BR hp\-k1 ,
.BR ncd ,
.BR sun\-k4 ,
and
.BR sun\-k3 \.
.PP
The keymap may also be specified as a comma-separated list of keymap names.
Later definitions override earlier ones.
The primary use of such lists is to specify both a primary keyboard type
(largely for function key definitions) and a set of modifiers.
Several national-language modifiers are provided for emulating common
non-English keyboards, including
.B finnish7
and
.B norwegian7.
In addition, the modifier
.B ow
is defined to swap the middle and right mouse button definitions,
bringing them closer to OpenWindows
.B shelltool
definitions,
and the modifier
.B alt
is defined to replace all of the "Meta" key definitions with "Alt" definitions,
for keyboards which do not have a "Meta" key.
.PP
The X Toolkit translation mechanism is used to provide keyboard emulation.
It maps 
.B events
into 
.B actions.
The best documentation can be found with X11R5 X toolkit documents, but the
following should suffice for simple customization.
.PP
An Xt event consists of (at least) four fields.  The first is called a
.B modifier.
It may be any combination of meta, shift and ctrl.  If it is prefaced by !,
it means those modifiers only.  The second field is the specific event,
in 
.B x3270
usually just <Key>.  The third field is the detail field, which gives the
actual key.  The name of the key may be determined using the R5
.I xev
program.  The last field is the action, which is the internal emulator
function.  A complete list of actions may be found later in the manual.
.PP
There are three levels of translation tables in
.B x3270.
The first is a default, compiled in table. It defines alphabetic, numeric,
function keys, and such basic functions as Enter and Delete.  It allows a
minimal useful functionality.
.PP
The second level is a keyboard specific table, which is found in the
application default file, which defines actions for such things as keypad
keys, and keys unique to certain keyboards.
.PP
The third level is a user customizable table which may be used to augment or
override key definitions.  This will typically be found in the users 
.B .Xdefaults
file. The naming for a sun4 keyboard would be:
.RS
x3270.keymap.default:
.br
x3270.keymap.sun4:
.br
x3270.keymap.sun4.user:
.RE
.PP
The basic default translation table is:
.RS
.TS
l l .
<Key>Return:	Enter()
<Key>Linefeed:	Newline()
!Shift<Key>Tab:	BackTab()
<Key>Tab:	Tab()
<Key>Home:  	Home()
<Key>Left:	Left()
!Meta<Key>Left:	Left2()
<Key>Right: 	Right()
!Meta<Key>Right:	Right2()
<Key>Up:	Up()
<Key>Down:	Down()
<Key>Delete: 	Delete()
<Key>BackSpace: 	BackSpace()
<Btn1Down>:	select-start()
<Btn1Motion>:	select-extend()
<Btn2Down>:	ignore()
<Btn2Motion>:	ignore()
<Btn2Up>:	insert-selection(PRIMARY,CUT_BUFFER0)
<Btn3Down>:	start-extend()
<Btn3Motion>:	select-extend()
<BtnUp>:	select-end(PRIMARY,CUT_BUFFER0)
!Meta<Key>F1:	PF13()
!Meta<Key>F2:	PF14()
!Meta<Key>F3:	PF15()
!Meta<Key>F4:	PF16()
!Meta<Key>F5:	PF17()
!Meta<Key>F6:	PF18()
!Meta<Key>F7:	PF19()
!Meta<Key>F8:	PF20()
!Meta<Key>F9:	PF21()
!Meta<Key>F10:	PF22()
!Meta<Key>F11:	PF23()
!Meta<Key>F12:	PF24()
<Key>F1:	PF1()
<Key>F2:	PF2()
<Key>F3:	PF3()
<Key>F4:	PF4()
<Key>F5:	PF5()
<Key>F6:	PF6()
<Key>F7:	PF7()
<Key>F8:	PF8()
<Key>F9:	PF9()
<Key>F10:	PF10()
<Key>F11:	PF11()
<Key>F12:	PF12()
Meta<Key>1:	PA1()
Meta<Key>2:	PA2()
Meta<Key>3:	PA3()
Meta<Key>a:	Attn()
Meta<Key>c:	Clear()
Meta<Key>d:	Delete()
Meta<Key>h:	Home()
Meta<Key>i:	Insert()
Meta<Key>l:	Redraw()
Meta<Key>q:	Quit()
Meta<Key>r:	Reset()
:<Key>:	Default()
.TE
.RE
.PP
Meta is the diamond shaped key on a sun4, Alt on an
.SM NCD,
Extend Char on an
.SM HP.
The following xmodmap command must be used on the
.SM NCD
to allow use the the Alt
key:
.PP
.RS
xmodmap -e "keysym Alt_L = Meta_L"
.RE
.PP
The left mouse button may be used to move the 3278 cursor or to make a
selection.
Clicking once unselects the current selection, or if there is no selection,
moves the 3278 cursor.
Clicking twice selects the word under the mouse cursor.
Clicking three times selects the line under the mouse cursor.
Clicking and dragging selects a rectangular area of the display.
.PP
The middle mouse button may be used to paste a selection.
.PP
The right mouse button may also be used for selections, selecting the
rectangular area between the current position and where the left button was
last pressed.
.PP
On color displays, the "*colorBackground" resource is used to distinguish the
selected text from the rest of the screen.
On monochrome displays, selected text is in reverse video.
(It can be distinguished from a block cursor because the block cursor covers
slightly less than an entire character position on the screen.)
.PP
This is the complete list of actions:
.PP
.RS
.TS
l l
.
Attn	attention key
AltCursor	switch between block and underscore cursor
BackSpace	move cursor left (or send ASCII BS)
BackTab	tab to start of previous input field
Clear	clear screen
CursorSelect	Cursor Select AID
Default	enter key literally
Delete	delete character under cursor (or send ASCII DEL)
Down	move cursor down
Dup	duplicate field
Enter	Enter AID (or send ASCII CR)
EraseEOF	erase to end of current field
EraseInput	erase all input fields
FieldMark	mark field
Home	move cursor to first input field
Insert	set insert mode
Key(\fIkeysym\fP)	insert key \fIkeysym\fP
Left	move cursor left
Left2	move cursor left 2 positions
MonoCase	toggle uppercase-only mode
Newline	move cursor to first field on next line (or send ASCII LF)
PA1-PA3	Program Attention AID
PF1-PF24	Program Function AID
Quit	exit \fBx3270\fP
Redraw	redraw window
Reset	reset locked keyboard
Right	move cursor right
Right2	move cursor right 2 positions
SetFont(\fIfont\fP)	change emulator font
String(\fIstring\fP)	insert string (macro facility)
SysReq	System Request AID
Tab	move cursor to next input field
Up	move cursor up
_
(the following are similar to xterm)
_
ignore	do nothing
insert-selection	paste selection
select-extend	move the end of a selection
select-start	mark the beginning of a selection
start-extend	begin marking the end of a selection
.TE
.RE
.SH MACROS
A simple macro facility is provided via the String action.
The arguments to String() are one or more double-quoted strings which are
inserted directly as if typed.
Hex constants may be entered in the form 0xff, and the C backslash conventions
are honored as follows:
.RS
.TS
l l.
\eb	Left
\ef	Clear
\en	Enter
\er	Newline
\et	Tab
.TE
.RE
.PP
An example action would be:
.RS
Meta<Key>p: String("probs clearrdr\en")
.RE
.PP
.B Note:
The strings are in
.SM ASCII
and converted to
.SM EBCDIC,
so beware of inserting
control codes.
.SH BUGS
Cursor highlighting will not work with if you use the
.B NoTitleFocus
option in your .twmrc file.
.SH FILES
.nf
/usr/lib/X11/app-defaults/X3270
/usr/local/pub/ibm_hosts
.SH "SEE ALSO"
telnet(1), tn3270(1), ibm_hosts(5)
.br
X Toolkit Intrinsics (R5 version)
.br
Data Stream Programmer's Reference, IBM GA23-0059
.br
Character Set Reference, IBM GA27-3831
.SH AUTHORS
Robert Viduya \- SunView based 3270tool
.br
Jeff Sparkes \- X11 port
.br
Paul Mattes \- X enhancements and fixes
