/* #module    GloCmd    "2-001"
 ***********************************************************************
 *                                                                     *
 * The software was developed at the Monsanto Company and is provided  *
 * "as-is".  Monsanto Company and the auther disclaim all warranties   *
 * on the software, including without limitation, all implied warran-  *
 * ties of merchantabilitiy and fitness.                               *
 *                                                                     *
 * This software does not contain any technical data or information    *
 * that is proprietary in nature.  It may be copied, modified, and     *
 * distributed on a non-profit basis and with the inclusion of this    *
 * notice.                                                             *
 *                                                                     *
 ***********************************************************************
 */
/*
 * Module Name:	GloCmd
 *
 * Author:	R L Aurbach	CR&DS MIS Group    18-Aug-1986
 *
 * Function:
 *	This routine parses the GloTeX Command Line, and returns the name of
 *	the input file, a flag which specifies the style of treatment for the
 *	output file, and optionally, a list of files for the glossary definition
 *	file.
 *
 * Modification History:
 *
 * Version     Initials	   Date		Description
 * ------------------------------------------------------------------------
 * 1-001	RLA	18-Aug-1986	Original Code
 * 2-001	F.H.	17-May-1991	converted to portable C
 */
/*
 * Module GloCmd - Module-Wide Data Description Section
 *
 * Include Files:
 */
#ifdef MSDOS
#include <stdlib.h>
#include <io.h>
#define F_OK		0	/* access(): File exists	*/
#else
#	include <sys/file.h>
/* extern char *sprintf(); */
#endif
/* #include <malloc.h> */
#include <string.h>
#include <stdio.h>
#include "GloDef.h"
/*
 * Module Definitions:
 */
/*
 * Global Declarations:
 */
#ifdef MSDOS
void Glo_Command(int argc, char *argv[]);
#else
void Glo_Command();
#endif
/*
 * Static Declarations:
 */
/*
 * External References:
 */
extern STRING_PTR	    filelist;
extern int		    flag;
extern char		    infile[256];
/*
 * Functions Called:
 */
/*
 * Function Glo_Command - Documentation Section
 *
 * Discussion:
 *	This routine uses lib$get_foreign to read the command line.  It
 *	prefixes the command line with "GloTeX ", so that the CLI routines
 *	will have the appropriate information on which to operate. It then
 *	parses the command line and returns the appropriate information to the
 *	program.
 *
 *	Since the routine establishes LIB$SIG_TO_STOP as a condition handler,
 *	syntax errors detected during processing result in program exit.  
 *
 * Calling Synopsis:
 *	Call Glo_Command ()
 *
 * Inputs:
 *	none
 *
 * Outputs:
 *	none
 *
 * Return Value:
 *	none
 *
 * Global Data:
 *	infile	    ->	contains the name of the input file as an ASCIZ string.
 *
 *	flag	    ->	indicates the value of the /STYLE qualifier.
 *
 *	filelist    ->	is updated to contain a list of file specifications.
 *
 * Files Used:
 *	none
 *
 * Assumed Entry State:
 *	GloTeX is invoked as a foreign DCL command.
 *
 * Normal Exit State:
 *	The routine returns to the caller.  The global variables are set up
 *	appropriately.
 *
 * Error Conditions:
 *	For the majority of the processing of the routine, LIB$SIG_TO_STOP
 *	is established as the condition handler.  Therefore, any errors cause
 *	an immediate exit.  
 *
 * Algorithm:
 *	A. Call Lib$Get_Foreign to retrieve the command line.
 *	B. Prefix the command line with the command verb.
 *	C. Call Cli$DCL_Parse to parse the command line.
 *	D. Process the file name.
 *	    1. Get the file name.
 *	    2. Convert it to an ASCIZ string.
 *	E. Process the /STYLE qualifier.
 *	F. Process the /GLOSSARY qualifier.
 *
 * Special Notes:
 *	This routine is based on the LIB_PARSE_FOREIGN routine, suitably 
 *	modified.
 */
/*
 * Function Glo_Command - Code Section
 */
void	Glo_Command (argc, argv)
int argc;
char *argv[];
{
/*
 * Local Declarations
 */
  int		status;
  STRING_PTR	file;
  STRING_PTR	old;
  int i,j,clen;
  char dummy[linesz];
/*
 * Module Body
 */
/* Get the command line	    */
/* Parse the command line   */
/* Get the filename string  */
  (void) sprintf(infile,"%s",argv[1]);
  i=2;
/* Process the /STYLE qualifier	*/
  if (argc > i) {
    if (strncmp("/STYLE",argv[i],6) == 0) {
      if (argv[i][7] == 'A') flag = ARTICLE;
      if (argv[i][7] == 'R') flag = REPORT;
      i++;
    }
  }
/* Process the /GLOSSARY qualifier */
  if (argc > i) {
    if ((strncmp("/GLOSSARY",argv[i],9)) == 0) {
      clen = strlen(argv[i]);
      j=10;
      while (TRUE) {
	file = (STRING_PTR)malloc(sizeof(STRING));
	if (file == 0)	break;
	file->next = 0;
	(void)sscanf(&argv[i][j],"%[^, ]",dummy);
	file->desc = strdup(dummy);
	status = 0;
	if (file->desc[0]!='\0') {
	  status = 1;
	  j+=(strlen(file->desc)+1);
	  if (j > (clen+1)) status = 0;
	}
	if (!(status & TRUE)) return;
	old = filelist;
	if (filelist == 0) filelist = file;
	else {
	  while (old->next != 0) old = old->next;
	  old->next = file;
	}
      }
    }
  }
}
