/*
 * NET-2	This file contains an implementation of the "arcnet"
 *		support functions for the NET-2 base distribution.
 *
 * Version:	@(#)Arcnet.c	1.10	10/07/93
 *
 * Author:	Fred N. van Kempen, <waltje@uwalt.nl.mugnet.org>
 *		Copyright 1993 MicroWalt Corporation
 *
 *		Arcnet added by Alan Cox <iialan@iifeak.swan.ac.uk>
 *
 *		This program is free software; you can redistribute it
 *		and/or  modify it under  the terms of  the GNU General
 *		Public  License as  published  by  the  Free  Software
 *		Foundation;  either  version 2 of the License, or  (at
 *		your option) any later version.
 */
#include "config.h"

#if HAVE_HWARC
#include <sys/types.h>
#include <sys/socket.h>
#include <linux/if_ether.h>
#include <linux/if_arp.h>
#include <stdlib.h>
#include <stdio.h>
#include <errno.h>
#include <ctype.h>
#include <string.h>
#include <unistd.h>
#include "support.h"
#include "pathnames.h"


extern struct hwtype arc_hwtype;


/* Display an Ethernet address in readable format. */
static char *
pr_arcnet(unsigned char *ptr)
{
  static char buff[64];

  sprintf(buff, "%02X", ptr[0]);
  return(buff);
}


/* Display an Ethernet socket address. */
static char *
pr_sarcnet(struct sockaddr *sap)
{
  if (sap->sa_family == 0xFFFF || sap->sa_family == 0) return("[NONE SET]");
  return(pr_arcnet(sap->sa_data));
}


/* Input an Ethernet address and convert to binary. */
static int
in_arcnet(char *bufp, struct sockaddr *sap)
{
  unsigned char *ptr;
  char c, *orig;
  int i, val;

  sap->sa_family = arc_hwtype.type;
  ptr = sap->sa_data;

  i = 0;
  orig = bufp;
  val = 0;
  c = *bufp++;
  if (isdigit(c)) val = c - '0';
    else if (c >= 'a' && c <= 'f') val = c - 'a' + 10;
    else if (c >= 'A' && c <= 'F') val = c - 'A' + 10;
    else {
#ifdef DEBUG
		fprintf(stderr, "in_arc(%s): invalid arcnet address!\n", orig);
#endif
		errno = EINVAL;
		return(-1);
	}
	val <<= 4;
	c = *bufp++;
	if (isdigit(c)) val |= c - '0';
	  else if (c >= 'a' && c <= 'f') val |= c - 'a' + 10;
	  else if (c >= 'A' && c <= 'F') val |= c - 'A' + 10;
	  else {
#ifdef DEBUG
		fprintf(stderr, "in_arcnet(%s): invalid arcnet address!\n", orig);
#endif
		errno = EINVAL;
		return(-1);
	}
	*ptr++ = (unsigned char) (val & 0377);
	i++;
	bufp++;

  /* That's it.  Any trailing junk? */
  if ((i == 1) && (*bufp != '\0')) {
#ifdef DEBUG
	fprintf(stderr, "in_arc(%s): trailing junk!\n", orig);
	errno = EINVAL;
	return(-1);
#endif
  }

#ifdef DEBUG
  fprintf(stderr, "in_arcnet(%s): %s\n", orig, pr_arcnet(sap->sa_data));
#endif

  return(0);
}


struct hwtype arc_hwtype = {
  "arcnet",	"ArcNET",		ARPHRD_ARCNET,	1,
  pr_arcnet,	pr_sarcnet,	in_arcnet,	NULL
};


#endif	/* HAVE_HWARC */
