/* fingerpaths.h -- Location of files used by GNU Finger. */

/* Copyright (C) 1988,1990,1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

/* Directory which contains datafiles that GNU Finger needs. The name
   does NOT end in a slash. */

#ifndef FINGERDIR
#define FINGERDIR "/etc/fingerdir"
#endif

/* File of hostnames that we should poll.  Environment variable
   FINGERCLIENTS affects this. */
#ifndef FINGERCLIENTS
#define FINGERCLIENTS "/etc/fingerdir/clients"
#endif

/* File which contains the data received from all active polled hosts. */
#define HOSTDATA "/etc/fingerdir/hostdata"

/* File which contains the data pertaining to the location of users. */
#define USERDATA "/etc/fingerdir/userdata"

/* File which contains the status of each client that we poll. */
#define HOSTSTAT "/etc/fingerdir/clientstatus"

/* File which contains the name of the GNU Finger server. */
#ifndef SERVERHOSTFILE
#define SERVERHOSTFILE "/etc/fingerdir/serverhost"
#endif

/* File which contains the name of the forward server. */
#ifndef FORWARDHOSTFILE
#define FORWARDHOSTFILE "/etc/fingerdir/forwardhost"
#endif

/* File which contains the name of the SMTP host */
#ifndef SMTPHOSTFILE
#define SMTPHOSTFILE "/etc/fingerdir/mailhost"
#endif

/* File of terminal->location mappings, one per line.  The first word on the
   line is the terminal name, the remaining words are the location.
   The best way to do this if for each host to have a file that is unique to
   them, perhaps by placing it in a local-only directory.  An alternative is
   to have the file contain host->location mappings, which isn't as good, but
   still works.  */
#ifndef TTYLOCFILE
#define TTYLOCFILE "/etc/fingerdir/ttylocs"
#endif

/* Directory to look for special target scripts in */
#ifndef TARGETDIR
#define TARGETDIR "/etc/fingerdir/targets"
#endif

/* If you decide to use the dbm interface for storing information about
   users, then these two defines control the location of the database,
   and the location of the file that describes the format of the database. */

#if !defined (DBMINFO)
#define DBMINFO "/etc/fingerdir/userinfo"
#endif

#if !defined (FORMATFILE)
#define FORMATFILE "/etc/fingerdir/userformat"
#endif
