.\" @(#)convert_to_Xdefaults.1 1.6 90/06/19 SMI;
.TH CONVERT_TO_XDEFAULTS 1  "11 June 1990"
.SH NAME
.B convert_to_Xdefaults
- convert Sunview1 defaults into equivalent Xdefaults

.SH SYNOPSIS
.B convert_to_Xdefaults
[
.I filename
]
.SH AVAILABILITY
Available with the
.I OpenWindows Application Environment.
For information about installing OpenWindows, refer to the
.I OpenWindows Installation Manual.
.SH DESCRIPTION
.LP
.B convert_to_Xdefaults
is a shell script which uses 
.B sed(1) 
scripts 
to convert 
.I SunView1.x 
defaults to 
.I X Window 
(Xdefaults) defaults.  
.B convert_to_Xdefaults
reads 
.I filename, 
converting SunView1 defaults
into their equivalent Xdefaults for XView.  Defaults
that are no longer supported or are not recognized as standard
.I SunView1 
defaults are commented out with a '!' (exclamation point) at
the beginnning of the default entry.  The output of conversion
is directed to standard output (stdout).  
The defaults file used should be located in your
.I $HOME
directory and should be named
.I .Xdefaults.
.SH EXAMPLES

For an example of how this command works, run the script on your
.I Sunview1
defaults file:

.B convert_to_Xdefaults
.I $HOME/.defaults 
>
.I $HOME/.Xdefaults

When the script is complete, edit the resulting file (
.I $HOME/.Xdefaults
) and remove any unconverted entries and/or make modifications
suggested in the file by the script. Remove the comments and the
.I !
sign.

.SH SAMPLES
SunView1 defaults entries ...

.sp
.fH
.ft B
.nf 
	
	/Text/Auto_indent       	"True"
	/Text/Extras_menu_filename      "/home/blinky/bob/.text_extras_menu"
	/Scrollbar/Thickness		"20"	
	 /Mail/Set/folder		"/home/blinky/bob/mail_folder"
	/Text/Multi_click_timeout	"100"

.fi
.sp
.ft R	
are converted to the Xdefault...
.sp
.fH
.ft B
.nf 
     
        Text.AutoIndent:        	True
        Text.ExtrasMenuFilename:        /home/blinky/bob/.text_extras_menu
        !/Scrollbar/Thickness		"20"
        !/Mail/Set/folder		"/home/blinky/bob/mail_folder"
        !OpenWindows.MultiClickTimeout:
         ! (now in tenths of seconds rather than millisecs)  100


.fi
.sp

Note that the 
.B /Scrollbar/Thickness 
and 
.B /Mail/Set/folder 
entries
were NOT converted, but were left in the file as comments.
Whenever possible, instructions are
included in the file for discrepancies between the two types
of defaults. For instance, the comment, "now in tenths of
seconds" is useful information about the value of the
.B OpenWindows.MultiClickTimeout 
default.
Comments and instructions should both be completely removed from
the file.

.SH FILES

.I $OPENWINHOME/bin/xview/convert_to_Xdefaults 
where
.I $OPENWINHOME
is the installation/mount point for XView ( 
.I /usr 
by default).


.SH SEE ALSO
     
sunview(1), sed(1), textedit(1), vi(1)



