#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <ctype.h>

#include "filemgr.h"
#include "debug.h"

extern char *MyName;

/****************************************************************************
 * 
 * This file creates an filename/type to icon pixmap mapping.
 *
 * For speed, icon pixmaps will be cached in memory once they are used 
 * 
 ***************************************************************************/
#define LINE_BUFF 255
struct mapping *read_config_file(void)
{
  char *home,*full_name,*file=".fvwmfmgr";
  FILE *fd;
  char line[LINE_BUFF], *newend, *newstart;
  struct mapping *thismap=NULL, *root_map = NULL,*prevmap;

  home = getenv("HOME");
  full_name = (char *)safemalloc(strlen(home)+ strlen(file)+2,"full_name");
  strcpy(full_name,home);
  strcat(full_name,"/");
  strcat(full_name,file);

  /* Format of the file: vaguely reminiscent of the OpenWindows
   * /etc/filetype.
   * filename, file-type, file-permissions : startup-command,icon-pixmap-file
   *
   * The file-type is supposed to be the output of the "file" command,
   * which won't be implemented at first. The file-permissions will be
   * only x for execute or d for directory. The remaining r, w or group/
   * owner/world distinctions do not seem to be useful
   */
  
  fd = fopen(full_name,"r");
  if(fd == (FILE *)NULL)
    {
      fd = fopen(FVWMFILEMGRRC,"r");
      if(fd == (FILE *)NULL)
	{
	  fprintf(stderr,"%s: No file %s. Aborting\n",MyName,full_name);
	  exit(1);
	}
    }
  safefree(full_name,"full_name","a");
  while(fgets(line,(LINE_BUFF-1),fd) != NULL)
    {
      newstart = line;

      while((isspace(*newstart))&&(*newstart != 0))
	newstart++;
      if((*newstart != '#')&&(strlen(newstart)>=4))
	{
	  prevmap = thismap;
	  thismap = safemalloc(sizeof(struct mapping),"mapping");
	  if(root_map == NULL)
	    root_map = thismap;
	  else
	    prevmap->next = thismap;      
	  thismap->next = NULL;
	  thismap->name = NULL;
	  thismap->type = NULL;
	  thismap->permissions = NULL;
	  thismap->command = NULL;
	  thismap->pixmap_file = NULL;
	  thismap->icon = None;
	  
	  /* read the "filename" part */
	  thismap->name = get_one_part(newstart,",",&newend);
	  
	  if((newend != NULL)&&(*newend != 0)&&(newend - line < strlen(line)))
	    {
	      newstart = newend+1;
	      thismap->type = get_one_part(newstart,",",&newend);
	    }
	  
	  if((newend != NULL)&&(*newend != 0)&&(newend - line < strlen(line)))
	    {
	      newstart = newend+1;
	      thismap->permissions = get_one_part(newstart,":",&newend);
	    }
	  if((newend != NULL)&&(*newend != 0)&&(newend - line < strlen(line)))
	    {
	      newstart = newend+1;
	      thismap->command = get_one_part(newstart,",",&newend);
	    }
	  if((newend != NULL)&&(*newend != 0)&&(newend - line < strlen(line)))
	    {
	      newstart = newend+1;
	      thismap->pixmap_file = get_one_part(newstart,",",&newend);
	    }
	}
    }
  return root_map;
}





char *get_one_part(char *line, char *terminator,char **end)
{
  char *end1, *end2, *start1, *thisentry = NULL;

  if(line == NULL)
    {
      *end = NULL;
      return NULL;
    }

  end1 = strstr(line,terminator);
  if(end1 == NULL)
    end1 = line + strlen(line);

  start1 =line;
  while(isspace(*start1)&&(*start1 != 0)&&(start1-line < LINE_BUFF-1))
    start1++;

  end2 = end1-1;
  while(isspace(*end2)&&(*end2 != 0)&&(end2-start1>0))
    end2--;
  if(end2-line >=0)
    {
      thisentry = (char *)safemalloc(end2-start1+2,"thisentry");
      strncpy(thisentry,start1,end2-start1+1);
      thisentry[end2-start1+1] = 0;
    }
      
  *end = end1;
  return thisentry;
}



void free_mapping(struct mapping *root)
{
  struct mapping *next;

  while(root != NULL)
    {
      if(root->name != NULL)
	safefree(root->name,"mapping","name");
      if(root->type != NULL)
      safefree(root->type,"mapping","type");
      if(root->permissions != NULL)
	safefree(root->permissions,"mapping","perm");
      if(root->command != NULL)
	safefree(root->command,"mapping","command");
      if(root->pixmap_file != NULL)
	safefree(root->pixmap_file,"mapping","file");
      next = root->next;
      safefree(root,"mapping","struct");
      root = next;
    }
}
