
#include <stdio.h>

#include <vdi.h>

#include "trees.h"

void wdebug (char *fmt, ...);

void
tr_dump(t)
register TREE *t;
{
	FILE *fp ;
	int i = 0;
	int level = 0;

	if ( ( fp = fopen ("tree.dmp", "w") ) == NULL )
		wdebug ("Cannot open dump file") ;

	if ( t->nobjs <= 0 ) {
		fprintf(fp, "Empty tree.\n");
		return;
	}
	do {
		int k;

		fprintf(fp, "%d.", i);

		for ( k = 0; k < level; k++ ) fprintf(fp, "    ");

		fprintf (fp, "  %d, %d, %d, %d", t->obj[i].ob_x, t->obj[i].ob_y,
					t->obj[i].ob_width, t->obj[i].ob_height);
		if (t->obj[i].ob_type == G_TITLE || t->obj[i].ob_type == G_STRING)
			fprintf (fp, "   %s\n", t->obj[i].ob_spec);
		else
			fprintf (fp, "\n");
		if ( HEAD(i) >= 0 ) {
			level++;
			i = HEAD(i);
		}
		else {
			while ( NEXT(i) >= 0 && TAIL(NEXT(i)) == i ) {
				level--;
				i = NEXT(i);
			}
			i = NEXT(i);
		}
	} while ( i >= 0 );
	fclose (fp);
}

