
#include "window.h"

#define HOR_STEP	( width < 10 ? wcharwidth ('m') : width / 10 )

void
do_scroll(msg_buf)
int	msg_buf[8];
{
	WINDOW	*win = getwin (msg_buf[3]);
	int	orgh = win->orgh;
	int	orgv = win->orgv;
	int	width = win->width;
	int	height = win->height;

	if (win == NULL) return;

	if (msg_buf[0] == WM_ARROWED) {
		switch (msg_buf[4]) {
			case 0 :	/* Page up */
				orgv -= (height - wlineheight ());
				break;
			case 1 :	/* Page down */
				orgv += (height - wlineheight ());
				break;
			case 2 :	/* Arrow up */
				orgv -= wlineheight ();
				break;
			case 3 :	/* Arrow down */
				orgv += wlineheight ();
				break;
			case 4 :	/* Page left */
				orgh -= (width - HOR_STEP);
				break;
			case 5 :	/* Page right */
				orgh += (width - HOR_STEP);
				break;
			case 6 :	/* Arrow left */
				orgh -= HOR_STEP;
				break;
			case 7 :	/* Arrow right */
				orgh += HOR_STEP;
				break;
		}
	}
	else if ( msg_buf[0] == WM_HSLID )
		orgh = (long) msg_buf[4] * (long) (win->doc_width - width)
								/ 1000L;
	else
		orgv = (long) msg_buf[4] * (long) (win->doc_height - height)
								/ 1000L;

	wsetorigin (win, orgh, orgv);
}
