/* GCC Library
 * Jrg Hhle, 21-Nov-92
 */

#include "defs.h"
#include <workbench/startup.h>
#include <workbench/icon.h>
#include <workbench/workbench.h>
#ifdef __GNUC__
  #include <inline/exec.h>
  #include <inline/dos.h>
  #include <inline/icon.h>
#else
  #include <clib/exec.h>
  #include <clib/dos.h>
  #include <clib/icon.h>
#endif

struct Library * IconBase = NULL;

extern char _WDefName13[];
extern char _WDefName[];

void wbmain(struct WBStartup* wbmsg)
{
  char *ioname = NULL;  /* IO stream name that we are going to open */
  int argc = 0;
  char **argv;
  short int numargs = wbmsg->sm_NumArgs;
  #define MAXIONAME 100 /* including '\0' byte */
  char ionamebuf[MAXIONAME];
  struct argline {
    char *line;       /* tokenized content */
    int nt;           /* number of tokens in ARGS ToolType line */
  } argline[numargs];
  debug_asciz_out("In wbmain()");
  debug_dez_out(numargs);
  IconBase = OpenLibrary(ICONNAME,0L);
  if (IconBase != NULL)
    { register short int i;
      struct WBArg *wbarg;
      for (i = 0, wbarg = wbmsg->sm_ArgList;
           i < numargs;
           i++, wbarg++)
        { struct DiskObject* dobj;
          argline[i].line = NULL;
          debug_asciz_out("Object");
          if (wbarg->wa_Name != NULL)
            {
              dobj = GetDiskObject(wbarg->wa_Name);
              debug_asciz_out(wbarg->wa_Name);
            }
          else { dobj = NULL; debug_asciz_out("Without Name"); }
          if (dobj != NULL)
            { char* arg = FindToolType(dobj->do_ToolTypes,"WINDOW");
              /* ex: WINDOW=CON:0/0/640/200/CLOS-Listener oder WINDOW=NIL: */
              if (arg != NULL)
                { register int len = asciz_length(arg);
                  if (len < MAXIONAME)
                    { /* we overwrite, thus using the last possible name */
                      debug_asciz_out("Found WINDOW ToolType");
                      ioname = &ionamebuf[0];
                      bcopy(arg,ionamebuf,len+1);
                    }
                }
              arg = FindToolType(dobj->do_ToolTypes,"ARGS");
              /* ex: ARGS=-Mcompiled.mem */
              if (arg != NULL)
                { register int len = asciz_length(arg);
                  debug_asciz_out("Found ARG ToolType"); debug_asciz_out(arg);
                  argline[i].line = alloca(len+1);
                  bcopy(arg,argline[i].line,len+1);
                  argc += argline[i].nt = _tokenize(argline[i].line,len);
                }
              FreeDiskObject(dobj);
            }
          if (i > 0 && argline[i].line == NULL)
            { /* if there's no ARGS ToolType don't resign, add the filename */
              #ifdef FOR_CLISP
              argc += 2;      /* add -i <name> */
              #else
              argc += 1;      /* simply add <name> */
              #endif
            }
        }
      CloseLibrary(IconBase);
      IconBase = NULL;
    }
  debug_asciz_out("argc is"); debug_dez_out(argc);
  debug_asciz_out("Going to alloca(argv)");
  argv = alloca((argc+2) * sizeof(char *));   /* room for argv[0] and last NULL */
  argv[0] = wbmsg->sm_ArgList->wa_Name;       /* command name first */
  /* (we fail to consider the case where sm_ArgList is NULL) */
  { register short int i;
    struct WBArg *wbarg;
    register char **av = &argv[1];
    for(i = 0, wbarg = wbmsg->sm_ArgList;
        i < numargs;
        i++, wbarg++)
      {
        if (argline[i].line != NULL)
          { register int ac = argline[i].nt;
            debug_asciz_out("ARGS argline");
            _dumpargs(argline[i].line,av,ac);
            debug_dez_out(ac);
            for ( ; ac > 0; ac--, av++)
              { /* replace the token '*' with the file name */
                if ((*av)[0] == '*' && (*av)[1] == '\0')
                  { *av = wbarg->wa_Name; }
              }
          }
        else if (i > 0) /* not for the command name */
          { /* no ARGS option specified, use "-i <name>" (see above) */
            #ifdef FOR_CLISP
            *(av++) = "-i";
            #endif
            *(av++) = wbarg->wa_Name;
            debug_asciz_out("Empty argline");
          }
      }
    *av = NULL;
    /* av - &argv[1] should be argc now */
    debug_asciz_out("+av is"); debug_dez_out(av - &argv[1]);
  }
  debug_asciz_out(argv[0]);
  argc++;       /* count command name argv[0] */

  if (ioname == NULL)
    { ioname = _OS_Version >= 37 ? _WDefName : _WDefName13; }

  Input_handle = Output_handle = Open(ioname,MODE_OLDFILE);
  if (NULL != Input_handle)
    {
      _Close_Output = TRUE;     /* opened once, so close once */
      debug_asciz_out("Calling main()");
      main(argc,argv);
    }
}
