/* C code produced by gperf version 1.7 (K&R C version) */
/* Command-line: gperf -g -o -j1 -t -p -N is_reserved_word /src/gnu/gpc/2.5.6/gpc.gperf  */

 
/* ISO Pascal 7185 && Extended Pascal (Jan 29, 1989 Draft) reserved words.

   Copyright (C) 1989, 1993, Free Software Foundation, Inc.

This file is part of GNU GPC.

GNU GPC is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 1, or (at your option)
any later version.

GNU GPC is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU GPC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  */

/*
 * For GNU Pascal compiler (GPC) by Jukka Virtanen, jtv@hut.fi
 *
 * run this through the Doug Schmidt's gperf program
 * with command
 * gperf  -g -o -j1 -t -p -N is_reserved_word
 *
 * Thanks, Doug.
 */

/* ISO Pascal 7185 keywords are recognized as keywords.
 *
 * To treat PASCAL_EXTEND type keywords as keywords,
 * you must give -fpascal_extended when compiling.
 *
 * To treat PASCAL_OBJECT keywords as keywords, give
 * -fpascal_object
 *
 * Otherwise they are recognized, but may be redfined.
 * This violates Extended Pascal standard, but works anyhow,
 * if your program does not redefine them. And it also makes
 * ISO standard pascal program compile without modifications with GPC.
 *
 */
struct resword { char *name;
		 short token;
		 short iclass;
		 int   informed;
	       };
;

#define MIN_WORD_LENGTH 2
#define MAX_WORD_LENGTH 11
#define MIN_HASH_VALUE 3
#define MAX_HASH_VALUE 69
/*
   56 keywords
   67 is the maximum key range
*/

#ifdef __GNUC__
inline
#endif
static int
hash (str, len)
     register char  *str;
     register int  len;
{
  static int hash_table[] =
    {
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
      69,  69,  69,  69,  69,  30,  28,  29,  21,  22,
      17,  14,  69,  44,  69,  69,  11,  11,  51,   1,
       0,  11,  13,  29,  37,  10,   1,   8,  69,  69,
      69,  69,  69,  69,  69,  69,  69,  69,  69,  69,
       5,   0,   2,  69,   0,  69,  69,  69,   0,   0,
       4,   0,  69,  69,   0,  17,  15,  69,  28,  41,
      69,  27,  69,  69,  69,  69,  69,  69,
    };
  return len + hash_table[str[len - 1]] + hash_table[str[0]];
}

#ifdef __GNUC__
inline
#endif
struct resword *
is_reserved_word  (str, len)
     register char *str;
     register int len;
{

  static struct resword wordlist[] =
    {
      { "", }, { "", }, { "", }, 
      {"Or", 		OR,		PASCAL_ISO,	0 },
      {"Var", 		VAR,		PASCAL_ISO,	0 },
      {"Of", 		OF,		PASCAL_ISO,	0 },
      {"Value",   	VALUE,  	PASCAL_EXTEND,	0 },
      {"Program",    	PROGRAM,   	PASCAL_ISO,	0 },
      {"Or_else",  	OR_ELSE, 	PASCAL_EXTEND,	0 },
      {"Procedure",  	PROCEDURE, 	PASCAL_ISO,	0 },
      {"Otherwise",  	OTHERWISE, 	PASCAL_EXTEND,	0 },
      {"Packed", 		PACKED,		PASCAL_ISO,	0 },
      {"With", 		WITH,		PASCAL_ISO,	0 },
      {"While", 		WHILE,		PASCAL_ISO,	0 },
      {"Protected",  	PROTECTED, 	PASCAL_EXTEND,	0 },
      {"Until", 		UNTIL,		PASCAL_ISO,	0 },
      {"Label", 		LABEL,		PASCAL_ISO,	0 },
      {"Module",  	MODULE, 	PASCAL_EXTEND,	0 },
      {"Goto", 		GOTO,		PASCAL_ISO,	0 },
      {"Mod", 		MOD,		PASCAL_ISO,	0 },
      {"For", 		FOR,		PASCAL_ISO,	0 },
      {"File", 		FILE_,		PASCAL_ISO,	0 },
      { "", }, 
      {"Do", 		DO,		PASCAL_ISO,	0 },
      {"Record", 		RECORD,		PASCAL_ISO,	0 },
      {"Qualified",  	QUALIFIED, 	PASCAL_EXTEND,	0 },
      {"Else", 		ELSE,		PASCAL_ISO,	0 },
      {"Downto",  	DOWNTO,		PASCAL_ISO,	0 },
      {"Restricted",    	RESTRICTED,	PASCAL_EXTEND,	0 },
      {"Function",  	FUNCTION, 	PASCAL_ISO,	0 },
      {"End", 		END,		PASCAL_ISO,	0 },
      {"Destructor", 	OP_DESTRUCTOR,	PASCAL_OBJECT,	0 },
      {"Only",    	ONLY,   	PASCAL_EXTEND,	0 },
      {"Case", 		CASE,		PASCAL_ISO,	0 },
      {"Repeat", 		REPEAT,		PASCAL_ISO,	0 },
      {"Property", 	OP_PROPERTY, 	PASCAL_OBJECT,	0 },
      {"Bindable",  	BINDABLE,	PASCAL_EXTEND,	0 },
      {"Begin", 		BEGIN,		PASCAL_ISO,	0 },
      {"And", 		AND,		PASCAL_ISO,	0 },
      {"To", 		TO,		PASCAL_ISO,	0 },
      {"Constructor", 	OP_CONSTRUCTOR,	PASCAL_OBJECT,	0 },
      {"Type", 		TYPE,		PASCAL_ISO,	0 },
      {"And_then",  	AND_THEN, 	PASCAL_EXTEND,	0 },
      {"Export",  	EXPORT, 	PASCAL_EXTEND,	0 },
      {"Pow",     	POW,    	PASCAL_EXTEND,	0 },
      {"Then", 		THEN,		PASCAL_ISO,	0 },
      {"View", 		OP_VIEW,	PASCAL_OBJECT,	0 },
      {"Set", 		SET,		PASCAL_ISO,	0 },
      {"If", 		IF,		PASCAL_ISO,	0 },
      {"Const", 		CONST,		PASCAL_ISO,	0 },
      {"In", 		IN,		PASCAL_ISO,	0 },
      {"Class", 		OP_CLASS,	PASCAL_OBJECT,	0 },
      {"Div", 		DIV,		PASCAL_ISO,	0 },
      {"Abstract", 	OP_ABSTRACT,	PASCAL_OBJECT,	0 },
      {"Nil", 		NIL,		PASCAL_ISO,	0 },
      { "", }, { "", }, { "", }, 
      {"Inherited", 	OP_INHERITED,	PASCAL_OBJECT,	0 },
      { "", }, { "", }, { "", }, 
      {"Array", 		ARRAY,		PASCAL_ISO,	0 },
      {"Is", 		OP_IS,		PASCAL_OBJECT,	0 },
      { "", }, 
      {"Import",  	IMPORT, 	PASCAL_EXTEND,	0 },
      { "", }, { "", }, { "", }, 
      {"Not", 		NOT,		PASCAL_ISO,	0 },
    };

  if (len <= MAX_WORD_LENGTH && len >= MIN_WORD_LENGTH)
    {
      register int key = hash (str, len);

      if (key <= MAX_HASH_VALUE && key >= MIN_HASH_VALUE)
        {
          register char *s = wordlist[key].name;

          if (*s == *str && !strcmp (str + 1, s + 1))
            return  &wordlist[key];
        }
    }
  return 0;
}
