------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                           S Y S T E M . R P C                            --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Streams;
with System.Storage_Elements;

package System.RPC is

   type Partition_Id is range 0 .. Integer'Last; -- temporary declaration

   type Service_Id is private;

   Communication_Error : exception;

   type Params_Stream_Type
     (Initial_Size : Storage_Elements.Storage_Count) is new
       Ada.Streams.Root_Stream_Type with private;

   type Params_Stream_Access is access Params_Stream_Type;

   procedure Read (Stream : in out Params_Stream_Type;
                   Item   : out Storage_Elements.Storage_Array;
                   Last   : out Storage_Elements.Storage_Offset);

   procedure Write (Stream : in out Params_Stream_Type;
                    Item   : in Storage_Elements.Storage_Array);

   procedure Do_RPC (Partition  : in Partition_Id;
                     Service    : in Service_Id;
                     Params     : access Params_Stream_Type;
                     Result     : out Params_Stream_Access);
   --  Synchronous call

   procedure Do_APC (Partition  : in Partition_Id;
                     Service    : in Service_Id;
                     Params     : access Params_Stream_Type);
   --  Asynchronous call

   type RPC_Receiver is
     access procedure (Service    : in Service_Id;
                       Params     : in Params_Stream_Access;
                       Result     : out Params_Stream_Access);

   procedure Establish_RPC_Receiver (Receiver : in RPC_Receiver);

private
   type Service_Id is new Natural; -- temporary declaration ???
end System.RPC;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Mon Dec 27 23:53:46 1993;  author: dewar
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Sun Jan  9 11:17:22 1994;  author: dewar
--  New header with 1994 copyright
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
