------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                             F I X _ U T I L                              --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                             $Revision: 1.3 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Uintp;  use Uintp;
with Urealp; use Urealp;

package body Fix_Util is

   --------------------
   -- UR_Normal_Form --
   --------------------

   procedure UR_Normal_Form
     (Real   : Ureal;
      Normal : out Ureal;
      Scale  : out Uint)
   is
   begin
      Scale  := Uint_0;

      if UR_Eq (Real, Ureal_0) then
         Normal := Ureal_0;

      else
         Normal := UR_Abs (Real);

         while UR_Lt (Normal, Ureal_Half) loop
            Normal := UR_Product (Normal, Ureal_2);
            Scale := UI_Difference (Scale, Uint_1);
         end loop;

         while UR_Ge (Normal, Ureal_1) loop
            Normal := UR_Quotient (Normal, Ureal_2);
            Scale := UI_Sum (Scale, Uint_1);
         end loop;

         Normal := UR_Product (UR_From_Uint (UR_Sign (Real)), Normal);
      end if;
   end UR_Normal_Form;

   --------------
   -- UR_Round --
   --------------

   function UR_Round (Real : Ureal; N : Uint) return Ureal is
      Norm_R : Ureal;
      Fact_R : Uint;

   begin
      UR_Normal_Form (Real, Norm_R, Fact_R);
      return UR_Product
               (UR_Exponentiate
                  (Ureal_2,
                   UI_Difference (Fact_R, N)),
                UR_From_Uint
                  (UR_Trunc
                     (UR_Sum
                        (UR_Product (UR_Exponentiate (Ureal_2, N), Norm_R),
                         UR_Product
                           (UR_From_Uint (UR_Sign (Real)),
                            Ureal_Half)))));
   end UR_Round;

   -------------
   -- UR_Sign --
   -------------

   function UR_Sign (Real : Ureal) return Uint is
   begin
      if UI_Is_Negative (Numerator (Real)) then
         return Uint_Minus_1;
      else
         return Uint_1;
      end if;
   end UR_Sign;

   ------------------
   -- UR_Sign_Plus --
   ------------------

   function UR_Sign_Plus (Real : Ureal) return Uint is
   begin
      if UI_Is_Negative (Numerator (Real)) then
         return Uint_0;
      else
         return Uint_1;
      end if;
   end UR_Sign_Plus;

end Fix_Util;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.1
--  date: Wed May 25 16:56:55 1994;  author: crozes
--  Initial revision
--  ----------------------------
--  revision 1.2
--  date: Thu May 26 02:34:30 1994;  author: dewar
--  Minor reformatting
--  ----------------------------
--  revision 1.3
--  date: Thu May 26 18:05:00 1994;  author: crozes
--  (UR_Normal_Form) : corrected (was wrong for negative and nul reals).
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
