/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A - N A M E T                               */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.21 $                             */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C file that corresponds to the Ada package specification
   Namet. It was created manually from files namet.ads and namet.adb.

/* Structure defining a names table entry.  */

struct Name_Entry
{
  Int Name_Chars_Index; /* Starting location of char in Name_Chars table. */
  Short Name_Len;         /* Length of this name in characters. */
  Byte Byte_Info;       /* Byte value associated with this name */
  Byte Spare;           /* Unused */
  Name_Id Hash_Link;    /* Link to next entry in names table for same hash
                           code. Not accessed by C routines.  */
  Int Int_Info;         /* Int value associated with this name */
};

/* Pointer to names table vector. This pointer is passed to the tree
   transformer and stored in a global location for access from here after
   subtracting Names_First_Entry so that Name_Id values can be used as
   subscripts into this table.  */
extern struct Name_Entry *Names_Ptr;

/* Pointer to name characters table. This pointer is passed to the tree
   transformer and stored in a global location for access from here.  */
extern char *Name_Chars_Ptr;

#define Name_Buffer namet__name_buffer
extern char Name_Buffer[];

extern Int namet__name_len;
#define Name_Len namet__name_len

/* Get_Name_String returns a null terminated C string for the specified name.
   We could use the official Ada routine for this purpose, but since the
   strings we want are sitting in the name strings table in exactly the form
   we need them (null terminated), we just point to the name directly. */

INLINE char *
Get_Name_String (Id)
     Name_Id Id;
{
  return Name_Chars_Ptr + Names_Ptr [Id].Name_Chars_Index + 1;
}

/* Get_Decoded_Name_String returns a null terminated C string in the same
   manner as Get_Name_String, except that it is decoded (i.e. upper half or
   wide characters are put back in their external form, and character literals
   are also returned in their external form (with surrounding apostrophes) */

extern void namet__get_decoded_name_string PROTO ((Name_Id));

INLINE char *
Get_Decoded_Name_String (Id)
     Name_Id Id;
{
  namet__get_decoded_name_string (Id);
  Name_Buffer [Name_Len] = 0;
  return Name_Buffer;
}

/* Likewise, but also upper-case the string.  */

extern void casing__set_all_upper_case PROTO ((void));

INLINE char *
Get_Upper_Decoded_Name_String (Id)
     Name_Id Id;
{
  namet__get_decoded_name_string (Id);
  casing__set_all_upper_case ();
  Name_Buffer [Name_Len] = 0;
  return Name_Buffer;
}

/* End of a-namet.h (C version of Namet package specification and body) */

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.19
date: Sun Jan 30 15:57:40 1994;  author: dewar
(Get_Attribute_Id): Moved to separate file a-snames.h
(Get_Decoded_Name_String): New procedure, similar to the one in Namet
----------------------------
revision 1.20
date: Fri May 13 17:38:34 1994;  author: banner
(Get_Decoded_Name_String): add in missing actual Id in call.
----------------------------
revision 1.21
date: Mon May 16 13:25:21 1994;  author: kenner
(casing__set_all_upper_case): Add definition.
(Get_Upper_Decoded_Name_String): New function.
----------------------------
** New changes after this line and before endif. **
#endif
