/* Very simple garbage collector.
   Copyright (C) 1994 Miguel de Icaza

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */

#include <malloc.h>
#include <sys/types.h>
#include <stdio.h>
#include "util.h"
#include "gc.h"

static char rcsid [] = "$Id: gc.c,v 1.1 1994/10/06 02:19:04 miguel Exp $";

#define MAX_GC_POINTERS 20

static struct {
    void *p;
    int  ref_count;
} mem_pool [MAX_GC_POINTERS];

void *gc_alloc (int size)
{
    int  i, j;
    static int pos;
    void *t = xmalloc (size, "gc_alloc");

    /* Search that pointer */
    for (i = 0; i < MAX_GC_POINTERS; i++){
	j = (i + pos) % MAX_GC_POINTERS;
	if (!mem_pool [j].p){
	    mem_pool [j].p = t;
	    mem_pool [j].ref_count = 1;
	    pos = i;
	    return t;
	}
    }
    fprintf (stderr, "Not enough GC handles\n");
    return t;
}

void *gc_use_pointer (void *p)
{
    int i;

    for (i = 0; i < MAX_GC_POINTERS; i++){
	if (mem_pool [i].p == p){
	    mem_pool [i].ref_count++;
	    return p;
	}
    }
    return p;
}

void garbage_collect ()
{
    int i;

    for (i = 0; i < MAX_GC_POINTERS; i++){
	if (mem_pool [i].p && (mem_pool [i].ref_count == 0)){
	    free (mem_pool [i].p);
	    mem_pool [i].p = 0;
	}
    }
}

void gc_free (void *p)
{
    int i;
    
    for (i = 0; i < MAX_GC_POINTERS; i++)
	if (mem_pool [i].p == p){
	    if (mem_pool [i].ref_count)
		mem_pool [i].ref_count--;
	    return;
	}
}

void gc_free_now (void *p)
{
    int i;
    
    for (i = 0; i < MAX_GC_POINTERS; i++)
	if (mem_pool [i].p == p){
	    if (mem_pool [i].ref_count)
		mem_pool [i].ref_count--;
	    free (p);
	    mem_pool [i].p = 0;
	    return;
	}
}    
