#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <linux/module.h>
#include <linux/unistd.h>

/*
 * This is here as syscall.h and sys/syscall.h redefine the defines in
 * unistd.h why doesn't unistd #include them?
 */

extern int syscall(int, ...);


static int delete_module(const char *);

int
main( int argc, char **argv) {
  if (delete_module( argv[ 1]) < 0) {
    perror( "delete_module");
    exit( 2);
  }
  exit( 0);
}

static int
delete_module(const char *name) {
  return syscall( __NR_delete_module, name);
}

