/*
 * @(#)defs-hpux.h	1.1	8/3/93
 *
 * Various definitions and declarations for HPUX systems, which have no
 * built-in ioctls for controlling the CD drive.
 */

int INTTOBCD(number)	 /* do an integer to bcd conversion */
unsigned char number;
{
	return (number+6*(number/10)) & 0xff ;
}
unsigned char BCDTOINT(number)	 /* do a bcd to integer conversion */
int number;
{
	return (number/16)*10 + number%16;
}
/*#define INTTOBCD(a) ((a / 10) << 4) | (a % 10)*/
/*#define BCDTOINT(a) (((a & 0xF0) >> 4) * 10) + (a & 0x0F)*/
        
union scsi_cd_reply {
        u_char	all[12];	/* reserve 12 bytes for reply */
        struct {
                unsigned playback_status:8;
#define CDAUDIO_SUBQ_PLAY	0x00
#define CDAUDIO_SUBQ_STILL	0x01
#define CDAUDIO_SUBQ_PAUSE	0x02
#define CDAUDIO_SUBQ_DONE	0x03
                unsigned control_data:8;
#define CDAUDIO_SUBQ_PREEMPHASIS	0x01
#define CDAUDIO_SUBQ_COPY_OK		0x02
#define CDAUDIO_SUBQ_DATA_TRK		0x04
#define CDAUDIO_SUBQ_4_CHAN		0x08
                unsigned track:8;
                unsigned index:8;
                unsigned minute:8;
                unsigned second:8;
                unsigned frame:8;
                unsigned abs_minute:8;
                unsigned abs_second:8;
                unsigned abs_frame:8;
        } rdsubq;
        union {
                struct {
                        unsigned first:8;
                        unsigned last:8;
                } track;
                struct {
                        unsigned minute:8;
                        unsigned second:8;
                        unsigned frame:8;
                        unsigned control_data:8;
                } time;
        } rdinfo;
        struct {
                unsigned mode_data:8;
        } rdmode;
} reply_buf;

#define SCSI_TIMEOUT 500

/* CD audio io opcodes */
#define CDAUDIOSTOP	0x1B	/* Stop */
#define CDAUDIOSEARCH	0xC0	/* Search Track */
#define CDAUDIOPLAY	0xC1	/* Play Audio */
#define CDAUDIOSTILL	0xC2	/* Still */
#define CDAUDIOSTOPTIME	0xC3	/* Set Stop Time */
#define CDAUDIOTROPEN	0xC4	/* Tray Open (Caddy eject) */
#define CDAUDIOTRCLOSE	0xC5	/* Tray Close */
#define CDAUDIORDSUBQ	0xC6	/* Read Subcode-Q Data */
#define CDAUDIORDINFO	0xC7	/* Read Disc Information */
#define CDAUDIORDMODE	0xC8	/* Read CD Mode */

/* Types for search and play */
#define CDAUDIO_TYPE_LBA	0x00	/* Logical block address */
#define CDAUDIO_TYPE_ABS	0x01<<6	/* Absolute time */
#define CDAUDIO_TYPE_TRK	0x02<<6	/* Track number */
#define CDAUDIO_TYPE_SAVE	0x03<<6	/* Preserve previous ending address (Play) */

/* Play modes */
#define CDAUDIO_PLAY_MUTE	0x00	/* Muting on */
#define CDAUDIO_PLAY_LEFT	0x01	/* Left channel Mono */
#define CDAUDIO_PLAY_RIGHT	0x02	/* Right channel Mono */
#define CDAUDIO_PLAY_STEREO	0x03	/* Stereo */
#define CDAUDIO_PLAY_SAVE	0x04	/* Preserve previous playback mode */

struct scsi_cmd_parms track_search = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIOSEARCH, 0x00, 0x01, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, CDAUDIO_TYPE_ABS
};

struct scsi_cmd_parms play_audio = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIOPLAY, 0x03, 0x02, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, CDAUDIO_TYPE_ABS
};

/*
 * read_disc_info[4] values
 */
#define CDAUDIO_TOC_TRK		0x00	/* Track number of 1st and last on disc */
#define CDAUDIO_TOC_LEADOUT	0x01
#define CDAUDIO_TOC_CTRL	0x02	/* Starting pt of control */

struct scsi_cmd_parms read_disc_info = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIORDINFO, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00
};

struct scsi_cmd_parms stop = {
	6, 1, SCSI_TIMEOUT,
	CDAUDIOSTOP, 0x00, 0x00, 0x00, 0x00, 0x00
};

struct scsi_cmd_parms playing_status = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIORDSUBQ, 0x0a, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00
};

struct scsi_cmd_parms disc_eject = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIOTROPEN, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00
};

struct scsi_cmd_parms still = {
	10, 1, SCSI_TIMEOUT,
	CDAUDIOSTILL, 0x00, 0x00, 0x00, 0x00, 
	0x00, 0x00, 0x00, 0x00, 0x00
};
