/*
 *   The search routine takes a directory list, separated by PATHSEP, and
 *   tries to open a file.  Null directory components indicate current
 *   directory. if the file SUBDIR exists and the file is a font file,
 *   it checks for the file in a subdirectory named the same as the font name.
 *   Returns the open file descriptor if ok, else NULL.
 */
#include "dvips.h" /* The copyright notice in that file is included too! */
#include <kpathsea/pathsearch.h>
#include <kpathsea/tex-glyph.h>
/*
 *
 *   We hope MAXPATHLEN is enough -- only rudimentary checking is done!
 */

#ifdef DEBUG
extern integer debug_flag;
#endif  /* DEBUG */
extern char *mfmode ;
extern int actualdpi ;
string realnameoffile ;

FILE *
search(path, file, mode)
    char *path, *file, *mode ;
{
  FILE *ret;
  string name = kpse_path_search (path, file);

  if (name)
    {
      ret = fopen (name, mode);
      if (!ret)
        FATAL_PERROR (name);
      realnameoffile = name;
    }
  else
    ret = NULL;

  return ret;
}               /* end search */

FILE *
pksearch(path, file, mode, dpi, name_ret, dpi_ret)
        char *path, *file, *mode ;
	char **name_ret ;
	halfword dpi;
	int *dpi_ret ;
{
  FILE *ret;
  kpse_font_file_type font_file;
  string name = kpse_find_pk (file, dpi, &font_file);
  
  if (name)
    {
      ret = fopen (name, mode);
      if (!ret)
        FATAL_PERROR (name);
      realnameoffile = name;
      *name_ret = KPSE_FONT_FILE_NAME (font_file);
      *dpi_ret = KPSE_FONT_FILE_DPI (font_file);
    }
  else
    ret = NULL;

  return ret;
}               /* end search */

/* do we report file openings? */

#ifdef DEBUG
#  ifdef fopen
#    undef fopen
#  endif
#  ifdef VMCMS  /* IBM: VM/CMS */
#    define fopen cmsfopen
#  endif /* IBM: VM/CMS */
FILE *my_real_fopen(n, t)
register char *n, *t ;
{
   FILE *tf ;
   if (dd(D_FILES)) {
      fprintf(stderr, "<%s(%s)> ", n, t) ;
      tf = fopen(n, t) ;
      if (tf == 0)
         fprintf(stderr, "failed\n") ;
      else
         fprintf(stderr, "succeeded\n") ;
   } else
      tf = fopen(n, t) ;
   return tf ;
}
#endif
