/*
 ****************************************************************************
 *
 *	File:	previewer_cb.C
 *
 *	Functions(s):
 *
 *	Description:
 *		previewer callback stubs, generated by the OI UIB.
 *
 *	RCSid = "$Id: previewer_cb.C,v 1.1.1.1 1993/06/10 17:13:42 mth Exp $"
 *
 ****************************************************************************
 */
#include <OI/oi.H>
#include "previewer.H"
#include "previewer_bd.H"

/*
 *	The following definitions are generated and read by the user
 *	interface builder to simplify the process of generating prototype
 *	stubs.
 *
 *	The user interface builder will ONLY preserve prototype stubs placed
 *	above the dividing line (below).  If you need to include additional
 *	header files to ensure that your program compiles, please include 
 *	them in
 *		previewer.H
 *
 *	CAVEAT
 *		These definitions ensure that a prototype stub is not
 *		regenerated.   PLEASE leave the definition here
 *		even if you move the stub to another file.
 *	
 */

extern OI_ef_entry_chk_status new_file (OI_entry_field *, void *);


/* End of Function Declarations -- Protected User Code begins at next line */
/*
 ******************************************************************************
 *
 *	Function Name:	new_file
 *
 *	This function is called whenever entry is complete
 *	(return is pressed) on an entry field. This function
 *	returns a value of type OI_ef_entry_chk_status to
 *	indicate the validity of the entry.
 *		OI_EF_ENTRY_CHK_OK	: entry is ok
 *		OI_EF_ENTRY_CHK_BAD	: entry is invalid
 *	The bell is sounded when a return of OI_EF_ENTRY_CHK_BAD
 *	is made. The function may post error messages via
 *	push_help_str(), activate dialog boxes, or perform other
 *	actions.  If no error message is posted using
 *	push_help_str(), and a return of OI_EF_ENTRY_CHK_BAD is
 *	made, a generic message is displayed.
 *
 *	`efp' is a pointer to the object where the entry was
 *	just completed.  `argp' is the user supplied argument.
 *
 *	Returns:
 *		OI_ef_entry_chk_status : entry is valid or not
 *
 *	Side Effects:
 *		none.
 *
 *	Warnings:
 *		none.
 *
 ******************************************************************************
 */
OI_ef_entry_chk_status
new_file (
	OI_entry_field	*objp,		// (input) ptr to object clicked on
	void		* )		// (input) user supplied argument
{
 /*	External Variables */
 /*	External Procedures: */
 /*	Local Variables: */
 /*
	Procedure:
 */
	if (objp->part_text())
		scroll_text->set_text_to_file(
			OI_translate_filename( objp->part_text() ) );
	return( OI_EF_ENTRY_CHK_OK );
}

