#include <OI/oi.H>	/***  HiLiteC.C  ***/

main (int argc, char **argv)
{
		OI_connection	*conp;		// the connection to the server
		OI_app_window	*wp;		// the enclosing app window
		OI_static_text	*stp;		// the text label

		void		enter(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);
		void		leave(OI_d_tech*, const XEvent*, const char* const *, unsigned int*);

	static	OI_actions_rec	myactions[] = {
					{"enter",	enter },
					{"leave",	leave }
	};

	if ((conp = OI_init(&argc, argv, "HiLiteC"))) {
	        OI_add_actions(myactions, OI_count(myactions));
		wp = oi_create_app_window("main", 1, 1, "HiLiteC");
		wp->set_layout(OI_layout_row);
		stp = oi_create_static_text("my_text", " I have a border ");
		stp->set_bdr_width(4);
		stp->layout_associated_object(wp, 5, 5, OI_active);
		wp->set_associated_object(conp->root(), OI_def_loc, OI_def_loc, OI_active);
		stp->set_bdr_pixel(stp->bkg_pixel());
		OI_begin_interaction();
		OI_fini();
	}
}

static void
enter(OI_d_tech *objp, const XEvent *, const  char* const *, unsigned int *)
{
	objp->set_bdr_color("black");
	return;
}

static void
leave(OI_d_tech *objp, const XEvent *, const char* const *, unsigned int *)
{
	objp->set_bdr_pixel(objp->bkg_pixel());
	return;
}
