#include <OI/oi.H>			/* DialogLS.C */
int main (int argc, char** argv)
{
		OI_connection		*conp;
		OI_app_window		*wp;
		OI_button_menu		*bmp;
		OI_poly_check_menu	*pcmp;
		OI_menu_cell		*cellp;
		OI_dialog_box		*dbp;
	static	OI_cell_spec	ls_exit[] = {
		{"dir","ls"},
		{"exit","exit",(OI_action_fnp)OI_end_interaction},
		};
	static	OI_cell_spec	optns[] = {
		{"-c","-c  Sort by time of last edit"},
		{"-i","-i  Print i-number"},
		{"-l","-l  List in long format"},
		{"-r","-r  Reverse order of sort"},
		{"-u","-u  Sort by time of last access"},
		{"-1","-1  One entry per line output"},
		};
	
	if (conp = OI_init(&argc,argv,"AutoLS")) {
		wp = oi_create_app_window("main",1,1,"Auto ls");
		wp->set_layout(OI_layout_column);
		bmp = oi_create_button_menu("ls",OI_count(ls_exit),&ls_exit[0],OI_horizontal);
		wp->set_main_menu(bmp);
		dbp = oi_create_dialog_box("fork_ls",1,1);
		dbp->set_layout(OI_layout_column);
		dbp->set_associated_object(bmp->subobject("dir"),OI_def_loc,OI_def_loc,OI_active_not_displayed);
		pcmp = oi_create_poly_check_menu("ls_options",OI_count(optns),&optns[0],OI_vertical);
		pcmp->layout_associated_object(dbp,1,2,OI_active);
		pcmp->allow_user_arg();
		cellp = (OI_menu_cell*)dbp->buttons()->subobject("OK");
		cellp->change_action(dbp,(OI_action_memfnp)&(OI_dialog_box::fork_nowait),"ls $1");
		wp->set_associated_object(wp->root(),OI_def_loc,OI_def_loc,OI_active);
		OI_begin_interaction();
		OI_fini();
	}
}
